/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExporter
extends Exporter {
    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet();
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        String rowIndexVar = table.getRowIndexVar();
        if (preProcessor != null) {
            preProcessor.invoke(context.getELContext(), new Object[]{wb});
        }
        this.addFacetColumns(sheet, columns, Exporter.ColumnType.HEADER, 0);
        if (pageOnly) {
            this.exportPageOnly(context, table, columns, sheet);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, columns, sheet);
        } else {
            this.exportAll(context, table, columns, sheet);
        }
        if (this.hasColumnFooter(columns)) {
            this.addFacetColumns(sheet, columns, Exporter.ColumnType.FOOTER, sheet.getLastRowNum() + 1);
        }
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
        if (postProcessor != null) {
            postProcessor.invoke(context.getELContext(), new Object[]{wb});
        }
        this.writeExcelToResponse((HttpServletResponse)context.getExternalContext().getResponse(), (Workbook)wb, filename);
    }

    protected void exportPageOnly(FacesContext context, DataTable table, List<UIColumn> columns, Sheet sheet) {
        String rowIndexVar = table.getRowIndexVar();
        int numberOfColumns = columns.size();
        int first = table.getFirst();
        int rowsToExport = first + table.getRows();
        int sheetRowIndex = 1;
        for (int i = first; i < rowsToExport; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            if (rowIndexVar != null) {
                context.getExternalContext().getRequestMap().put(rowIndexVar, i);
            }
            Row row = sheet.createRow(sheetRowIndex++);
            for (int j = 0; j < numberOfColumns; ++j) {
                this.addColumnValue(row, columns.get(j).getChildren(), j);
            }
        }
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, List<UIColumn> columns, Sheet sheet) {
        int numberOfColumns = columns.size();
        Object selection = table.getSelection();
        boolean single = table.isSingleSelectionMode();
        int sheetRowIndex = 1;
        int size = selection == null ? 0 : (single ? 1 : Array.getLength(selection));
        for (int i = 0; i < size; ++i) {
            context.getExternalContext().getRequestMap().put(table.getVar(), single ? selection : Array.get(selection, i));
            Row row = sheet.createRow(sheetRowIndex++);
            for (int j = 0; j < numberOfColumns; ++j) {
                this.addColumnValue(row, columns.get(j).getChildren(), j);
            }
        }
    }

    protected void exportAll(FacesContext context, DataTable table, List<UIColumn> columns, Sheet sheet) {
        String rowIndexVar = table.getRowIndexVar();
        int numberOfColumns = columns.size();
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        int sheetRowIndex = 1;
        if (lazy) {
            for (int i = 0; i < rowCount; ++i) {
                if (i % rows == 0) {
                    table.setFirst(i);
                    table.loadLazyData();
                }
                table.setRowIndex(i);
                if (!table.isRowAvailable()) break;
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().put(rowIndexVar, i);
                }
                Row row = sheet.createRow(sheetRowIndex++);
                for (int j = 0; j < numberOfColumns; ++j) {
                    this.addColumnValue(row, columns.get(j).getChildren(), j);
                }
            }
            table.setFirst(first);
            table.loadLazyData();
        } else {
            for (int i = 0; i < rowCount; ++i) {
                table.setRowIndex(i);
                if (!table.isRowAvailable()) break;
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().put(rowIndexVar, i);
                }
                Row row = sheet.createRow(sheetRowIndex++);
                for (int j = 0; j < numberOfColumns; ++j) {
                    this.addColumnValue(row, columns.get(j).getChildren(), j);
                }
            }
            table.setFirst(first);
        }
    }

    protected void addFacetColumns(Sheet sheet, List<UIColumn> columns, Exporter.ColumnType columnType, int rowIndex) {
        Row rowHeader = sheet.createRow(rowIndex);
        for (int i = 0; i < columns.size(); ++i) {
            this.addColumnValue(rowHeader, columns.get(i).getFacet(columnType.facet()), i);
        }
    }

    protected void addColumnValue(Row row, UIComponent component, int index) {
        Cell cell = row.createCell(index);
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        cell.setCellValue((RichTextString)new HSSFRichTextString(value));
    }

    protected void addColumnValue(Row row, List<UIComponent> components, int index) {
        Cell cell = row.createCell(index);
        StringBuilder builder = new StringBuilder();
        for (UIComponent component : components) {
            String value;
            if (!component.isRendered() || (value = this.exportValue(FacesContext.getCurrentInstance(), component)) == null) continue;
            builder.append(value);
        }
        cell.setCellValue((RichTextString)new HSSFRichTextString(builder.toString()));
    }

    protected void writeExcelToResponse(HttpServletResponse response, Workbook generatedExcel, String filename) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + filename + ".xls");
        response.addCookie(new Cookie("primefaces.download", "true"));
        generatedExcel.write((OutputStream)response.getOutputStream());
    }
}

