/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVExporter
extends Exporter {
    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setContentType("text/csv");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + filename + ".csv");
        response.addCookie(new Cookie("primefaces.download", "true"));
        ServletOutputStream os = response.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, encodingType);
        PrintWriter writer = new PrintWriter(osw);
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        String rowIndexVar = table.getRowIndexVar();
        this.addFacetColumns(writer, columns, Exporter.ColumnType.HEADER);
        if (pageOnly) {
            this.exportPageOnly(context, table, columns, writer);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, columns, writer);
        } else {
            this.exportAll(context, table, columns, writer);
        }
        if (this.hasColumnFooter(columns)) {
            this.addFacetColumns(writer, columns, Exporter.ColumnType.FOOTER);
        }
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
        writer.flush();
        writer.close();
        response.getOutputStream().flush();
    }

    public void exportPageOnly(FacesContext context, DataTable table, List<UIColumn> columns, PrintWriter writer) throws IOException {
        int first = table.getFirst();
        int size = first + table.getRows();
        String rowIndexVar = table.getRowIndexVar();
        for (int i = first; i < size; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            if (rowIndexVar != null) {
                context.getExternalContext().getRequestMap().put(rowIndexVar, i);
            }
            this.addColumnValues(writer, columns);
            writer.write("\n");
        }
    }

    public void exportSelectionOnly(FacesContext context, DataTable table, List<UIColumn> columns, PrintWriter writer) throws IOException {
        Object selection = table.getSelection();
        boolean single = table.isSingleSelectionMode();
        int size = selection == null ? 0 : (single ? 1 : Array.getLength(selection));
        for (int i = 0; i < size; ++i) {
            context.getExternalContext().getRequestMap().put(table.getVar(), single ? selection : Array.get(selection, i));
            this.addColumnValues(writer, columns);
            writer.write("\n");
        }
    }

    public void exportAll(FacesContext context, DataTable table, List<UIColumn> columns, PrintWriter writer) throws IOException {
        String rowIndexVar = table.getRowIndexVar();
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            for (int i = 0; i < rowCount; ++i) {
                if (i % rows == 0) {
                    table.setFirst(i);
                    table.loadLazyData();
                }
                table.setRowIndex(i);
                if (!table.isRowAvailable()) break;
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().put(rowIndexVar, i);
                }
                this.addColumnValues(writer, columns);
                writer.write("\n");
            }
            table.setFirst(first);
            table.loadLazyData();
        } else {
            for (int i = 0; i < rowCount; ++i) {
                table.setRowIndex(i);
                if (!table.isRowAvailable()) break;
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().put(rowIndexVar, i);
                }
                this.addColumnValues(writer, columns);
                writer.write("\n");
            }
            table.setFirst(first);
        }
    }

    private void addColumnValues(PrintWriter writer, List<UIColumn> columns) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            this.addColumnValue(writer, iterator.next().getChildren());
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
    }

    private void addFacetColumns(PrintWriter writer, List<UIColumn> columns, Exporter.ColumnType columnType) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            this.addColumnValue(writer, iterator.next().getFacet(columnType.facet()));
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("\n");
    }

    private void addColumnValue(PrintWriter writer, UIComponent component) throws IOException {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        value = value.replaceAll("\"", "\"\"");
        writer.write("\"" + value + "\"");
    }

    private void addColumnValue(PrintWriter writer, List<UIComponent> components) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (UIComponent component : components) {
            if (!component.isRendered()) continue;
            String value = this.exportValue(FacesContext.getCurrentInstance(), component);
            value = value.replaceAll("\"", "\"\"");
            builder.append(value);
        }
        writer.write("\"" + builder.toString() + "\"");
    }
}

