/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dnd.Droppable;
import org.primefaces.renderkit.CoreRenderer;

public class DroppableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Droppable droppable = (Droppable)component;
        String target = this.findTarget(context, droppable).getClientId(context);
        String clientId = droppable.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Droppable','" + droppable.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",target:'" + target + "'");
        if (droppable.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (droppable.getHoverStyleClass() != null) {
            writer.write(",hoverClass:'" + droppable.getHoverStyleClass() + "'");
        }
        if (droppable.getActiveStyleClass() != null) {
            writer.write(",activeClass:'" + droppable.getActiveStyleClass() + "'");
        }
        if (droppable.getOnDrop() != null) {
            writer.write(",onDrop:" + droppable.getOnDrop());
        }
        if (droppable.getAccept() != null) {
            writer.write(",accept:'" + droppable.getAccept() + "'");
        }
        if (droppable.getScope() != null) {
            writer.write(",scope:'" + droppable.getScope() + "'");
        }
        if (droppable.getTolerance() != null) {
            writer.write(",tolerance:'" + droppable.getTolerance() + "'");
        }
        this.encodeClientBehaviors(context, droppable);
        writer.write("});});");
        this.endScript(writer);
    }

    protected UIComponent findTarget(FacesContext facesContext, Droppable droppable) {
        String _for = droppable.getFor();
        if (_for != null) {
            UIComponent component = droppable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component;
        }
        return droppable.getParent();
    }
}

