/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dialog;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dialog.Dialog;
import org.primefaces.renderkit.CoreRenderer;

public class DialogRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Dialog dialog = (Dialog)component;
        if (dialog.isContentLoadRequest(context)) {
            this.renderChildren(context, component);
        } else {
            this.encodeMarkup(context, dialog);
            this.encodeScript(context, dialog);
        }
    }

    protected void encodeScript(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Dialog','" + dialog.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (dialog.isVisible()) {
            writer.write(",autoOpen:true");
        }
        if (!dialog.isDraggable()) {
            writer.write(",draggable:false");
        }
        if (!dialog.isResizable()) {
            writer.write(",resizable:false");
        }
        if (dialog.isModal()) {
            writer.write(",modal:true");
        }
        if (dialog.getWidth() != null) {
            writer.write(",width:" + dialog.getWidth());
        }
        if (dialog.getHeight() != null) {
            writer.write(",height:" + dialog.getHeight());
        }
        if (dialog.getMinWidth() != Integer.MIN_VALUE) {
            writer.write(",minWidth:" + dialog.getMinWidth());
        }
        if (dialog.getMinHeight() != Integer.MIN_VALUE) {
            writer.write(",minHeight:" + dialog.getMinHeight());
        }
        if (dialog.isAppendToBody()) {
            writer.write(",appendToBody:true");
        }
        if (dialog.isDynamic()) {
            writer.write(",dynamic:true");
        }
        if (dialog.getShowEffect() != null) {
            writer.write(",showEffect:'" + dialog.getShowEffect() + "'");
        }
        if (dialog.getHideEffect() != null) {
            writer.write(",hideEffect:'" + dialog.getHideEffect() + "'");
        }
        if (dialog.getPosition() != null) {
            writer.write(",position:'" + dialog.getPosition() + "'");
        }
        if (dialog.getOnShow() != null) {
            writer.write(",onShow:function() {" + dialog.getOnShow() + "}");
        }
        if (dialog.getOnHide() != null) {
            writer.write(",onHide:function() {" + dialog.getOnHide() + "}");
        }
        this.encodeClientBehaviors(context, dialog);
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId(context);
        String style = dialog.getStyle();
        String styleClass = dialog.getStyleClass();
        styleClass = styleClass == null ? "ui-dialog ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow" : "ui-dialog ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow " + styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (dialog.isShowHeader()) {
            this.encodeHeader(context, dialog);
        }
        this.encodeContent(context, dialog);
        this.encodeFooter(context, dialog);
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String header = dialog.getHeader();
        UIComponent headerFacet = dialog.getFacet("header");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-titlebar ui-widget-header ui-helper-clearfix ui-corner-top", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-dialog-title", null);
        if (headerFacet != null) {
            headerFacet.encodeAll(context);
        } else if (header != null) {
            writer.write(header);
        }
        writer.endElement("span");
        if (dialog.isClosable()) {
            this.encodeIcon(context, "ui-dialog-titlebar-icon ui-dialog-titlebar-close ui-corner-all", "ui-icon ui-icon-closethick");
        }
        if (dialog.isMaximizable()) {
            this.encodeIcon(context, "ui-dialog-titlebar-icon ui-dialog-titlebar-maximize ui-corner-all", "ui-icon ui-icon-extlink");
        }
        if (dialog.isMinimizable()) {
            this.encodeIcon(context, "ui-dialog-titlebar-icon ui-dialog-titlebar-minimize ui-corner-all", "ui-icon ui-icon-minus");
        }
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String footer = dialog.getFooter();
        UIComponent footerFacet = dialog.getFacet("footer");
        if (footer == null && footerFacet == null) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-footer ui-widget-content", null);
        writer.startElement("span", null);
        if (footerFacet != null) {
            footerFacet.encodeAll(context);
        } else if (footer != null) {
            writer.write(footer);
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, Dialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dialog-content ui-widget-content", null);
        if (!dialog.isDynamic()) {
            this.renderChildren(context, (UIComponent)dialog);
        }
        writer.endElement("div");
    }

    protected void encodeIcon(FacesContext context, String anchorClass, String iconClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)anchorClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("a");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

