/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataHelper;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.paginator.PaginatorElementRenderer;
import org.primefaces.component.row.Row;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.model.SortOrder;
import org.primefaces.renderkit.DataRenderer;

public class DataTableRenderer
extends DataRenderer {
    protected DataHelper dataHelper = new DataHelper();

    public void decode(FacesContext context, UIComponent component) {
        DataTable table = (DataTable)component;
        boolean isSortRequest = table.isSortRequest(context);
        if (table.isDraggableColumns()) {
            table.syncColumnOrder();
        }
        if (table.isFilteringEnabled()) {
            this.dataHelper.decodeFilters(context, table);
            if (!isSortRequest && table.getValueExpression("sortBy") != null && !table.isLazy()) {
                this.sort(context, table);
            }
        }
        if (table.isSelectionEnabled()) {
            this.dataHelper.decodeSelection(context, table);
        }
        if (table.isPaginationRequest(context)) {
            this.dataHelper.decodePageRequest(context, table);
        } else if (isSortRequest) {
            this.dataHelper.decodeSortRequest(context, table);
        }
        this.decodeBehaviors(context, component);
        if (table.isPaginator()) {
            this.updatePaginationMetadata(context, table);
        }
        if (table.isLazy() && table.isBodyUpdate(context)) {
            table.loadLazyData();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataTable table = (DataTable)component;
        if (table.isBodyUpdate(context)) {
            this.encodeTbody(context, table, true);
        } else if (table.isRowExpansionRequest(context)) {
            this.encodeRowExpansion(context, table);
        } else if (table.isRowEditRequest(context)) {
            this.encodeEditedRow(context, table);
        } else if (table.isScrollingRequest(context)) {
            this.encodeLiveRows(context, table);
        } else {
            this.encodeMarkup(context, table);
            this.encodeScript(context, table);
        }
    }

    protected void encodeScript(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('DataTable','" + table.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (table.isPaginator()) {
            this.encodePaginatorConfig(context, table);
        }
        if (table.isRowSelectionEnabled()) {
            this.encodeSelectionConfig(context, table);
        }
        if (table.isColumnSelectionEnabled()) {
            writer.write(",columnSelectionMode:'" + table.getColumnSelectionMode() + "'");
        }
        if (table.isFilteringEnabled()) {
            writer.write(",filtering:true");
            writer.write(",filterEvent:'" + table.getFilterEvent() + "'");
        }
        if (table.getRowExpansion() != null) {
            writer.write(",expansion:true");
            if (table.getOnExpandStart() != null) {
                writer.write(",onExpandStart:function(row) {" + table.getOnExpandStart() + "}");
            }
        }
        if (table.isScrollable()) {
            writer.write(",scrollable:true");
            writer.write(",liveScroll:" + table.isLiveScroll());
            writer.write(",scrollStep:" + table.getScrollRows());
            writer.write(",scrollLimit:" + table.getRowCount());
            if (table.getScrollWidth() != Integer.MIN_VALUE) {
                writer.write(",scrollWidth:" + table.getScrollWidth());
            }
        }
        if (table.isResizableColumns()) {
            writer.write(",resizableColumns:true");
        }
        if (table.isDraggableColumns()) {
            writer.write(",draggableColumns:true");
        }
        if (table.isEditable()) {
            writer.write(",editable:true");
        }
        this.encodeClientBehaviors(context, table);
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        boolean scrollable = table.isScrollable();
        boolean hasPaginator = table.isPaginator();
        if (table.isLazy()) {
            table.loadLazyData();
        }
        String containerClass = scrollable ? "ui-datatable ui-widget ui-datatable-scrollable" : "ui-datatable ui-widget";
        containerClass = table.getStyleClass() != null ? containerClass + " " + table.getStyleClass() : containerClass;
        String style = null;
        if (table.isResizableColumns()) {
            containerClass = containerClass + " " + "ui-datatable-resizable";
        }
        if (!this.isPostBack() && table.getValueExpression("sortBy") != null && !table.isLazy()) {
            this.sort(context, table);
        }
        if (hasPaginator) {
            table.calculatePage();
        }
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, "styleClass");
        style = table.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (scrollable) {
            this.encodeScrollableTable(context, table);
        } else {
            this.encodeRegularTable(context, table);
        }
        if (table.isSelectionEnabled()) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_selection", table.getSelectedRowKeysAsString());
        }
        if (table.isDraggableColumns()) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_columnOrder", table.getColumnIds());
        }
        writer.endElement("div");
    }

    protected void encodeRegularTable(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (table.getTableStyle() != null) {
            writer.writeAttribute("style", (Object)table.getTableStyle(), null);
        }
        if (table.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)table.getTableStyleClass(), null);
        }
        this.encodeThead(context, table);
        this.encodeTFoot(context, table);
        this.encodeTbody(context, table, false);
        writer.endElement("table");
    }

    protected void encodeScrollableTable(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int scrollHeight = table.getScrollHeight();
        String tableStyle = table.getStyle();
        String tableStyleClass = table.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-widget-header ui-datatable-scrollable-header", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-header-box", null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (tableStyleClass != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
        this.encodeThead(context, table);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-body", null);
        if (scrollHeight != Integer.MIN_VALUE) {
            writer.writeAttribute("style", (Object)("height:" + scrollHeight + "px"), null);
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (table.getRowCount() == 0) {
            String string = tableStyle = tableStyle == null ? "width:100%" : tableStyle + ";width:100%";
        }
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (table.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
        this.encodeTbody(context, table, false);
        writer.endElement("table");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-widget-header ui-datatable-scrollable-footer", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-footer-box", null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (tableStyleClass != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
        this.encodeTFoot(context, table);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void encodeColumnHeader(FacesContext context, DataTable table, Column column) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = column.getClientId(context);
        ValueExpression tableSortByVe = table.getValueExpression("sortBy");
        ValueExpression columnSortByVe = column.getValueExpression("sortBy");
        boolean isSortable = columnSortByVe != null;
        boolean hasFilter = column.getValueExpression("filterBy") != null;
        String selectionMode = column.getSelectionMode();
        String sortIcon = isSortable ? "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s" : null;
        boolean resizable = table.isResizableColumns() && column.isResizable();
        String columnClass = isSortable ? "ui-state-default ui-sortable-column" : "ui-state-default";
        columnClass = hasFilter ? columnClass + " " + "ui-filter-column" : columnClass;
        columnClass = selectionMode != null ? columnClass + " " + "ui-selection-column" : columnClass;
        columnClass = resizable ? columnClass + " " + "ui-resizable-column" : columnClass;
        String string = columnClass = column.getStyleClass() != null ? columnClass + " " + column.getStyleClass() : columnClass;
        if (isSortable) {
            String tableSortByExpression;
            String columnSortByExpression = columnSortByVe.getExpressionString();
            if (tableSortByVe != null && (tableSortByExpression = tableSortByVe.getExpressionString()) != null && tableSortByExpression.equals(columnSortByExpression)) {
                String sortOrder = table.getSortOrder().toUpperCase();
                if (sortOrder.equals("ASCENDING")) {
                    sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
                } else if (sortOrder.equals("DESCENDING")) {
                    sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
                }
                columnClass = columnClass + " ui-state-active";
            }
        }
        writer.startElement("th", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)columnClass, null);
        writer.writeAttribute("role", (Object)"columnheader", null);
        if (column.getStyle() != null) {
            writer.writeAttribute("style", (Object)column.getStyle(), null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dt-c", null);
        if (selectionMode != null && selectionMode.equalsIgnoreCase("multiple")) {
            this.encodeCheckbox(context, table, false, column.isDisabledSelection(), "ui-chkbox ui-chkbox-all ui-widget");
        } else if (hasFilter) {
            table.enableFiltering();
            String filterPosition = column.getFilterPosition();
            if (filterPosition.equals("bottom")) {
                this.encodeColumnHeaderContent(context, column, sortIcon);
                this.encodeFilter(context, table, column);
            } else {
                if (!filterPosition.equals("top")) throw new FacesException(filterPosition + " is an invalid option for filterPosition, valid values are 'bottom' or 'top'.");
                this.encodeFilter(context, table, column);
                this.encodeColumnHeaderContent(context, column, sortIcon);
            }
        } else {
            this.encodeColumnHeaderContent(context, column, sortIcon);
        }
        writer.endElement("div");
        writer.endElement("th");
    }

    protected void encodeColumnHeaderContent(FacesContext context, Column column, String sortIcon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (sortIcon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)sortIcon, null);
            writer.endElement("span");
        }
        UIComponent header = column.getFacet("header");
        String headerText = column.getHeaderText();
        writer.startElement("span", null);
        if (header != null) {
            header.encodeAll(context);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("span");
    }

    protected void encodeColumnsHeader(FacesContext context, DataTable table, Columns columns) throws IOException {
        int colCount = ((List)columns.getValue()).size();
        for (int i = 0; i < colCount; ++i) {
            columns.setColIndex(i);
            this.encodeColumnHeader(context, table, columns);
        }
    }

    protected void encodeColumnsFooter(FacesContext context, DataTable table, Columns columns) throws IOException {
        int colCount = ((List)columns.getValue()).size();
        for (int i = 0; i < colCount; ++i) {
            columns.setColIndex(i);
            this.encodeColumnFooter(context, table, columns);
        }
    }

    protected void encodeFilter(FacesContext context, DataTable table, Column column) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        ResponseWriter writer = context.getResponseWriter();
        String filterId = column.getClientId(context) + "_filter";
        String filterValue = params.containsKey(filterId) ? (String)params.get(filterId) : "";
        String filterStyleClass = column.getFilterStyleClass();
        if (column.getValueExpression("filterOptions") == null) {
            filterStyleClass = filterStyleClass == null ? "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all" : "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all " + filterStyleClass;
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            writer.writeAttribute("value", (Object)filterValue, null);
            writer.writeAttribute("autocomplete", (Object)"off", null);
            if (column.getFilterStyle() != null) {
                writer.writeAttribute("style", (Object)column.getFilterStyle(), null);
            }
            if (column.getFilterMaxLength() != Integer.MAX_VALUE) {
                writer.writeAttribute("maxlength", (Object)column.getFilterMaxLength(), null);
            }
            writer.endElement("input");
        } else {
            SelectItem[] itemsArray;
            filterStyleClass = filterStyleClass == null ? "ui-column-filter" : "ui-column-filter " + filterStyleClass;
            writer.startElement("select", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            for (SelectItem item : itemsArray = this.getFilterOptions(column)) {
                Object itemValue = item.getValue();
                writer.startElement("option", null);
                writer.writeAttribute("value", item.getValue(), null);
                if (itemValue != null && String.valueOf(itemValue).equals(filterValue)) {
                    writer.writeAttribute("selected", (Object)"selected", null);
                }
                writer.writeText((Object)item.getLabel(), null);
                writer.endElement("option");
            }
            writer.endElement("select");
        }
    }

    protected SelectItem[] getFilterOptions(Column column) {
        Object options = column.getFilterOptions();
        if (options instanceof SelectItem[]) {
            return (SelectItem[])options;
        }
        if (options instanceof Collection) {
            return ((Collection)column.getFilterOptions()).toArray(new SelectItem[0]);
        }
        throw new FacesException("Filter options for column " + column.getClientId() + " should be a SelectItem array or collection");
    }

    protected void encodeColumnFooter(FacesContext context, DataTable table, Column column) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = column.getStyle();
        String styleClass = column.getStyleClass();
        styleClass = styleClass == null ? "ui-state-default" : "ui-state-default " + styleClass;
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-dt-c", null);
        UIComponent facet = column.getFacet("footer");
        String text = column.getFooterText();
        if (facet != null) {
            facet.encodeAll(context);
        } else if (text != null) {
            writer.write(text);
        }
        writer.endElement("div");
        writer.endElement("td");
    }

    protected void encodeThead(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("header");
        writer.startElement("thead", null);
        this.encodeFacet(context, table, table.getHeader(), "ui-datatable-header ui-widget-header", "th");
        if (table.isPaginator() && !table.getPaginatorPosition().equalsIgnoreCase("bottom")) {
            this.encodePaginatorMarkup(context, table, "top", "th", "ui-paginator ui-paginator-top ui-widget-header");
        }
        if (group != null && group.isRendered()) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row headerRow = (Row)child;
                writer.startElement("tr", null);
                for (UIComponent headerRowChild : headerRow.getChildren()) {
                    if (!headerRowChild.isRendered() || !(headerRowChild instanceof Column)) continue;
                    this.encodeColumnHeader(context, table, (Column)headerRowChild);
                }
                writer.endElement("tr");
            }
        } else {
            writer.startElement("tr", null);
            writer.writeAttribute("role", (Object)"row", null);
            for (Column column : table.getColumns()) {
                if (!column.isRendered()) continue;
                if (column instanceof Columns) {
                    this.encodeColumnsHeader(context, table, (Columns)column);
                    continue;
                }
                this.encodeColumnHeader(context, table, column);
            }
            writer.endElement("tr");
        }
        writer.endElement("thead");
    }

    protected void encodeTbody(FacesContext context, DataTable table, boolean dataOnly) throws IOException {
        String tbodyClass;
        ResponseWriter writer = context.getResponseWriter();
        String rowIndexVar = table.getRowIndexVar();
        String clientId = table.getClientId(context);
        String emptyMessage = table.getEmptyMessage();
        SubTable subTable = table.getSubTable();
        SummaryRow summaryRow = table.getSummaryRow();
        if (table.isSelectionEnabled()) {
            table.findSelectedRowKeys();
        }
        int rows = table.getRows();
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rowCountToRender = rows == 0 ? (table.isLiveScroll() ? table.getScrollRows() : rowCount) : rows;
        boolean hasData = rowCount > 0;
        String string = tbodyClass = hasData ? "ui-datatable-data ui-widget-content" : "ui-datatable-data-empty";
        if (!dataOnly) {
            writer.startElement("tbody", null);
            writer.writeAttribute("id", (Object)(clientId + "_data"), null);
            writer.writeAttribute("class", (Object)tbodyClass, null);
        }
        if (hasData) {
            for (int i = first; i < first + rowCountToRender; ++i) {
                if (subTable != null) {
                    this.encodeSubTable(context, table, subTable, i, rowIndexVar);
                    continue;
                }
                table.setRowIndex(i);
                if (table.isRowAvailable()) {
                    this.encodeRow(context, table, clientId, i, rowIndexVar);
                    if (summaryRow == null || this.dataHelper.isInSameGroup(context, table, i)) continue;
                    table.setRowIndex(i);
                    this.encodeSummaryRow(context, table, summaryRow);
                    continue;
                }
                break;
            }
        } else if (emptyMessage != null) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-content", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)table.getColumns().size(), null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-dt-c", null);
            writer.write(emptyMessage);
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
        }
        if (!dataOnly) {
            writer.endElement("tbody");
        }
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
    }

    private void encodeSummaryRow(FacesContext context, DataTable table, SummaryRow summaryRow) throws IOException {
        MethodExpression me = summaryRow.getListener();
        if (me != null) {
            me.invoke(context.getELContext(), new Object[]{table.getSortBy()});
        }
        summaryRow.encodeAll(context);
    }

    protected boolean encodeRow(FacesContext context, DataTable table, String clientId, int rowIndex, String rowIndexVar) throws IOException {
        String rowStyleClass;
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().put(rowIndexVar, rowIndex);
        }
        boolean selectionEnabled = table.isSelectionEnabled();
        Object rowKey = null;
        if (selectionEnabled && (rowKey = table.getRowKey()) == null) {
            rowKey = table.getRowKeyFromModel(table.getRowData());
        }
        boolean selected = table.getSelectedRowKeys().contains(rowKey);
        ResponseWriter writer = context.getResponseWriter();
        String userRowStyleClass = table.getRowStyleClass();
        String string = rowStyleClass = rowIndex % 2 == 0 ? "ui-widget-content ui-datatable-even" : "ui-widget-content ui-datatable-odd";
        if (selected) {
            rowStyleClass = rowStyleClass + " ui-state-highlight";
        }
        if (userRowStyleClass != null) {
            rowStyleClass = rowStyleClass + " " + userRowStyleClass;
        }
        writer.startElement("tr", null);
        writer.writeAttribute("data-ri", (Object)rowIndex, null);
        if (rowKey != null) {
            writer.writeAttribute("data-rk", rowKey, null);
        }
        writer.writeAttribute("class", (Object)rowStyleClass, null);
        writer.writeAttribute("role", (Object)"row", null);
        if (selectionEnabled) {
            writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
        }
        for (Column column : table.getColumns()) {
            if (!column.isRendered()) continue;
            if (column instanceof Columns) {
                this.encodeDynamicCell(context, table, (Columns)column);
                continue;
            }
            this.encodeRegularCell(context, table, column, clientId, selected);
        }
        writer.endElement("tr");
        return true;
    }

    protected void encodeRegularCell(FacesContext context, DataTable table, Column column, String clientId, boolean selected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean selectionEnabled = column.getSelectionMode() != null;
        String style = column.getStyle();
        String styleClass = "";
        if (selectionEnabled) {
            styleClass = "ui-selection-column";
        } else if (column.getCellEditor() != null) {
            styleClass = "ui-editable-column";
        }
        styleClass = column.getStyleClass() == null ? styleClass : styleClass + " " + column.getStyleClass();
        writer.startElement("td", null);
        writer.writeAttribute("role", (Object)"gridcell", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (!this.isValueBlank(styleClass)) {
            writer.writeAttribute("class", (Object)styleClass.trim(), null);
        }
        if (selectionEnabled) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-dt-c", null);
            this.encodeColumnSelection(context, table, clientId, column, selected);
            writer.endElement("div");
        } else {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-dt-c", null);
            column.encodeAll(context);
            writer.endElement("div");
        }
        writer.endElement("td");
    }

    protected void encodeDynamicCell(FacesContext context, DataTable table, Columns columns) throws IOException {
        int colCount = ((List)columns.getValue()).size();
        for (int i = 0; i < colCount; ++i) {
            columns.setColIndex(i);
            this.encodeRegularCell(context, table, columns, null, false);
        }
    }

    protected void encodeTFoot(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("footer");
        writer.startElement("tfoot", null);
        if (group != null && group.isRendered()) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row footerRow = (Row)child;
                writer.startElement("tr", null);
                for (UIComponent footerRowChild : footerRow.getChildren()) {
                    if (!footerRowChild.isRendered() || !(footerRowChild instanceof Column)) continue;
                    this.encodeColumnFooter(context, table, (Column)footerRowChild);
                }
                writer.endElement("tr");
            }
        } else if (table.hasFooterColumn()) {
            writer.startElement("tr", null);
            for (Column column : table.getColumns()) {
                if (!column.isRendered()) continue;
                if (column instanceof Columns) {
                    this.encodeColumnsFooter(context, table, (Columns)column);
                    continue;
                }
                this.encodeColumnFooter(context, table, column);
            }
            writer.endElement("tr");
        }
        if (table.isPaginator() && !table.getPaginatorPosition().equalsIgnoreCase("top")) {
            this.encodePaginatorMarkup(context, table, "bottom", "td", "ui-paginator ui-paginator-bottom ui-widget-header");
        }
        this.encodeFacet(context, table, table.getFooter(), "ui-datatable-footer ui-widget-header", "td");
        writer.endElement("tfoot");
    }

    protected void encodeFacet(FacesContext context, DataTable table, UIComponent facet, String styleClass, String tag) throws IOException {
        if (facet == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        writer.startElement(tag, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("colspan", (Object)table.getColumnsCount(), null);
        facet.encodeAll(context);
        writer.endElement(tag);
        writer.endElement("tr");
    }

    protected void encodePaginatorMarkup(FacesContext context, DataTable table, String position, String tag, String styleClass) throws IOException {
        String[] elements;
        ResponseWriter writer = context.getResponseWriter();
        if (!table.isPaginatorAlwaysVisible() && table.getPageCount() <= 1) {
            return;
        }
        String id = table.getClientId(context) + "_paginator_" + position;
        writer.startElement("tr", null);
        writer.startElement(tag, null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("colspan", (Object)table.getColumnsCount(), null);
        for (String element : elements = table.getPaginatorTemplate().split(" ")) {
            PaginatorElementRenderer renderer = (PaginatorElementRenderer)this.paginatorElements.get(element);
            if (renderer != null) {
                renderer.render(context, table);
                continue;
            }
            writer.write(element + " ");
        }
        writer.endElement(tag);
        writer.endElement("tr");
    }

    protected void encodeSelectionConfig(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",selectionMode:'" + table.getSelectionMode() + "'");
        if (table.isDblClickSelect()) {
            writer.write(",dblclickSelect:true");
        }
    }

    protected void encodeStateHolder(FacesContext context, DataTable table, String id, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeRowExpansion(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map params = context.getExternalContext().getRequestParameterMap();
        int expandedRowIndex = Integer.parseInt((String)params.get(table.getClientId(context) + "_expandedRowIndex"));
        String rowIndexVar = table.getRowIndexVar();
        table.setRowIndex(expandedRowIndex);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().put(rowIndexVar, expandedRowIndex);
        }
        writer.startElement("tr", null);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.writeAttribute("class", (Object)"ui-expanded-row-content ui-widget-content", null);
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)table.getColumnsCount(), null);
        table.getRowExpansion().encodeAll(context);
        writer.endElement("td");
        writer.endElement("tr");
        table.setRowIndex(-1);
    }

    protected void encodeColumnSelection(FacesContext context, DataTable table, String clientId, Column column, boolean selected) throws IOException {
        String selectionMode = column.getSelectionMode();
        boolean disabled = column.isDisabledSelection();
        if (selectionMode.equalsIgnoreCase("single")) {
            this.encodeRadio(context, table, selected, disabled);
        } else if (selectionMode.equalsIgnoreCase("multiple")) {
            this.encodeCheckbox(context, table, selected, disabled, "ui-chkbox ui-widget");
        } else {
            throw new FacesException("Invalid column selection mode:" + selectionMode);
        }
    }

    protected void encodeRadio(FacesContext context, DataTable table, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String boxClass = "ui-radiobutton-box ui-widget ui-corner-all ui-radiobutton-relative ui-state-default";
        String iconClass = "ui-radiobutton-icon";
        boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
        boxClass = checked ? boxClass + " ui-state-active" : boxClass;
        iconClass = checked ? iconClass + " " + "ui-icon ui-icon-bullet" : iconClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-radiobutton ui-widget", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeCheckbox(FacesContext context, DataTable table, boolean checked, boolean disabled, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String boxClass = "ui-chkbox-box ui-widget ui-corner-all ui-state-default";
        String iconClass = "ui-chkbox-icon";
        boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
        boxClass = checked ? boxClass + " ui-state-active" : boxClass;
        iconClass = checked ? iconClass + " " + "ui-icon ui-icon-check" : iconClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeEditedRow(FacesContext context, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        int editedRowId = Integer.parseInt((String)params.get(table.getClientId(context) + "_editedRowIndex"));
        table.setRowIndex(editedRowId);
        if (table.isRowAvailable()) {
            this.encodeRow(context, table, table.getClientId(context), editedRowId, table.getRowIndexVar());
        }
    }

    protected void encodeLiveRows(FacesContext context, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        int scrollOffset = Integer.parseInt((String)params.get(table.getClientId(context) + "_scrollOffset"));
        String clientId = table.getClientId(context);
        String rowIndexVar = table.getRowIndexVar();
        for (int i = scrollOffset; i < scrollOffset + table.getScrollRows(); ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) continue;
            this.encodeRow(context, table, clientId, i, rowIndexVar);
        }
    }

    protected void updatePaginationMetadata(FacesContext context, DataTable table) {
        ELContext elContext = context.getELContext();
        ValueExpression firstVe = table.getValueExpression("first");
        ValueExpression rowsVe = table.getValueExpression("rows");
        ValueExpression pageVE = table.getValueExpression("page");
        if (firstVe != null && !firstVe.isReadOnly(elContext)) {
            firstVe.setValue(context.getELContext(), (Object)table.getFirst());
        }
        if (rowsVe != null && !rowsVe.isReadOnly(elContext)) {
            rowsVe.setValue(context.getELContext(), (Object)table.getRows());
        }
        if (pageVE != null && !pageVE.isReadOnly(elContext)) {
            pageVE.setValue(context.getELContext(), (Object)table.getPage());
        }
    }

    protected void sort(FacesContext context, DataTable table) {
        this.dataHelper.sort(context, table, table.getValueExpression("sortBy"), table.getVar(), SortOrder.valueOf(table.getSortOrder().toUpperCase(Locale.ENGLISH)), table.getSortFunction());
    }

    protected void encodeSubTable(FacesContext context, DataTable table, SubTable subTable, int rowIndex, String rowIndexVar) throws IOException {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().put(rowIndexVar, rowIndex);
        }
        subTable.encodeAll(context);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
    }
}

