/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.model.DataModel;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.Widget;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.row.Row;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.context.RequestContext;
import org.primefaces.event.ColumnResizeEvent;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.event.data.FilterEvent;
import org.primefaces.event.data.PageEvent;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SelectableDataModel;
import org.primefaces.model.SelectableDataModelWrapper;
import org.primefaces.model.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class DataTable
extends UIData
implements Widget,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataTable";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.DataTableRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.component.";
    private static final Logger logger = Logger.getLogger(DataTable.class.getName());
    public static final String CONTAINER_CLASS = "ui-datatable ui-widget";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String COLUMN_HEADER_CONTAINER_CLASS = "ui-header-column";
    public static final String COLUMN_FOOTER_CLASS = "ui-state-default";
    public static final String COLUMN_FOOTER_CONTAINER_CLASS = "ui-footer-column";
    public static final String DATA_CLASS = "ui-datatable-data ui-widget-content";
    public static final String EMPTY_DATA_CLASS = "ui-datatable-data-empty";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String HEADER_CLASS = "ui-datatable-header ui-widget-header";
    public static final String FOOTER_CLASS = "ui-datatable-footer ui-widget-header";
    public static final String SORTABLE_COLUMN_CLASS = "ui-sortable-column";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String SORTABLE_COLUMN_ASCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
    public static final String SORTABLE_COLUMN_DESCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
    public static final String FILTER_COLUMN_CLASS = "ui-filter-column";
    public static final String COLUMN_FILTER_CLASS = "ui-column-filter";
    public static final String COLUMN_INPUT_FILTER_CLASS = "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
    public static final String RESIZABLE_COLUMN_CLASS = "ui-resizable-column";
    public static final String EXPANDED_ROW_CLASS = "ui-expanded-row";
    public static final String EXPANDED_ROW_CONTENT_CLASS = "ui-expanded-row-content";
    public static final String ROW_TOGGLER_CLASS = "ui-row-toggler";
    public static final String EDITABLE_COLUMN_CLASS = "ui-editable-column";
    public static final String CELL_EDITOR_CLASS = "ui-cell-editor";
    public static final String CELL_EDITOR_INPUT_CLASS = "ui-cell-editor-input";
    public static final String CELL_EDITOR_OUTPUT_CLASS = "ui-cell-editor-output";
    public static final String ROW_EDITOR_COLUMN_CLASS = "ui-row-editor-column";
    public static final String ROW_EDITOR_CLASS = "ui-row-editor";
    public static final String SELECTION_COLUMN_CLASS = "ui-selection-column";
    public static final String EVEN_ROW_CLASS = "ui-datatable-even";
    public static final String ODD_ROW_CLASS = "ui-datatable-odd";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-datatable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-widget-header ui-datatable-scrollable-header";
    public static final String SCROLLABLE_HEADER_BOX_CLASS = "ui-datatable-scrollable-header-box";
    public static final String SCROLLABLE_BODY_CLASS = "ui-datatable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-widget-header ui-datatable-scrollable-footer";
    public static final String SCROLLABLE_FOOTER_BOX_CLASS = "ui-datatable-scrollable-footer-box";
    public static final String COLUMN_RESIZER_CLASS = "ui-column-resizer";
    public static final String RESIZABLE_CONTAINER_CLASS = "ui-datatable-resizable";
    public static final String COLUMN_CONTENT_WRAPPER = "ui-dt-c";
    public static final String SUBTABLE_HEADER = "ui-datatable-subtable-header";
    public static final String SUBTABLE_FOOTER = "ui-datatable-subtable-footer";
    public static final String SUMMARY_ROW_CLASS = "ui-datatable-summaryrow ui-widget-header";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("page", "sort", "filter", "rowSelect", "rowUnselect", "rowEdit", "colResize", "toggleSelect", "colReorder"));
    public List<Column> columns;
    private Boolean pageRequest = null;
    private Boolean sortRequest = null;
    private Boolean filterRequest = null;
    private Boolean clearFiltersRequest = null;
    private Map<String, Column> filterMap;
    private List filteredData;
    private SelectableDataModelWrapper selectableDataModelWrapper = null;
    private List<Object> selectedRowKeys = new ArrayList<Object>();
    private int columnsCount = -1;

    public DataTable() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
        this.handleAttribute("widgetVar", _widgetVar);
    }

    public boolean isScrollable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollable), (Object)false);
    }

    public void setScrollable(boolean _scrollable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollable), (Object)_scrollable);
        this.handleAttribute("scrollable", _scrollable);
    }

    public int getScrollHeight() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollHeight), (Object)Integer.MIN_VALUE);
    }

    public void setScrollHeight(int _scrollHeight) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollHeight), (Object)_scrollHeight);
        this.handleAttribute("scrollHeight", _scrollHeight);
    }

    public int getScrollWidth() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollWidth), (Object)Integer.MIN_VALUE);
    }

    public void setScrollWidth(int _scrollWidth) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollWidth), (Object)_scrollWidth);
        this.handleAttribute("scrollWidth", _scrollWidth);
    }

    public String getSelectionMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectionMode), null);
    }

    public void setSelectionMode(String _selectionMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectionMode), (Object)_selectionMode);
        this.handleAttribute("selectionMode", _selectionMode);
    }

    public Object getSelection() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selection), null);
    }

    public void setSelection(Object _selection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selection), _selection);
        this.handleAttribute("selection", _selection);
    }

    public String getRowIndexVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowIndexVar), null);
    }

    public void setRowIndexVar(String _rowIndexVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndexVar), (Object)_rowIndexVar);
        this.handleAttribute("rowIndexVar", _rowIndexVar);
    }

    public String getEmptyMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), (Object)"No records found.");
    }

    public void setEmptyMessage(String _emptyMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)_emptyMessage);
        this.handleAttribute("emptyMessage", _emptyMessage);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
        this.handleAttribute("style", _style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
        this.handleAttribute("styleClass", _styleClass);
    }

    public boolean isDblClickSelect() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dblClickSelect), (Object)false);
    }

    public void setDblClickSelect(boolean _dblClickSelect) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dblClickSelect), (Object)_dblClickSelect);
        this.handleAttribute("dblClickSelect", _dblClickSelect);
    }

    public boolean isLiveScroll() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveScroll), (Object)false);
    }

    public void setLiveScroll(boolean _liveScroll) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveScroll), (Object)_liveScroll);
        this.handleAttribute("liveScroll", _liveScroll);
    }

    public String getRowStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowStyleClass), null);
    }

    public void setRowStyleClass(String _rowStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStyleClass), (Object)_rowStyleClass);
        this.handleAttribute("rowStyleClass", _rowStyleClass);
    }

    public String getOnExpandStart() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onExpandStart), null);
    }

    public void setOnExpandStart(String _onExpandStart) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onExpandStart), (Object)_onExpandStart);
        this.handleAttribute("onExpandStart", _onExpandStart);
    }

    public boolean isResizableColumns() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.resizableColumns), (Object)false);
    }

    public void setResizableColumns(boolean _resizableColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.resizableColumns), (Object)_resizableColumns);
        this.handleAttribute("resizableColumns", _resizableColumns);
    }

    public Object getSortBy() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortBy), null);
    }

    public void setSortBy(Object _sortBy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortBy), _sortBy);
        this.handleAttribute("sortBy", _sortBy);
    }

    public String getSortOrder() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortOrder), (Object)"ascending");
    }

    public void setSortOrder(String _sortOrder) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortOrder), (Object)_sortOrder);
        this.handleAttribute("sortOrder", _sortOrder);
    }

    public MethodExpression getSortFunction() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sortFunction), null);
    }

    public void setSortFunction(MethodExpression _sortFunction) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sortFunction), (Object)_sortFunction);
        this.handleAttribute("sortFunction", _sortFunction);
    }

    public int getScrollRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollRows), (Object)0);
    }

    public void setScrollRows(int _scrollRows) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollRows), (Object)_scrollRows);
        this.handleAttribute("scrollRows", _scrollRows);
    }

    public Object getRowKey() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowKey), null);
    }

    public void setRowKey(Object _rowKey) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowKey), _rowKey);
        this.handleAttribute("rowKey", _rowKey);
    }

    public String getFilterEvent() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.filterEvent), (Object)"keyup");
    }

    public void setFilterEvent(String _filterEvent) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.filterEvent), (Object)_filterEvent);
        this.handleAttribute("filterEvent", _filterEvent);
    }

    public String getTableStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyle), null);
    }

    public void setTableStyle(String _tableStyle) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyle), (Object)_tableStyle);
        this.handleAttribute("tableStyle", _tableStyle);
    }

    public String getTableStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tableStyleClass), null);
    }

    public void setTableStyleClass(String _tableStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tableStyleClass), (Object)_tableStyleClass);
        this.handleAttribute("tableStyleClass", _tableStyleClass);
    }

    public boolean isDraggableColumns() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.draggableColumns), (Object)false);
    }

    public void setDraggableColumns(boolean _draggableColumns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.draggableColumns), (Object)_draggableColumns);
        this.handleAttribute("draggableColumns", _draggableColumns);
    }

    public boolean isEditable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.editable), (Object)false);
    }

    public void setEditable(boolean _editable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.editable), (Object)_editable);
        this.handleAttribute("editable", _editable);
    }

    public List<Column> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
            for (UIComponent child : this.getChildren()) {
                if (!child.isRendered() || !(child instanceof Column)) continue;
                this.columns.add((Column)child);
            }
        }
        return this.columns;
    }

    public boolean isPaginationRequest(FacesContext context) {
        if (this.pageRequest == null) {
            Map params = context.getExternalContext().getRequestParameterMap();
            this.pageRequest = params.containsKey(this.getClientId(context) + "_paging");
        }
        return this.pageRequest;
    }

    public boolean isSortRequest(FacesContext context) {
        if (this.sortRequest == null) {
            Map params = context.getExternalContext().getRequestParameterMap();
            this.sortRequest = params.containsKey(this.getClientId(context) + "_sorting");
        }
        return this.sortRequest;
    }

    public boolean isFilterRequest(FacesContext context) {
        if (this.filterRequest == null) {
            Map params = context.getExternalContext().getRequestParameterMap();
            this.filterRequest = params.containsKey(this.getClientId(context) + "_filtering");
        }
        return this.filterRequest;
    }

    public boolean isGlobalFilterRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_globalFilter");
    }

    public boolean isInstantSelectionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_instantSelectedRowIndex");
    }

    public boolean isInstantUnselectionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_instantUnselectedRowIndex");
    }

    public boolean isRowExpansionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowExpansion");
    }

    public boolean isRowEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEdit");
    }

    public boolean isScrollingRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_scrolling");
    }

    public Map<String, Column> getFilterMap() {
        block7: {
            if (this.filterMap != null) break block7;
            this.filterMap = new HashMap<String, Column>();
            ColumnGroup group = this.getColumnGroup("header");
            if (group != null) {
                for (UIComponent child : group.getChildren()) {
                    Row headerRow = (Row)child;
                    if (!headerRow.isRendered()) continue;
                    for (UIComponent headerRowChild : headerRow.getChildren()) {
                        Column column = (Column)headerRowChild;
                        if (!column.isRendered() || column.getValueExpression("filterBy") == null) continue;
                        this.filterMap.put(column.getClientId(FacesContext.getCurrentInstance()) + "_filter", column);
                    }
                }
            } else {
                for (UIComponent child : this.getChildren()) {
                    Column column;
                    if (child instanceof Columns) {
                        Columns columns = (Columns)child;
                        List columnModel = (List)columns.getValue();
                        if (columnModel == null || columns.getValueExpression("filterBy") == null) continue;
                        for (int i = 0; i < columnModel.size(); ++i) {
                            columns.setColIndex(i);
                            this.filterMap.put(columns.getClientId(FacesContext.getCurrentInstance()) + "_filter", columns);
                        }
                        columns.setColIndex(-1);
                        continue;
                    }
                    if (!(child instanceof Column) || (column = (Column)child).getValueExpression("filterBy") == null) continue;
                    this.filterMap.put(column.getClientId(FacesContext.getCurrentInstance()) + "_filter", column);
                }
            }
        }
        return this.filterMap;
    }

    public boolean hasFilter() {
        return this.getFilterMap().size() > 0;
    }

    public boolean isRowSelectionEnabled() {
        return this.getSelectionMode() != null;
    }

    public boolean isColumnSelectionEnabled() {
        return this.getColumnSelectionMode() != null;
    }

    public String getColumnSelectionMode() {
        for (Column column : this.getColumns()) {
            String selectionMode = column.getSelectionMode();
            if (selectionMode == null) continue;
            return selectionMode;
        }
        return null;
    }

    public boolean isSelectionEnabled() {
        return this.isRowSelectionEnabled() || this.isColumnSelectionEnabled();
    }

    public boolean isSingleSelectionMode() {
        String selectionMode = this.getSelectionMode();
        String columnSelectionMode = this.getColumnSelectionMode();
        if (selectionMode != null) {
            return selectionMode.equalsIgnoreCase("single");
        }
        if (columnSelectionMode != null) {
            return columnSelectionMode.equalsIgnoreCase("single");
        }
        return false;
    }

    public void processDecodes(FacesContext context) {
        String clientId = this.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (this.isBodyUpdate(context)) {
            this.decode(context);
        } else if (params.containsKey(clientId + "_rowEditCancel")) {
            context.renderResponse();
        } else {
            super.processDecodes(context);
        }
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        ValueExpression selectionVE = this.getValueExpression("selection");
        if (selectionVE != null) {
            selectionVE.setValue(context.getELContext(), this.getLocalSelection());
            this.setSelection(null);
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.isRequestSource(context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("rowSelect")) {
                String rowKey = (String)params.get(clientId + "_instantSelectedRowKey");
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if (eventName.equals("rowUnselect")) {
                String rowKey = (String)params.get(clientId + "_instantUnselectedRowKey");
                wrapperEvent = new UnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if (eventName.equals("page")) {
                wrapperEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getPage());
            } else if (eventName.equals("sort")) {
                SortOrder order = SortOrder.valueOf((String)params.get(clientId + "_sortDir"));
                Column sortColumn = this.findColumn((String)params.get(clientId + "_sortKey"));
                wrapperEvent = new SortEvent((UIComponent)this, behaviorEvent.getBehavior(), sortColumn, order);
            } else if (eventName.equals("filter")) {
                wrapperEvent = new FilterEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getFilteredData(), this.getFilters());
            } else if (eventName.equals("rowEdit")) {
                int editedRowIndex = Integer.parseInt((String)params.get(clientId + "_editedRowIndex"));
                this.setRowIndex(editedRowIndex);
                wrapperEvent = new RowEditEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData());
            } else if (eventName.equals("colResize")) {
                String columnId = (String)params.get(clientId + "_columnId");
                int width = Integer.parseInt((String)params.get(clientId + "_width"));
                int height = Integer.parseInt((String)params.get(clientId + "_height"));
                wrapperEvent = new ColumnResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), width, height, this.findColumn(columnId));
            } else if (eventName.equals("toggleSelect")) {
                wrapperEvent = behaviorEvent;
            } else if (eventName.equals("colReorder")) {
                wrapperEvent = behaviorEvent;
            }
            wrapperEvent.setPhaseId(event.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    private Column findColumn(String clientId) {
        for (Column column : this.getColumns()) {
            if (!column.getClientId().equals(clientId)) continue;
            return column;
        }
        return null;
    }

    public ColumnGroup getColumnGroup(String target) {
        for (UIComponent child : this.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public boolean hasFooterColumn() {
        for (Column column : this.getColumns()) {
            if (column.getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model != null && model instanceof LazyDataModel) {
            RequestContext requestContext;
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = lazyModel.load(this.getFirst(), this.getRows(), this.resolveSortField(this.getValueExpression("sortBy")), this.convertSortOrder(), this.getFilters());
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (this.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    protected SortOrder convertSortOrder() {
        String sortOrder = this.getSortOrder();
        if (sortOrder == null) {
            return SortOrder.UNSORTED;
        }
        return SortOrder.valueOf(sortOrder.toUpperCase(Locale.ENGLISH));
    }

    protected String resolveSortField(ValueExpression expression) {
        if (expression != null) {
            String expressionString = expression.getExpressionString();
            expressionString = expressionString.substring(2, expressionString.length() - 1);
            return expressionString.substring(expressionString.indexOf(".") + 1);
        }
        return null;
    }

    public void clearLazyCache() {
        LazyDataModel model = (LazyDataModel)this.getDataModel();
        model.setWrappedData(null);
    }

    public Map<String, String> getFilters() {
        return (Map)this.getStateHelper().eval((Serializable)((Object)"filters"), new HashMap());
    }

    public void setFilters(Map<String, String> filters) {
        this.getStateHelper().put((Serializable)((Object)"filters"), filters);
    }

    public void resetValue() {
        this.setValue(null);
    }

    public void reset() {
        this.resetValue();
        this.setFirst(0);
    }

    public boolean isFilteringEnabled() {
        Object value = this.getStateHelper().get((Serializable)((Object)"filtering"));
        return value != null;
    }

    public void enableFiltering() {
        this.getStateHelper().put((Serializable)((Object)"filtering"), (Object)true);
    }

    public RowExpansion getRowExpansion() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof RowExpansion)) continue;
            return (RowExpansion)kid;
        }
        return null;
    }

    public void setFilteredData(List list) {
        this.filteredData = list;
    }

    public List getFilteredData() {
        return this.filteredData;
    }

    public Object getValue() {
        Object value = super.getValue();
        if (this.filteredData != null) {
            if (value instanceof SelectableDataModel) {
                return this.selectableDataModelWrapper == null ? (this.selectableDataModelWrapper = new SelectableDataModelWrapper((SelectableDataModel)value, this.filteredData)) : this.selectableDataModelWrapper;
            }
            return this.filteredData;
        }
        return value;
    }

    public Object getLocalSelection() {
        return this.getStateHelper().get((Serializable)((Object)PropertyKeys.selection));
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isRequestSource(FacesContext context) {
        String partialSource = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.source");
        return partialSource != null && this.getClientId(context).startsWith(partialSource);
    }

    public boolean isBodyUpdate(FacesContext context) {
        String clientId = this.getClientId(context);
        return context.getExternalContext().getRequestParameterMap().containsKey(clientId + "_updateBody");
    }

    public SubTable getSubTable() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof SubTable)) continue;
            return (SubTable)kid;
        }
        return null;
    }

    public Object getRowKeyFromModel(Object object) {
        DataModel model = this.getDataModel();
        if (!(model instanceof SelectableDataModel)) {
            throw new FacesException("DataModel must implement org.primefaces.model.SelectableDataModel when selection is enabled.");
        }
        return ((SelectableDataModel)this.getDataModel()).getRowKey(object);
    }

    public Object getRowData(String rowKey) {
        boolean hasRowKeyVe;
        boolean bl = hasRowKeyVe = this.getValueExpression("rowKey") != null;
        if (hasRowKeyVe) {
            Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            String var = this.getVar();
            Collection data = (Collection)this.getDataModel().getWrappedData();
            for (Object object : data) {
                requestMap.put(var, object);
                if (!String.valueOf(this.getRowKey()).equals(rowKey)) continue;
                return object;
            }
            return null;
        }
        DataModel model = this.getDataModel();
        if (!(model instanceof SelectableDataModel)) {
            throw new FacesException("DataModel must implement org.primefaces.model.SelectableDataModel when selection is enabled or you need to define rowKey attribute");
        }
        return ((SelectableDataModel)this.getDataModel()).getRowData(rowKey);
    }

    void findSelectedRowKeys() {
        Object selection = this.getSelection();
        this.selectedRowKeys = new ArrayList<Object>();
        boolean hasRowKeyVe = this.getValueExpression("rowKey") != null;
        String var = this.getVar();
        Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        if (this.isSelectionEnabled() && selection != null) {
            if (this.isSingleSelectionMode()) {
                if (hasRowKeyVe) {
                    requestMap.put(var, selection);
                    this.selectedRowKeys.add(this.getRowKey());
                } else {
                    this.selectedRowKeys.add(this.getRowKeyFromModel(selection));
                }
            } else {
                for (int i = 0; i < Array.getLength(selection); ++i) {
                    if (hasRowKeyVe) {
                        requestMap.put(var, Array.get(selection, i));
                        this.selectedRowKeys.add(this.getRowKey());
                        continue;
                    }
                    this.selectedRowKeys.add(this.getRowKeyFromModel(Array.get(selection, i)));
                }
            }
        }
    }

    List<Object> getSelectedRowKeys() {
        return this.selectedRowKeys;
    }

    String getSelectedRowKeysAsString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Object> iter = this.getSelectedRowKeys().iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public SummaryRow getSummaryRow() {
        for (UIComponent kid : this.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof SummaryRow)) continue;
            return (SummaryRow)kid;
        }
        return null;
    }

    public int getColumnsCount() {
        if (this.columnsCount == -1) {
            this.columnsCount = 0;
            for (UIComponent kid : this.getChildren()) {
                if (!kid.isRendered()) continue;
                if (kid instanceof Columns) {
                    Columns uicolumns = (Columns)kid;
                    Collection collection = (Collection)uicolumns.getValue();
                    if (collection == null) continue;
                    this.columnsCount += collection.size();
                    continue;
                }
                if (kid instanceof Column) {
                    ++this.columnsCount;
                    continue;
                }
                if (!(kid instanceof SubTable)) continue;
                SubTable subTable = (SubTable)kid;
                for (UIComponent subTableKid : subTable.getChildren()) {
                    if (!subTableKid.isRendered() || !(subTableKid instanceof Column)) continue;
                    ++this.columnsCount;
                }
            }
        }
        return this.columnsCount;
    }

    @Override
    public boolean isLazy() {
        Class type;
        ValueExpression ve = this.getValueExpression("value");
        return ve != null && (type = ve.getType(FacesContext.getCurrentInstance().getELContext())) != null && LazyDataModel.class.isAssignableFrom(type);
    }

    public void setLazy(boolean value) {
        logger.info("Lazy attribute has been removed from datatable api, please also remove it from your page definition. See issue #2993.");
    }

    public void syncColumnOrder() {
        FacesContext context = FacesContext.getCurrentInstance();
        List<Column> actualColumns = this.getColumns();
        Map params = context.getExternalContext().getRequestParameterMap();
        String[] order = ((String)params.get(this.getClientId(context) + "_columnOrder")).split(",");
        UIComponent firstChild = (UIComponent)actualColumns.get(0);
        if (firstChild instanceof Columns) {
            Columns uicolumns = (Columns)firstChild;
            List model = (List)uicolumns.getValue();
            ArrayList orderedModel = new ArrayList();
            for (String columnId : order) {
                int colIndex = Integer.parseInt(columnId.split("_colIndex_")[1]);
                orderedModel.add(model.get(colIndex));
            }
            uicolumns.getValueExpression("value").setValue(context.getELContext(), orderedModel);
        } else {
            ArrayList<Column> orderedColumns = new ArrayList<Column>();
            block1: for (String columnId : order) {
                for (Column column : actualColumns) {
                    if (!columnId.equals(column.getClientId(context))) continue;
                    orderedColumns.add(column);
                    continue block1;
                }
            }
            this.columns = orderedColumns;
        }
    }

    public String getColumnIds() {
        StringBuilder builder = new StringBuilder();
        List<Column> cols = this.getColumns();
        Iterator<Column> iter = cols.iterator();
        while (iter.hasNext()) {
            Column column = iter.next();
            if (column instanceof Columns) {
                Columns uicolumns = (Columns)column;
                List model = (List)uicolumns.getValue();
                int size = model.size();
                if (model == null) continue;
                for (int i = 0; i < size; ++i) {
                    uicolumns.setColIndex(i);
                    builder.append(uicolumns.getClientId());
                    if (i == size - 1) continue;
                    builder.append(",");
                }
                continue;
            }
            builder.append(column.getClientId());
            if (!iter.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = this.getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            ValueExpression ve = this.getValueExpression(name);
            if (ve == null) {
                setAttributes.remove(name);
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        scrollable,
        scrollHeight,
        scrollWidth,
        selectionMode,
        selection,
        rowIndexVar,
        emptyMessage,
        style,
        styleClass,
        dblClickSelect,
        liveScroll,
        rowStyleClass,
        onExpandStart,
        resizableColumns,
        sortBy,
        sortOrder,
        sortFunction,
        scrollRows,
        rowKey,
        filterEvent,
        tableStyle,
        tableStyleClass,
        draggableColumns,
        editable;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

