/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.model.ListDataModel;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.row.Row;
import org.primefaces.context.RequestContext;
import org.primefaces.model.BeanPropertyComparator;
import org.primefaces.model.SortOrder;

class DataHelper {
    DataHelper() {
    }

    void decodePageRequest(FacesContext context, DataTable table) {
        table.setRowIndex(-1);
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String firstParam = (String)params.get(clientId + "_first");
        String rowsParam = (String)params.get(clientId + "_rows");
        table.setFirst(Integer.valueOf(firstParam));
        table.setRows(Integer.valueOf(rowsParam));
    }

    void decodeSortRequest(FacesContext context, DataTable table) {
        Column sortColumn;
        String sortDir;
        block9: {
            table.setRowIndex(-1);
            String clientId = table.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            String sortKey = (String)params.get(clientId + "_sortKey");
            sortDir = (String)params.get(clientId + "_sortDir");
            sortColumn = null;
            if (sortKey.indexOf("_colIndex") == -1) {
                ColumnGroup group = table.getColumnGroup("header");
                if (group != null) {
                    for (UIComponent child : group.getChildren()) {
                        Row headerRow = (Row)child;
                        for (UIComponent headerRowChild : headerRow.getChildren()) {
                            Column column = (Column)headerRowChild;
                            if (!column.getClientId(context).equals(sortKey)) continue;
                            sortColumn = column;
                            break block9;
                        }
                    }
                } else {
                    for (Column column : table.getColumns()) {
                        if (!column.getClientId(context).equals(sortKey)) continue;
                        sortColumn = column;
                        break;
                    }
                }
            } else {
                int colIndex = Integer.parseInt(sortKey.split("_colIndex_")[1]);
                Columns columns = null;
                for (UIComponent child : table.getChildren()) {
                    if (!(child instanceof Columns)) continue;
                    columns = (Columns)child;
                    break;
                }
                columns.setColIndex(colIndex);
                sortColumn = columns;
            }
        }
        table.setFirst(0);
        ValueExpression sortByVE = sortColumn.getValueExpression("sortBy");
        table.setValueExpression("sortBy", sortByVE);
        table.setSortOrder(sortDir);
        if (!table.isLazy()) {
            this.sort(context, table, sortByVE, table.getVar(), SortOrder.valueOf(sortDir), sortColumn.getSortFunction());
        }
    }

    void sort(FacesContext context, DataTable table, ValueExpression sortByVE, String var, SortOrder sortOrder, MethodExpression sortFunction) {
        Object value = table.getValue();
        List list = null;
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            list = (List)value;
        } else if (value instanceof ListDataModel) {
            list = (List)((ListDataModel)value).getWrappedData();
        } else {
            throw new FacesException("Data type should be java.util.List or javax.faces.model.ListDataModel instance to be sortable.");
        }
        Collections.sort(list, new BeanPropertyComparator(sortByVE, var, sortOrder, sortFunction));
    }

    void decodeFilters(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String globalFilterParam = clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter";
        boolean hasGlobalFilter = params.containsKey(globalFilterParam);
        if (table.isFilterRequest(context)) {
            table.setFirst(0);
        }
        HashMap<String, String> filters = new HashMap<String, String>();
        Map<String, Column> filterMap = table.getFilterMap();
        for (String filterName : filterMap.keySet()) {
            Column column = filterMap.get(filterName);
            String filterValue = (String)params.get(filterName);
            if (this.isValueBlank(filterValue)) continue;
            String filterField = this.resolveField(column.getValueExpression("filterBy"));
            filters.put(filterField, filterValue);
        }
        if (hasGlobalFilter) {
            filters.put("globalFilter", (String)params.get(globalFilterParam));
        }
        table.setFilters(filters);
        if (!table.isLazy()) {
            RequestContext requestContext;
            boolean isAllFiltered;
            ArrayList<Object> filteredData = new ArrayList<Object>();
            String globalFilter = hasGlobalFilter ? ((String)params.get(globalFilterParam)).toLowerCase() : null;
            for (int i = 0; i < table.getRowCount(); ++i) {
                table.setRowIndex(i);
                boolean localMatch = true;
                boolean globalMatch = false;
                for (String filterName : filterMap.keySet()) {
                    String columnFilter;
                    Column column = filterMap.get(filterName);
                    String string = columnFilter = params.containsKey(filterName) ? ((String)params.get(filterName)).toLowerCase() : null;
                    if (column instanceof Columns) {
                        Columns columns = (Columns)column;
                        int colIndex = Integer.parseInt(filterName.split("_colIndex_")[1].split("_filter")[0]);
                        columns.setColIndex(colIndex);
                    }
                    String columnValue = String.valueOf(column.getValueExpression("filterBy").getValue(context.getELContext()));
                    if (hasGlobalFilter && !globalMatch && columnValue != null && columnValue.toLowerCase().contains(globalFilter)) {
                        globalMatch = true;
                    }
                    if (this.isValueBlank(columnFilter)) {
                        localMatch = true;
                        continue;
                    }
                    if (columnValue != null && column.getFilterConstraint().applies(columnValue.toLowerCase(), columnFilter)) continue;
                    localMatch = false;
                    break;
                }
                boolean matches = localMatch;
                if (hasGlobalFilter) {
                    boolean bl = matches = localMatch && globalMatch;
                }
                if (!matches) continue;
                filteredData.add(table.getRowData());
            }
            boolean bl = isAllFiltered = filteredData.size() == table.getRowCount();
            if (table.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
                int totalRecords = isAllFiltered ? table.getRowCount() : filteredData.size();
                requestContext.addCallbackParam("totalRecords", totalRecords);
            }
            if (!isAllFiltered) {
                table.setFilteredData(filteredData);
            }
            table.setRowIndex(-1);
        }
    }

    public boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    void decodeSelection(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String selection = (String)params.get(clientId + "_selection");
        if (table.isSingleSelectionMode()) {
            this.decodeSingleSelection(table, selection);
        } else {
            this.decodeMultipleSelection(table, selection);
        }
    }

    void decodeSingleSelection(DataTable table, String selection) {
        if (this.isValueBlank(selection)) {
            table.setSelection(null);
        } else {
            table.setSelection(table.getRowData(selection));
        }
    }

    void decodeMultipleSelection(DataTable table, String selection) {
        Class clazz = table.getValueExpression("selection").getType(FacesContext.getCurrentInstance().getELContext());
        if (this.isValueBlank(selection)) {
            Object data = Array.newInstance(clazz.getComponentType(), 0);
            table.setSelection(data);
        } else {
            String[] rowKeys = selection.split(",");
            ArrayList<Object> selectionList = new ArrayList<Object>();
            for (int i = 0; i < rowKeys.length; ++i) {
                Object rowData = table.getRowData(rowKeys[i]);
                if (rowData == null) continue;
                selectionList.add(rowData);
            }
            Object selectinArray = Array.newInstance(clazz.getComponentType(), selectionList.size());
            table.setSelection(selectionList.toArray((Object[])selectinArray));
        }
    }

    String resolveField(ValueExpression expression) {
        Object newValue = expression.getValue(FacesContext.getCurrentInstance().getELContext());
        if (newValue == null || !(newValue instanceof String)) {
            String expressionString = expression.getExpressionString();
            expressionString = expressionString.substring(2, expressionString.length() - 1);
            return expressionString.substring(expressionString.indexOf(".") + 1);
        }
        String val = (String)newValue;
        return val.substring(val.indexOf(".") + 1);
    }

    boolean isInSameGroup(FacesContext context, DataTable table, int currentRowIndex) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String var = table.getVar();
        table.setRowIndex(currentRowIndex);
        Object currentGroupByData = table.getSortBy();
        table.setRowIndex(currentRowIndex + 1);
        if (!table.isRowAvailable()) {
            return false;
        }
        Object nextGroupByData = table.getSortBy();
        return currentGroupByData != null && nextGroupByData.equals(currentGroupByData);
    }
}

