/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datalist;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datalist.DataList;
import org.primefaces.renderkit.DataRenderer;

public class DataListRenderer
extends DataRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Map params = context.getExternalContext().getRequestParameterMap();
        DataList list = (DataList)component;
        String clientId = list.getClientId();
        if (list.isPagingRequest(context)) {
            list.setFirst(Integer.valueOf((String)params.get(clientId + "_first")));
            list.setRows(Integer.valueOf((String)params.get(clientId + "_rows")));
            if (list.isLazy()) {
                list.loadLazyData();
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataList list;
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        boolean isAjaxPaging = params.containsKey((clientId = (list = (DataList)component).getClientId()) + "_ajaxPaging");
        if (isAjaxPaging) {
            if (list.getType().equals("none")) {
                this.encodeFreeList(context, list);
            } else {
                this.encodeStrictList(context, list);
            }
        } else {
            this.encodeMarkup(context, list);
            this.encodeScript(context, list);
        }
    }

    protected void encodeMarkup(FacesContext context, DataList list) throws IOException {
        if (list.isLazy()) {
            list.loadLazyData();
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = list.getClientId();
        boolean hasPaginator = list.isPaginator();
        String paginatorPosition = list.getPaginatorPosition();
        String styleClass = list.getStyleClass() == null ? "ui-datalist ui-widget" : "ui-datalist ui-widget " + list.getStyleClass();
        UIComponent header = list.getHeader();
        if (hasPaginator) {
            list.calculatePage();
        }
        writer.startElement("div", (UIComponent)list);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (header != null) {
            writer.startElement("div", (UIComponent)list);
            writer.writeAttribute("class", (Object)"ui-datalist-header ui-widget-header ui-corner-top", "styleClass");
            header.encodeAll(context);
            writer.endElement("div");
        }
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            this.encodePaginatorMarkup(context, list, "top");
        }
        writer.startElement("div", (UIComponent)list);
        writer.writeAttribute("id", (Object)(clientId + "_content"), "id");
        writer.writeAttribute("class", (Object)"ui-datalist-content ui-widget-content", "styleClass");
        if (list.getType().equals("none")) {
            this.encodeFreeList(context, list);
        } else {
            this.encodeStrictList(context, list);
        }
        writer.endElement("div");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            this.encodePaginatorMarkup(context, list, "bottom");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, DataList list) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = list.getClientId();
        this.startScript(writer, clientId);
        writer.write("$(function() { ");
        writer.write("PrimeFaces.cw('DataList','" + list.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (list.isPaginator()) {
            this.encodePaginatorConfig(context, list);
        }
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeStrictList(FacesContext context, DataList list) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = list.getClientId();
        boolean isDefinition = list.isDefinition();
        UIComponent definition = list.getFacet("description");
        String listTag = list.getListTag();
        String listItemTag = isDefinition ? "dt" : "li";
        String varStatus = list.getVarStatus();
        int first = list.getFirst();
        int rows = list.getRows() == 0 ? list.getRowCount() : list.getRows();
        int pageSize = first + rows;
        int rowCount = list.getRowCount();
        String rowIndexVar = list.getRowIndexVar();
        Map requestMap = context.getExternalContext().getRequestMap();
        writer.startElement(listTag, null);
        writer.writeAttribute("id", (Object)(clientId + "_list"), null);
        writer.writeAttribute("class", (Object)"ui-datalist-data", null);
        if (list.getItemType() != null) {
            writer.writeAttribute("type", (Object)list.getItemType(), null);
        }
        for (int i = first; i < pageSize; ++i) {
            if (varStatus != null) {
                requestMap.put(varStatus, new VarStatus(first, pageSize - 1, i == 0, i == rowCount - 1, i, i % 2 == 0, i % 2 == 1, 1));
            }
            list.setRowIndex(i);
            if (rowIndexVar != null) {
                requestMap.put(rowIndexVar, i);
            }
            if (!list.isRowAvailable()) continue;
            writer.startElement(listItemTag, null);
            writer.writeAttribute("class", (Object)"ui-datalist-item", null);
            this.renderChildren(context, (UIComponent)list);
            writer.endElement(listItemTag);
            if (!isDefinition) continue;
            writer.startElement("dd", null);
            definition.encodeAll(context);
            writer.endElement("dd");
        }
        list.setRowIndex(-1);
        if (rowIndexVar != null) {
            requestMap.remove(rowIndexVar);
        }
        if (varStatus != null) {
            requestMap.remove(varStatus);
        }
        writer.endElement(listTag);
    }

    protected void encodeFreeList(FacesContext context, DataList list) throws IOException {
        int first = list.getFirst();
        int rows = list.getRows() == 0 ? list.getRowCount() : list.getRows();
        String rowIndexVar = list.getRowIndexVar();
        Map requestMap = context.getExternalContext().getRequestMap();
        for (int i = first; i < first + rows; ++i) {
            list.setRowIndex(i);
            if (rowIndexVar != null) {
                requestMap.put(rowIndexVar, i);
            }
            if (!list.isRowAvailable()) continue;
            this.renderChildren(context, (UIComponent)list);
        }
        list.setRowIndex(-1);
        if (rowIndexVar != null) {
            requestMap.remove(rowIndexVar);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public static class VarStatus {
        private int begin;
        private int end;
        private boolean first;
        private boolean last;
        private int index;
        private boolean even;
        private boolean odd;
        private int step;

        public VarStatus() {
        }

        public VarStatus(int begin, int end, boolean first, boolean last, int index, boolean even, boolean odd, int step) {
            this.begin = begin;
            this.end = end;
            this.first = first;
            this.last = last;
            this.index = index;
            this.even = even;
            this.odd = odd;
            this.step = step;
        }

        public int getBegin() {
            return this.begin;
        }

        public void setBegin(int begin) {
            this.begin = begin;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public boolean isEven() {
            return this.even;
        }

        public void setEven(boolean even) {
            this.even = even;
        }

        public boolean isFirst() {
            return this.first;
        }

        public void setFirst(boolean first) {
            this.first = first;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isLast() {
            return this.last;
        }

        public void setLast(boolean last) {
            this.last = last;
        }

        public boolean isOdd() {
            return this.odd;
        }

        public void setOdd(boolean odd) {
            this.odd = odd;
        }

        public int getStep() {
            return this.step;
        }

        public void setStep(int step) {
            this.step = step;
        }
    }
}

