/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datalist;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.model.DataModel;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.Widget;
import org.primefaces.context.RequestContext;
import org.primefaces.model.LazyDataModel;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class DataList
extends UIData
implements Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataList";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.DataListRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.component.";
    public static final String DATALIST_CLASS = "ui-datalist ui-widget";
    public static final String HEADER_CLASS = "ui-datalist-header ui-widget-header ui-corner-top";
    public static final String CONTENT_CLASS = "ui-datalist-content ui-widget-content";
    public static final String LIST_CLASS = "ui-datalist-data";
    public static final String LIST_ITEM_CLASS = "ui-datalist-item";

    public DataList() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
        this.handleAttribute("widgetVar", _widgetVar);
    }

    public String getType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.type), (Object)"unordered");
    }

    public void setType(String _type) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.type), (Object)_type);
        this.handleAttribute("type", _type);
    }

    public String getItemType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.itemType), null);
    }

    public void setItemType(String _itemType) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.itemType), (Object)_itemType);
        this.handleAttribute("itemType", _itemType);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
        this.handleAttribute("style", _style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
        this.handleAttribute("styleClass", _styleClass);
    }

    public String getRowIndexVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowIndexVar), null);
    }

    public void setRowIndexVar(String _rowIndexVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndexVar), (Object)_rowIndexVar);
        this.handleAttribute("rowIndexVar", _rowIndexVar);
    }

    public String getVarStatus() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.varStatus), null);
    }

    public void setVarStatus(String _varStatus) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.varStatus), (Object)_varStatus);
        this.handleAttribute("varStatus", _varStatus);
    }

    public String getListTag() {
        String type = this.getType();
        if (type.equalsIgnoreCase("unordered")) {
            return "ul";
        }
        if (type.equalsIgnoreCase("ordered")) {
            return "ol";
        }
        if (type.equalsIgnoreCase("definition")) {
            return "dl";
        }
        if (type.equalsIgnoreCase("none")) {
            return null;
        }
        throw new FacesException("DataList '" + this.getClientId() + "' has invalid list type:'" + type + "'");
    }

    public boolean isDefinition() {
        return this.getType().equalsIgnoreCase("definition");
    }

    public boolean isPagingRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_ajaxPaging");
    }

    protected void updatePaginationMetadata(FacesContext context) {
        ValueExpression firstVe = this.getValueExpression("first");
        ValueExpression rowsVe = this.getValueExpression("rows");
        ValueExpression pageVE = this.getValueExpression("page");
        if (firstVe != null) {
            firstVe.setValue(context.getELContext(), (Object)this.getFirst());
        }
        if (rowsVe != null) {
            rowsVe.setValue(context.getELContext(), (Object)this.getRows());
        }
        if (pageVE != null) {
            pageVE.setValue(context.getELContext(), (Object)this.getPage());
        }
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        if (this.isPagingRequest(context)) {
            this.decode(context);
            this.updatePaginationMetadata(context);
            context.renderResponse();
        } else if (this.getVar() == null) {
            this.pushComponentToEL(context, (UIComponent)this);
            this.iterateChildren(context, PhaseId.APPLY_REQUEST_VALUES);
            this.decode(context);
            this.popComponentFromEL(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        if (this.getVar() == null) {
            this.pushComponentToEL(context, (UIComponent)this);
            this.iterateChildren(context, PhaseId.PROCESS_VALIDATIONS);
            this.popComponentFromEL(context);
        } else {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        if (this.getVar() == null) {
            this.pushComponentToEL(context, (UIComponent)this);
            this.iterateChildren(context, PhaseId.UPDATE_MODEL_VALUES);
            this.popComponentFromEL(context);
        } else {
            super.processUpdates(context);
        }
    }

    protected void iterateChildren(FacesContext context, PhaseId phaseId) {
        this.setRowIndex(-1);
        if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    kid.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    kid.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    kid.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        if (this.getVar() != null) {
            super.queueEvent(event);
        } else {
            if (event == null) {
                throw new NullPointerException();
            }
            UIComponent parent = this.getParent();
            if (parent == null) {
                throw new IllegalStateException();
            }
            parent.queueEvent(event);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (this.getVar() != null) {
            super.broadcast(event);
        } else {
            if (event == null) {
                throw new NullPointerException();
            }
            if (event instanceof BehaviorEvent) {
                BehaviorEvent behaviorEvent = (BehaviorEvent)event;
                Behavior behavior = behaviorEvent.getBehavior();
                behavior.broadcast(behaviorEvent);
            }
        }
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model != null && model instanceof LazyDataModel) {
            RequestContext requestContext;
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = lazyModel.load(this.getFirst(), this.getRows(), null, null, null);
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (this.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = this.getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            ValueExpression ve = this.getValueExpression(name);
            if (ve == null) {
                setAttributes.remove(name);
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        type,
        itemType,
        style,
        styleClass,
        rowIndexVar,
        varStatus;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

