/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datagrid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.Widget;
import org.primefaces.context.RequestContext;
import org.primefaces.model.LazyDataModel;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class DataGrid
extends UIData
implements Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataGrid";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.DataGridRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.component.";
    public static final String DATAGRID_CLASS = "ui-datagrid ui-widget";
    public static final String CONTENT_CLASS = "ui-datagrid-content ui-widget-content";
    public static final String EMPTY_CONTENT_CLASS = "ui-datagrid-content  ui-datagrid-content-empty ui-widget-content";
    public static final String TABLE_CLASS = "ui-datagrid-data";
    public static final String TABLE_ROW_CLASS = "ui-datagrid-row";
    public static final String TABLE_COLUMN_CLASS = "ui-datagrid-column";

    public DataGrid() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
        this.handleAttribute("widgetVar", _widgetVar);
    }

    public int getColumns() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.columns), (Object)3);
    }

    public void setColumns(int _columns) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.columns), (Object)_columns);
        this.handleAttribute("columns", _columns);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
        this.handleAttribute("style", _style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
        this.handleAttribute("styleClass", _styleClass);
    }

    public String getRowIndexVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowIndexVar), null);
    }

    public void setRowIndexVar(String _rowIndexVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndexVar), (Object)_rowIndexVar);
        this.handleAttribute("rowIndexVar", _rowIndexVar);
    }

    public String getEmptyMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), (Object)"No records found.");
    }

    public void setEmptyMessage(String _emptyMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)_emptyMessage);
        this.handleAttribute("emptyMessage", _emptyMessage);
    }

    public boolean isPagingRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_ajaxPaging");
    }

    protected void updatePaginationMetadata(FacesContext context) {
        ValueExpression firstVe = this.getValueExpression("first");
        ValueExpression rowsVe = this.getValueExpression("rows");
        ValueExpression pageVE = this.getValueExpression("page");
        if (firstVe != null) {
            firstVe.setValue(context.getELContext(), (Object)this.getFirst());
        }
        if (rowsVe != null) {
            rowsVe.setValue(context.getELContext(), (Object)this.getRows());
        }
        if (pageVE != null) {
            pageVE.setValue(context.getELContext(), (Object)this.getPage());
        }
    }

    public void processDecodes(FacesContext context) {
        if (this.isPagingRequest(context)) {
            this.decode(context);
            this.updatePaginationMetadata(context);
            context.renderResponse();
        } else {
            super.processDecodes(context);
        }
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model != null && model instanceof LazyDataModel) {
            RequestContext requestContext;
            LazyDataModel lazyModel = (LazyDataModel)model;
            List data = lazyModel.load(this.getFirst(), this.getRows(), null, null, null);
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (this.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
                requestContext.addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = this.getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            ValueExpression ve = this.getValueExpression(name);
            if (ve == null) {
                setAttributes.remove(name);
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        columns,
        style,
        styleClass,
        rowIndexVar,
        emptyMessage;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

