/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.contextmenu;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.contextmenu.ContextMenu;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.separator.Separator;

public class ContextMenuRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ContextMenu menu = (ContextMenu)abstractMenu;
        String widgetVar = menu.resolveWidgetVar();
        String clientId = menu.getClientId(context);
        String target = this.findTarget(context, menu);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('ContextMenu','" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",target:" + target);
        if (menu.getNodeType() != null) {
            writer.write(",nodeType:'" + menu.getNodeType() + "'");
        }
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ContextMenu menu = (ContextMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-menu ui-menu-dynamic ui-contextmenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix" : "ui-menu ui-menu-dynamic ui-contextmenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix " + styleClass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("role", (Object)"menu", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        for (UIComponent child : menu.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, (MenuItem)child);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)child);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected String findTarget(FacesContext context, ContextMenu menu) {
        Object trigger = null;
        String _for = menu.getFor();
        if (_for != null) {
            UIComponent forComponent = menu.findComponent(_for);
            if (forComponent == null) {
                throw new FacesException("Cannot find component '" + _for + "' in view.");
            }
            return "'" + forComponent.getClientId(context) + "'";
        }
        return "document";
    }
}

