/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandbutton;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.commandbutton.CommandButton;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class CommandButtonRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        CommandButton button = (CommandButton)component;
        if (button.isDisabled()) {
            return;
        }
        String param = component.getClientId(context);
        if (context.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CommandButton button = (CommandButton)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, CommandButton button) throws IOException {
        String onclickBehaviors;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String type = button.getType();
        String value = (String)button.getValue();
        String icon = button.resolveIcon();
        StringBuilder onclick = new StringBuilder();
        if (button.getOnclick() != null) {
            onclick.append(button.getOnclick()).append(";");
        }
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("class", (Object)button.resolveStyleClass(), "styleClass");
        if (!type.equals("reset") && !type.equals("button")) {
            UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)button);
            if (form == null) {
                throw new FacesException("CommandButton : \"" + clientId + "\" must be inside a form element");
            }
            String formClientId = form.getClientId(context);
            String request = button.isAjax() ? this.buildAjaxRequest(context, button) : this.buildNonAjaxRequest(context, (UIComponent)button, formClientId);
            onclick.append(request);
        }
        if ((onclickBehaviors = this.getOnclickBehaviors(context, (ClientBehaviorHolder)button)) != null) {
            onclick.append(onclickBehaviors).append(";");
        }
        if (onclick.length() > 0) {
            writer.writeAttribute("onclick", (Object)onclick.toString(), "onclick");
        }
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (button.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (icon != null) {
            String defaultIconClass = button.getIconPos().equals("left") ? "ui-button-icon-left ui-icon" : "ui-button-icon-right ui-icon";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        if (value == null) {
            writer.write("ui-button");
        } else {
            writer.writeText((Object)value, "value");
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeScript(FacesContext context, CommandButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String type = button.getType();
        boolean hasValue = button.getValue() != null;
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('CommandButton','" + button.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write("});");
        this.endScript(writer);
    }

    protected String buildNonAjaxRequest(FacesContext facesContext, UIComponent component, String formId) {
        StringBuilder request = new StringBuilder();
        HashMap<String, String> params = new HashMap<String, String>();
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            params.put(param.getName(), String.valueOf(param.getValue()));
        }
        if (!params.isEmpty()) {
            request.append("PrimeFaces.addSubmitParam('").append(formId).append("',{");
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)params.get(key);
                request.append("'").append(key).append("':'").append(value).append("'");
                if (!it.hasNext()) continue;
                request.append(",");
            }
            request.append("});");
        }
        return request.toString();
    }
}

