/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.pie;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.pie.PieChart;
import org.primefaces.model.chart.PieChartModel;

public class PieChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        PieChart chart = (PieChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        PieChart chart = (PieChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('PieChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeData(context, chart);
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeData(FacesContext context, PieChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",data:[[");
        PieChartModel model = (PieChartModel)chart.getValue();
        Iterator<String> it = model.getData().keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            Number value = model.getData().get(key);
            writer.write("[\"" + this.escapeText(key) + "\"," + value + "]");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]]");
    }

    protected void encodeOptions(FacesContext context, PieChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.encodeCommonConfig(context, chart);
        if (chart.getDiameter() != Integer.MIN_VALUE) {
            writer.write(",diameter:" + chart.getDiameter());
        }
        if (chart.getSliceMargin() != 0) {
            writer.write(",sliceMargin:" + chart.getSliceMargin());
        }
        if (!chart.isFill()) {
            writer.write(",fill:false");
        }
        if (chart.isShowDataLabels()) {
            writer.write(",showDataLabels:true");
        }
        if (chart.getDataFormat() != null) {
            writer.write(",dataFormat:'" + chart.getDataFormat() + "'");
        }
    }
}

