/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.ohlc;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.ohlc.OhlcChart;

public class OhlcChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OhlcChart chart = (OhlcChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        OhlcChart chart = (OhlcChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('OhlcChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeData(context, chart);
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeOptions(FacesContext context, OhlcChart chart) throws IOException {
        this.encodeCommonConfig(context, chart);
        this.encodeSeriesDefaults(context, chart);
    }

    protected void encodeSeriesDefaults(FacesContext context, OhlcChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write(", seriesDefaults : { renderer: $.jqplot.OHLCRenderer, rendererOptions : {");
        if (chart.isCandleStick()) {
            writer.write("candleStick:true");
        }
        writer.write("}}");
    }

    private void encodeData(FacesContext context, OhlcChart chart) throws IOException {
        context.getResponseWriter().write(",data:[" + chart.getValue().toString() + "]");
    }
}

