/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.metergauge;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.metergauge.MeterGaugeChart;
import org.primefaces.model.chart.MeterGaugeChartModel;

public class MeterGaugeChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MeterGaugeChart chart = (MeterGaugeChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MeterGaugeChart chart = (MeterGaugeChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('MeterGaugeChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeOptions(FacesContext context, MeterGaugeChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MeterGaugeChartModel model = chart.getValue();
        writer.write(",data:[[" + model.getValue() + "]]");
        this.encodeCommonConfig(context, chart);
        writer.write(",seriesDefaults : {renderer: $.jqplot.MeterGaugeRenderer, rendererOptions : {");
        writer.write("intervals:" + model.getIntervals().toString());
        writer.write(",label:'" + model.getLabel() + "'");
        if (!chart.isShowTickLabels()) {
            writer.write(",showTickLabels:false");
        }
        writer.write(",labelHeightAdjust:" + chart.getLabelHeightAdjust());
        writer.write(",intervalOuterRadius:" + chart.getIntervalOuterRadius());
        writer.write("}}");
    }
}

