/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.line;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.line.LineChart;
import org.primefaces.model.chart.CartesianChartModel;
import org.primefaces.model.chart.ChartSeries;
import org.primefaces.model.chart.LineChartSeries;

public class LineChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        LineChart chart = (LineChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        LineChart chart = (LineChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('LineChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeOptions(FacesContext context, LineChart chart) throws IOException {
        ChartSeries series;
        ResponseWriter writer = context.getResponseWriter();
        CartesianChartModel model = (CartesianChartModel)chart.getValue();
        List<String> categories = model.getCategories();
        boolean hasCategories = !categories.isEmpty();
        writer.write(",data:[");
        Iterator<Object> it = model.getSeries().iterator();
        while (it.hasNext()) {
            series = it.next();
            writer.write("[");
            Iterator<Object> x = series.getData().keySet().iterator();
            while (x.hasNext()) {
                String yValueAsString;
                Object xValue = x.next();
                Number yValue = series.getData().get(xValue);
                String string = yValueAsString = yValue != null ? yValue.toString() : "null";
                if (hasCategories) {
                    writer.write(yValueAsString);
                } else {
                    writer.write("[");
                    writer.write(xValue + "," + yValueAsString);
                    writer.write("]");
                }
                if (!x.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        this.encodeCommonConfig(context, chart);
        writer.write(",series:[");
        it = model.getSeries().iterator();
        while (it.hasNext()) {
            series = it.next();
            writer.write("{");
            writer.write("label:'" + series.getLabel() + "'");
            if (chart.isBreakOnNull()) {
                writer.write(",breakOnNull:true");
            }
            if (series instanceof LineChartSeries) {
                LineChartSeries lineChartSeries = (LineChartSeries)series;
                writer.write(",showLine:" + lineChartSeries.isShowLine());
                writer.write(",markerOptions:{show:" + chart.isShowMarkers() + ", style:'" + lineChartSeries.getMarkerStyle() + "'}");
            }
            writer.write("}");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        if (hasCategories) {
            writer.write(",categories:[");
            it = categories.iterator();
            while (it.hasNext()) {
                writer.write("'" + (String)it.next() + "'");
                if (!it.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
        if (chart.getMinX() != Double.MIN_VALUE) {
            writer.write(",minX:" + chart.getMinX());
        }
        if (chart.getMaxX() != Double.MAX_VALUE) {
            writer.write(",maxX:" + chart.getMaxX());
        }
        if (chart.getMinY() != Double.MIN_VALUE) {
            writer.write(",minY:" + chart.getMinY());
        }
        if (chart.getMaxY() != Double.MAX_VALUE) {
            writer.write(",maxY:" + chart.getMaxY());
        }
        if (chart.isFillToZero()) {
            writer.write(",fillToZero:true");
        } else if (chart.isFill()) {
            writer.write(",fill:true");
        }
        if (chart.isStacked()) {
            writer.write(",stackSeries:true");
        }
    }
}

