/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.donut;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.donut.DonutChart;

public class DonutChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DonutChart chart = (DonutChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DonutChart chart = (DonutChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('DonutChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeData(context, chart);
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeOptions(FacesContext context, DonutChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.encodeCommonConfig(context, chart);
        if (chart.getSliceMargin() != 0) {
            writer.write(",sliceMargin:" + chart.getSliceMargin());
        }
        if (!chart.isFill()) {
            writer.write(",fill:false");
        }
        if (chart.isShowDataLabels()) {
            writer.write(",showDataLabels:true");
        }
        if (chart.getDataFormat() != null) {
            writer.write(",dataFormat:'" + chart.getDataFormat() + "'");
        }
    }

    protected void encodeData(FacesContext context, DonutChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",data:[");
        List<Map<String, Number>> data = chart.getValue().getData();
        for (int i = 0; i < data.size(); ++i) {
            writer.write((i != 0 ? "," : "") + "[");
            Map<String, Number> s = data.get(i);
            Iterator<String> it = s.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                Number value = s.get(key);
                writer.write("['" + key + "'," + value + "]");
                if (!it.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
        writer.write("]");
    }
}

