/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.bubble;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.bubble.BubbleChart;

public class BubbleChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        BubbleChart chart = (BubbleChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BubbleChart chart = (BubbleChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('BubbleChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeData(context, chart);
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeOptions(FacesContext context, BubbleChart chart) throws IOException {
        this.encodeCommonConfig(context, chart);
        this.encodeSeriesDefaults(context, chart);
    }

    protected void encodeSeriesDefaults(FacesContext context, BubbleChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write(", seriesDefaults : { renderer: $.jqplot.BubbleRenderer, rendererOptions : {");
        writer.write("showLabels : " + chart.isShowLabels());
        if (chart.isBubbleGradients()) {
            writer.write(",bubbleGradients:true");
        }
        if (chart.getBubbleAlpha() != 70) {
            writer.write(",bubbleAlpha:" + chart.getBubbleAlpha() % 100 / 100);
        }
        writer.write("}}");
    }

    private void encodeData(FacesContext context, BubbleChart chart) throws IOException {
        context.getResponseWriter().write(",data:[" + chart.getValue().toString() + "]");
    }
}

