/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.UIChart;
import org.primefaces.renderkit.CoreRenderer;

public class BaseChartRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decodeBehaviors(context, component);
    }

    protected void encodeMarkup(FacesContext context, UIChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)chart.getClientId(context), null);
        if (chart.getStyle() != null) {
            writer.writeAttribute("style", (Object)chart.getStyle(), "style");
        }
        if (chart.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)chart.getStyleClass(), "styleClass");
        }
        writer.endElement("div");
    }

    protected void encodeCommonConfig(FacesContext context, UIChart chart) throws IOException {
        boolean xLabeled;
        ResponseWriter writer = context.getResponseWriter();
        String legendPosition = chart.getLegendPosition();
        if (chart.getTitle() != null) {
            writer.write(",title:'" + chart.getTitle() + "'");
        }
        if (!chart.isShadow()) {
            writer.write(",shadow:false");
        }
        if (chart.getSeriesColors() != null) {
            writer.write(",seriesColors:['#" + chart.getSeriesColors().replaceAll("[ ]*,[ ]*", "','#") + "']");
        }
        if (legendPosition != null) {
            writer.write(",legend:{");
            writer.write("show:true");
            if (chart.isEnhancedLegend()) {
                writer.write(",renderer: $.jqplot.EnhancedLegendRenderer");
            }
            writer.write(",location:'" + legendPosition + "'}");
        }
        writer.write(",axes:{");
        writer.write("xaxis:{");
        boolean bl = xLabeled = chart.getXaxisLabel() != null;
        if (xLabeled) {
            writer.write("labelRenderer: $.jqplot.CanvasAxisLabelRenderer,");
            writer.write("label:'" + chart.getXaxisLabel() + "'");
        }
        if (chart.getXaxisAngle() != 0) {
            if (xLabeled) {
                writer.write(",");
            }
            writer.write("tickRenderer:$.jqplot.CanvasAxisTickRenderer,");
            writer.write("tickOptions:{ angle:" + chart.getXaxisAngle() + "}");
        }
        writer.write("}");
        boolean yLabeled = chart.getYaxisLabel() != null;
        writer.write(",yaxis:{");
        if (yLabeled) {
            writer.write("label:'" + chart.getYaxisLabel() + "',");
            writer.write("labelRenderer: $.jqplot.CanvasAxisLabelRenderer");
        }
        if (chart.getYaxisAngle() != 0) {
            if (yLabeled) {
                writer.write(",");
            }
            writer.write("tickRenderer:$.jqplot.CanvasAxisTickRenderer,");
            writer.write("tickOptions:{ angle:" + chart.getYaxisAngle() + "}");
        }
        writer.write("}}");
    }
}

