/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.button;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.button.Button;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Button button = (Button)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    public void encodeMarkup(FacesContext context, Button button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String value = (String)button.getValue();
        String icon = button.resolveIcon();
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)button.resolveStyleClass(), "styleClass");
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.writeAttribute("onclick", (Object)this.buildOnclick(context, button), null);
        if (icon != null) {
            String defaultIconClass = button.getIconPos().equals("left") ? "ui-button-icon-left ui-icon" : "ui-button-icon-right ui-icon";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        if (value == null) {
            writer.write("ui-button");
        } else {
            writer.writeText((Object)value, "value");
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    public void encodeScript(FacesContext context, Button button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        boolean hasValue = button.getValue() != null;
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('Button','" + button.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (button.getImage() != null) {
            writer.write(",text:" + hasValue);
            writer.write(",icons:{");
            writer.write("primary:'" + button.getImage() + "'");
            writer.write("}");
        }
        writer.write("});");
        this.endScript(writer);
    }

    protected String buildOnclick(FacesContext context, Button button) {
        String url;
        String onclickBehaviors;
        String href = button.getHref();
        String userOnclick = button.getOnclick();
        StringBuilder onclick = new StringBuilder();
        if (userOnclick != null) {
            onclick.append(userOnclick).append(";");
        }
        if ((onclickBehaviors = this.getOnclickBehaviors(context, (ClientBehaviorHolder)button)) != null) {
            onclick.append(onclickBehaviors).append(";");
        }
        if (href != null) {
            url = this.getResourceURL(context, href);
        } else {
            NavigationCase navCase = this.findNavigationCase(context, button);
            String toViewId = navCase.getToViewId(context);
            boolean isIncludeViewParams = this.isIncludeViewParams(button, navCase);
            Map<String, List<String>> params = this.getParams(navCase, button);
            url = context.getApplication().getViewHandler().getBookmarkableURL(context, toViewId, params, isIncludeViewParams);
            if (button.getFragment() != null) {
                url = url + "#" + button.getFragment();
            }
        }
        if (url != null) {
            onclick.append("window.location.href='").append(url).append("';");
        }
        return onclick.toString();
    }

    protected NavigationCase findNavigationCase(FacesContext context, Button button) {
        ConfigurableNavigationHandler navHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
        String outcome = button.getOutcome();
        if (outcome == null) {
            outcome = context.getViewRoot().getViewId();
        }
        return navHandler.getNavigationCase(context, null, outcome);
    }

    protected Map<String, List<String>> getParams(NavigationCase navCase, Button button) {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        for (UIComponent child : button.getChildren()) {
            UIParameter uiParam;
            if (!child.isRendered() || !(child instanceof UIParameter) || (uiParam = (UIParameter)child).isDisable()) continue;
            ArrayList<String> paramValues = (ArrayList<String>)params.get(uiParam.getName());
            if (paramValues == null) {
                paramValues = new ArrayList<String>();
                params.put(uiParam.getName(), paramValues);
            }
            paramValues.add(String.valueOf(uiParam.getValue()));
        }
        Map navCaseParams = navCase.getParameters();
        if (navCaseParams != null && !navCaseParams.isEmpty()) {
            for (Map.Entry entry : navCaseParams.entrySet()) {
                String key = (String)entry.getKey();
                if (params.containsKey(key)) continue;
                params.put(key, (List<String>)entry.getValue());
            }
        }
        return params;
    }

    protected boolean isIncludeViewParams(Button button, NavigationCase navCase) {
        return button.isIncludeViewParams() || navCase.isIncludeViewParams();
    }
}

