/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.behavior.ajax;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.facelets.BehaviorConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.component.behavior.ajax.AjaxBehavior;
import org.primefaces.component.behavior.ajax.AjaxBehaviorListenerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxBehaviorHandler
extends TagHandler
implements BehaviorHolderAttachedObjectHandler {
    private final TagAttribute event = this.getAttribute("event");
    private final TagAttribute process = this.getAttribute("process");
    private final TagAttribute update = this.getAttribute("update");
    private final TagAttribute onstart = this.getAttribute("onstart");
    private final TagAttribute onerror = this.getAttribute("onerror");
    private final TagAttribute onsuccess = this.getAttribute("onsuccess");
    private final TagAttribute oncomplete = this.getAttribute("oncomplete");
    private final TagAttribute disabled = this.getAttribute("disabled");
    private final TagAttribute immediate = this.getAttribute("immediate");
    private final TagAttribute listener = this.getAttribute("listener");
    private final TagAttribute global = this.getAttribute("global");
    private final TagAttribute async = this.getAttribute("async");

    public AjaxBehaviorHandler(BehaviorConfig config) {
        super((TagConfig)config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        String eventName = this.getEventName();
        if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            BeanInfo componentBeanInfo;
            boolean tagApplied = false;
            if (parent instanceof ClientBehaviorHolder) {
                this.applyAttachedObject(ctx, parent, eventName);
                tagApplied = true;
            }
            if (null == (componentBeanInfo = (BeanInfo)parent.getAttributes().get("javax.faces.component.BEANINFO_KEY"))) {
                throw new TagException(this.tag, "Composite component does not have BeanInfo attribute");
            }
            BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
            if (null == componentDescriptor) {
                throw new TagException(this.tag, "Composite component BeanInfo does not have BeanDescriptor");
            }
            List targetList = (List)componentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            if (null == targetList && !tagApplied) {
                throw new TagException(this.tag, "Composite component does not support behavior events");
            }
            boolean supportedEvent = false;
            for (AttachedObjectTarget target : targetList) {
                if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                if ((null == eventName || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                supportedEvent = true;
                break;
            }
            if (supportedEvent) {
                this.getAttachedObjectHandlers(parent).add((AttachedObjectHandler)this);
            } else if (!tagApplied) {
                throw new TagException(this.tag, "Composite component does not support event " + eventName);
            }
        } else if (parent instanceof ClientBehaviorHolder) {
            this.applyAttachedObject(ctx, parent, eventName);
        } else {
            throw new TagException(this.tag, "Unable to attach <p:ajax> to non-ClientBehaviorHolder parent");
        }
    }

    public String getEventName() {
        return this.event != null ? this.event.getValue() : null;
    }

    public void applyAttachedObject(FaceletContext context, UIComponent component, String eventName) {
        ClientBehaviorHolder holder = (ClientBehaviorHolder)component;
        if (null == eventName) {
            eventName = holder.getDefaultEventName();
            if (null == eventName) {
                throw new TagException(this.tag, "Event attribute could not be determined: " + eventName);
            }
        } else {
            Collection eventNames = holder.getEventNames();
            if (!eventNames.contains(eventName)) {
                throw new TagException(this.tag, "Event:" + eventName + " is not supported.");
            }
        }
        AjaxBehavior ajaxBehavior = this.createAjaxBehavior(context, eventName);
        holder.addClientBehavior(eventName, (ClientBehavior)ajaxBehavior);
    }

    private AjaxBehavior createAjaxBehavior(FaceletContext ctx, String eventName) {
        Application application = ctx.getFacesContext().getApplication();
        AjaxBehavior behavior = (AjaxBehavior)application.createBehavior("org.primefaces.component.AjaxBehavior");
        this.setBehaviorAttribute(ctx, behavior, this.process, String.class);
        this.setBehaviorAttribute(ctx, behavior, this.update, String.class);
        this.setBehaviorAttribute(ctx, behavior, this.onstart, String.class);
        this.setBehaviorAttribute(ctx, behavior, this.onerror, String.class);
        this.setBehaviorAttribute(ctx, behavior, this.onsuccess, String.class);
        this.setBehaviorAttribute(ctx, behavior, this.oncomplete, String.class);
        this.setBehaviorAttribute(ctx, behavior, this.disabled, Boolean.class);
        this.setBehaviorAttribute(ctx, behavior, this.immediate, Boolean.class);
        this.setBehaviorAttribute(ctx, behavior, this.global, Boolean.class);
        this.setBehaviorAttribute(ctx, behavior, this.async, Boolean.class);
        this.setBehaviorAttribute(ctx, behavior, this.listener, MethodExpression.class);
        if (this.listener != null) {
            behavior.addAjaxBehaviorListener(new AjaxBehaviorListenerImpl(this.listener.getMethodExpression(ctx, Object.class, new Class[0])));
        }
        return behavior;
    }

    public String getFor() {
        return null;
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        this.applyAttachedObject(ctx, parent, this.getEventName());
    }

    private void setBehaviorAttribute(FaceletContext ctx, AjaxBehavior behavior, TagAttribute attr, Class type) {
        if (attr != null) {
            behavior.setValueExpression(attr.getLocalName(), attr.getValueExpression(ctx, type));
        }
    }

    public List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component) {
        return this.getAttachedObjectHandlers(component, true);
    }

    public List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component, boolean create) {
        Map attrs = component.getAttributes();
        ArrayList result = (ArrayList)attrs.get("javax.faces.RetargetableHandlers");
        if (result == null) {
            if (create) {
                result = new ArrayList();
                attrs.put("javax.faces.RetargetableHandlers", result);
            } else {
                result = Collections.EMPTY_LIST;
            }
        }
        return result;
    }
}

