/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.autocomplete;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.PhaseId;
import org.primefaces.component.autocomplete.AutoComplete;
import org.primefaces.component.column.Column;
import org.primefaces.event.AutoCompleteEvent;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        AutoComplete ac = (AutoComplete)component;
        String clientId = ac.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (ac.isDisabled() || ac.isReadonly()) {
            return;
        }
        if (ac.isMultiple()) {
            this.decodeMultiple(context, ac);
        } else {
            this.decodeSingle(context, ac);
        }
        this.decodeBehaviors(context, (UIComponent)ac);
        String query = (String)params.get(clientId + "_query");
        if (query != null) {
            AutoCompleteEvent autoCompleteEvent = new AutoCompleteEvent((UIComponent)ac, query);
            autoCompleteEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            ac.queueEvent(autoCompleteEvent);
        }
    }

    protected void decodeSingle(FacesContext context, AutoComplete ac) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = ac.getClientId(context);
        String valueParam = ac.getVar() != null ? clientId + "_hinput" : clientId + "_input";
        String submittedValue = (String)params.get(valueParam);
        if (submittedValue != null) {
            ac.setSubmittedValue(submittedValue);
        }
    }

    protected void decodeMultiple(FacesContext context, AutoComplete ac) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String[] submittedValues = (String[])params.get((clientId = ac.getClientId(context)) + "_hinput");
        if (submittedValues != null) {
            ac.setSubmittedValue(submittedValues);
        } else {
            ac.setSubmittedValue("");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AutoComplete autoComplete = (AutoComplete)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String query = (String)params.get(autoComplete.getClientId(context) + "_query");
        if (query != null) {
            this.encodeResults(context, component, query);
        } else {
            this.encodeMarkup(context, autoComplete);
            this.encodeScript(context, autoComplete);
        }
    }

    public void encodeResults(FacesContext context, UIComponent component, String query) throws IOException {
        AutoComplete ac = (AutoComplete)component;
        List results = ac.getSuggestions();
        int maxResults = ac.getMaxResults();
        if (maxResults != Integer.MAX_VALUE && results.size() > maxResults) {
            results = results.subList(0, ac.getMaxResults());
        }
        this.encodeSuggestions(context, ac, results);
    }

    protected void encodeMarkup(FacesContext context, AutoComplete ac) throws IOException {
        if (ac.isMultiple()) {
            this.encodeMultipleMarkup(context, ac);
        } else {
            this.encodeSingleMarkup(context, ac);
        }
    }

    protected void encodeSingleMarkup(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ac.getClientId(context);
        Object value = ac.getValue();
        String styleClass = ac.getStyleClass();
        styleClass = styleClass == null ? "ui-autocomplete" : "ui-autocomplete " + styleClass;
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (ac.getStyle() != null) {
            writer.writeAttribute("style", (Object)ac.getStyle(), null);
        }
        this.encodeInput(context, ac, clientId, value);
        if (ac.getVar() != null) {
            this.encodeHiddenInput(context, ac, clientId, value);
        }
        if (ac.isDropdown()) {
            this.encodeDropDown(context, ac);
        }
        this.encodePanel(context, ac);
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, AutoComplete ac, String clientId, Object value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean disabled = ac.isDisabled();
        String defaultStyleClass = ac.isDropdown() ? "ui-autocomplete-input ui-inputfield ui-widget ui-state-default ui-corner-left" : "ui-autocomplete-input ui-inputfield ui-widget ui-state-default ui-corner-all";
        String styleClass = disabled ? defaultStyleClass + " ui-state-disabled" : defaultStyleClass;
        styleClass = ac.isValid() ? styleClass : styleClass + " ui-state-error";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(clientId + "_input"), null);
        writer.writeAttribute("name", (Object)(clientId + "_input"), null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (value != null) {
            if (ac.getVar() == null) {
                writer.writeAttribute("value", (Object)ComponentUtils.getValueToRender(context, (UIComponent)ac), null);
            } else {
                context.getExternalContext().getRequestMap().put(ac.getVar(), value);
                writer.writeAttribute("value", (Object)ac.getItemLabel(), null);
            }
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (ac.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        this.renderPassThruAttributes(context, (UIComponent)ac, HTML.INPUT_TEXT_ATTRS);
        writer.endElement("input");
    }

    protected void encodeHiddenInput(FacesContext context, AutoComplete ac, String clientId, Object value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String valueToRender = value == null ? null : (ac.isMultiple() ? (String)value : ComponentUtils.getValueToRender(context, (UIComponent)ac));
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(clientId + "_hinput"), null);
        writer.writeAttribute("name", (Object)(clientId + "_hinput"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        writer.endElement("input");
    }

    protected void encodeHiddenSelect(FacesContext context, AutoComplete ac, String clientId, List<String> values) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = clientId + "_hinput";
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        for (String value : values) {
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)value, null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected void encodeDropDown(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", (UIComponent)ac);
        writer.writeAttribute("class", (Object)"ui-button ui-widget ui-state-default ui-corner-right ui-button-icon-only", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-icon-primary ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.write("&nbsp;");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodePanel(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = ac.getPanelStyleClass();
        styleClass = styleClass == null ? "ui-autocomplete-panel ui-widget-content ui-corner-all ui-helper-hidden ui-shadow" : "ui-autocomplete-panel ui-widget-content ui-corner-all ui-helper-hidden ui-shadow " + styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(ac.getClientId(context) + "_panel"), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (ac.getPanelStyle() != null) {
            writer.writeAttribute("style", (Object)ac.getPanelStyle(), null);
        }
        writer.endElement("div");
    }

    protected void encodeMultipleMarkup(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ac.getClientId(context);
        String inputId = clientId + "_input";
        List values = (List)ac.getValue();
        ArrayList<String> stringValues = new ArrayList<String>();
        Converter converter = this.getConverter(context, (UIInput)ac);
        String styleClass = ac.getStyleClass();
        styleClass = styleClass == null ? "ui-autocomplete-multiple" : "ui-autocomplete-multiple " + styleClass;
        String var = ac.getVar();
        boolean pojo = var != null;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (ac.getStyle() != null) {
            writer.writeAttribute("style", (Object)ac.getStyle(), null);
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-autocomplete-multiple-container ui-widget ui-inputfield ui-state-default ui-corner-all", null);
        if (values != null && !values.isEmpty()) {
            for (Object value : values) {
                Object itemValue = null;
                String itemLabel = null;
                if (pojo) {
                    context.getExternalContext().getRequestMap().put(var, value);
                    itemValue = ac.getItemValue();
                    itemLabel = ac.getItemLabel();
                } else {
                    itemValue = value;
                    itemLabel = String.valueOf(value);
                }
                String tokenValue = converter != null ? converter.getAsString(context, (UIComponent)ac, itemValue) : String.valueOf(itemValue);
                writer.startElement("li", null);
                writer.writeAttribute("data-token-value", (Object)tokenValue, null);
                writer.writeAttribute("class", (Object)"ui-autocomplete-token ui-state-active ui-corner-all", null);
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-autocomplete-token-label", null);
                writer.writeText((Object)itemLabel, null);
                writer.endElement("span");
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-autocomplete-token-icon ui-icon ui-icon-close", null);
                writer.endElement("span");
                writer.endElement("li");
                stringValues.add(tokenValue);
            }
        }
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-autocomplete-input-token", null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.endElement("input");
        writer.endElement("li");
        writer.endElement("ul");
        this.encodePanel(context, ac);
        this.encodeHiddenSelect(context, ac, clientId, stringValues);
        writer.endElement("div");
    }

    protected void encodeSuggestions(FacesContext context, AutoComplete ac, List items) throws IOException {
        boolean customContent = ac.getColums().size() > 0;
        Converter converter = this.getConverter(context, (UIInput)ac);
        if (customContent) {
            this.encodeSuggestionsAsTable(context, ac, items, converter);
        } else {
            this.encodeSuggestionsAsList(context, ac, items, converter);
        }
    }

    protected void encodeSuggestionsAsTable(FacesContext context, AutoComplete ac, List items, Converter converter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = ac.getVar();
        Map requestMap = context.getExternalContext().getRequestMap();
        boolean pojo = var != null;
        writer.startElement("table", (UIComponent)ac);
        writer.writeAttribute("class", (Object)"ui-autocomplete-items ui-autocomplete-table ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
        writer.startElement("tbody", (UIComponent)ac);
        for (Object item : items) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-autocomplete-row ui-widget-content", null);
            if (pojo) {
                requestMap.put(var, item);
                String value = converter == null ? (String)ac.getItemValue() : converter.getAsString(context, (UIComponent)ac, ac.getItemValue());
                writer.writeAttribute("data-item-value", (Object)value, null);
                writer.writeAttribute("data-item-label", (Object)ac.getItemLabel(), null);
            }
            for (Column column : ac.getColums()) {
                if (!column.isRendered()) continue;
                writer.startElement("td", null);
                if (column.getStyle() != null) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
                if (column.getStyleClass() != null) {
                    writer.writeAttribute("class", (Object)column.getStyleClass(), null);
                }
                column.encodeAll(context);
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeSuggestionsAsList(FacesContext context, AutoComplete ac, List items, Converter converter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = ac.getVar();
        Map requestMap = context.getExternalContext().getRequestMap();
        boolean pojo = var != null;
        writer.startElement("ul", (UIComponent)ac);
        writer.writeAttribute("class", (Object)"ui-autocomplete-items ui-autocomplete-list ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
        for (Object item : items) {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-autocomplete-list-item ui-corner-all", null);
            if (pojo) {
                requestMap.put(var, item);
                String value = converter == null ? (String)ac.getItemValue() : converter.getAsString(context, (UIComponent)ac, ac.getItemValue());
                writer.writeAttribute("data-item-value", (Object)value, null);
                writer.writeAttribute("data-item-label", (Object)ac.getItemLabel(), null);
                writer.writeText((Object)ac.getItemLabel(), null);
            } else {
                writer.writeAttribute("data-item-label", item, null);
                writer.writeAttribute("data-item-value", item, null);
                writer.writeText(item, null);
            }
            writer.endElement("li");
        }
        writer.endElement("ul");
        if (pojo) {
            requestMap.remove(var);
        }
    }

    protected void encodeScript(FacesContext context, AutoComplete ac) throws IOException {
        String effect;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ac.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('AutoComplete','" + ac.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (ac.getMinQueryLength() != 1) {
            writer.write(",minLength:" + ac.getMinQueryLength());
        }
        if (ac.getQueryDelay() != 300) {
            writer.write(",delay:" + ac.getQueryDelay());
        }
        if (ac.isForceSelection()) {
            writer.write(",forceSelection:true");
        }
        if (!ac.isGlobal()) {
            writer.write(",global:false");
        }
        if (ac.getScrollHeight() != Integer.MAX_VALUE) {
            writer.write(",scrollHeight:" + ac.getScrollHeight());
        }
        if (ac.isMultiple()) {
            writer.write(",multiple:true");
        }
        if (ac.getProcess() != null) {
            writer.write(",process:'" + ComponentUtils.findClientIds(context, (UIComponent)ac, ac.getProcess()) + "'");
        }
        if (ac.getOnstart() != null) {
            writer.write(",onstart:function(request) {" + ac.getOnstart() + ";}");
        }
        if (ac.getOncomplete() != null) {
            writer.write(",oncomplete:function(response) {" + ac.getOncomplete() + ";}");
        }
        if ((effect = ac.getEffect()) != null) {
            writer.write(",effect:'" + effect + "'");
            writer.write(",effectDuration:" + ac.getEffectDuration());
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)ac);
        writer.write("});});");
        this.endScript(writer);
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue == null || submittedValue.equals("")) {
            return null;
        }
        AutoComplete ac = (AutoComplete)component;
        Converter converter = this.getConverter(context, (UIInput)ac);
        if (ac.isMultiple()) {
            String[] values = (String[])submittedValue;
            ArrayList<String> list = new ArrayList<String>();
            for (String value : values) {
                String convertedValue;
                if (this.isValueBlank(value)) continue;
                String string = convertedValue = converter != null ? converter.getAsObject(context, (UIComponent)ac, value) : value;
                if (convertedValue == null) continue;
                list.add(convertedValue);
            }
            return list;
        }
        if (converter != null) {
            return converter.getAsObject(context, component, (String)submittedValue);
        }
        return submittedValue;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

