/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.openide.util.NbPreferences;

class FileToRepoMappingStorage {
    private static Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.util.FileToRepoMappingStorage");
    private static final String REPOSITORY_FOR_FILE_PREFIX = "repository for ";
    private static final Boolean FIRM_ASSOCIATION = Boolean.TRUE;
    private static final Boolean LOOSE_ASSOCIATION = Boolean.FALSE;
    private static FileToRepoMappingStorage instance;

    FileToRepoMappingStorage() {
    }

    public static synchronized FileToRepoMappingStorage getInstance() {
        if (instance == null) {
            instance = new FileToRepoMappingStorage();
        }
        return instance;
    }

    public void setFirmAssociation(File file, RepositoryImpl repository) {
        this.setAssociation(file, repository, true);
    }

    public boolean setLooseAssociation(File file, RepositoryImpl repository) {
        RepositoryImpl firmlyAssociated = this.getFirmlyAssociatedRepository(file);
        if (firmlyAssociated == null) {
            this.setAssociation(file, repository, false);
            return true;
        }
        return false;
    }

    public RepositoryImpl getRepository(File file) {
        return this.getAssociatedRepository(file, null);
    }

    public RepositoryImpl getFirmlyAssociatedRepository(File file) {
        return this.getAssociatedRepository(file, FIRM_ASSOCIATION);
    }

    public RepositoryImpl getLooselyAssociatedRepository(File file) {
        return this.getAssociatedRepository(file, LOOSE_ASSOCIATION);
    }

    public Collection<String> getAllFirmlyAssociatedUrls() {
        HashSet<String> associatedUrls = new HashSet<String>(10);
        try {
            String[] keys;
            Preferences prefs = this.getPreferences();
            for (String key : keys = prefs.keys()) {
                String value;
                if (!key.startsWith(REPOSITORY_FOR_FILE_PREFIX) || (value = prefs.get(key, null)) == null || value.length() <= 0 || value.charAt(0) != '!') continue;
                associatedUrls.add(value.substring(1));
            }
        }
        catch (BackingStoreException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        return associatedUrls;
    }

    private RepositoryImpl getAssociatedRepository(File file, Boolean reqAssociationType) {
        boolean matches;
        String key = FileToRepoMappingStorage.getPath(file);
        if (key == null) {
            return null;
        }
        String value = this.getValueForKey(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        char firstChar = value.charAt(0);
        switch (firstChar) {
            case '!': {
                matches = reqAssociationType != LOOSE_ASSOCIATION;
                break;
            }
            case '?': {
                matches = reqAssociationType != FIRM_ASSOCIATION;
                break;
            }
            default: {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("unexpected first char of value in mapping: " + key + '=' + value + " (expected: '?' or '!')");
                }
                matches = false;
            }
        }
        return matches ? this.getRepositoryByUrl(value.substring(1)) : null;
    }

    private RepositoryImpl getRepositoryByUrl(String requestedUrl) {
        Collection<RepositoryImpl> repositories = RepositoryRegistry.getInstance().getRepositories();
        for (RepositoryImpl repository : repositories) {
            String repositoryUrl = FileToRepoMappingStorage.cutTrailingSlashes(repository.getUrl());
            if (!repositoryUrl.equals(requestedUrl)) continue;
            return repository;
        }
        return null;
    }

    private void setAssociation(File file, RepositoryImpl repository, boolean firm) {
        String key = FileToRepoMappingStorage.getPath(file);
        if (key == null) {
            return;
        }
        String repositoryUrl = FileToRepoMappingStorage.cutTrailingSlashes(repository.getUrl());
        String value = new StringBuilder(1 + repositoryUrl.length()).append(firm ? (char)'!' : '?').append(repositoryUrl).toString();
        this.storeKeyValuePair(key, value);
    }

    private static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            LOG.throwing(FileToRepoMappingStorage.class.getCanonicalName(), "storeMappingToPrefs", ex);
            return null;
        }
    }

    private void storeKeyValuePair(String key, String value) {
        this.getPreferences().put(REPOSITORY_FOR_FILE_PREFIX + key, value);
    }

    private String getValueForKey(String key) {
        return this.getPreferences().get(REPOSITORY_FOR_FILE_PREFIX + key, null);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(FileToRepoMappingStorage.class);
    }

    private static String cutTrailingSlashes(String url) {
        int endIndex;
        for (endIndex = url.length(); endIndex > 1 && url.charAt(endIndex - 1) == '/'; --endIndex) {
        }
        return endIndex == url.length() ? url : url.substring(0, endIndex);
    }
}

