/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.ui.selectors.RepositorySelectorBuilder;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.FileToRepoMappingStorage;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public abstract class BugtrackingOwnerSupport {
    private static BugtrackingOwnerSupport instance;

    protected BugtrackingOwnerSupport() {
    }

    public static BugtrackingOwnerSupport getInstance() {
        if (instance == null && (instance = (BugtrackingOwnerSupport)Lookup.getDefault().lookup(BugtrackingOwnerSupport.class)) == null) {
            instance = new DefaultImpl();
        }
        return instance;
    }

    public static Project getMainOrSingleProject() {
        OpenProjects projects = OpenProjects.getDefault();
        Project[] openProjects = projects.getOpenProjects();
        if (openProjects.length == 1) {
            return openProjects[0];
        }
        return projects.getMainProject();
    }

    public RepositoryImpl getRepository(ContextType context) {
        switch (context) {
            case MAIN_PROJECT_ONLY: {
                Project mainProject = OpenProjects.getDefault().getMainProject();
                if (mainProject == null) break;
                return this.getRepository(mainProject, false);
            }
            case MAIN_OR_SINGLE_PROJECT: {
                Project mainOrSingleProject = BugtrackingOwnerSupport.getMainOrSingleProject();
                if (mainOrSingleProject == null) break;
                return this.getRepository(mainOrSingleProject, false);
            }
            case ALL_PROJECTS: {
                return this.getRepository(OpenProjects.getDefault().getOpenProjects());
            }
            case SELECTED_FILE_AND_ALL_PROJECTS: {
                File contextFile = BugtrackingOwnerSupport.getLargerContext();
                if (contextFile == null) break;
                return this.getRepositoryForContext(contextFile, false);
            }
            default: {
                assert (false);
                break;
            }
        }
        return null;
    }

    public RepositoryImpl getRepository(Node ... nodes) {
        if (nodes == null) {
            return null;
        }
        if (nodes.length == 0) {
            return null;
        }
        if (nodes.length == 1) {
            return this.getRepository(nodes[0]);
        }
        RepositoryImpl chosenRepo = null;
        for (Node node : nodes) {
            RepositoryImpl repo = this.getRepository(node);
            if (repo == null) continue;
            if (chosenRepo == null) {
                chosenRepo = repo;
                continue;
            }
            if (repo == chosenRepo) continue;
            return null;
        }
        return chosenRepo;
    }

    protected RepositoryImpl getRepository(Node node) {
        Lookup nodeLookup = node.getLookup();
        Project project = (Project)nodeLookup.lookup(Project.class);
        if (project != null) {
            return this.getRepository(project, false);
        }
        DataObject dataObj = (DataObject)nodeLookup.lookup(DataObject.class);
        if (dataObj != null) {
            return this.getRepository(dataObj);
        }
        return null;
    }

    protected abstract RepositoryImpl getRepository(DataObject var1);

    public RepositoryImpl getRepository(Project ... projects) {
        if (projects.length == 0) {
            return null;
        }
        if (projects.length == 1) {
            return this.getRepository(projects[0], false);
        }
        RepositoryImpl chosenRepo = null;
        for (Project project : projects) {
            RepositoryImpl repo = this.getRepository(project, false);
            if (repo == null) continue;
            if (chosenRepo == null) {
                chosenRepo = repo;
                continue;
            }
            if (repo == chosenRepo) continue;
            return null;
        }
        return chosenRepo;
    }

    public abstract RepositoryImpl getRepository(Project var1, boolean var2);

    public RepositoryImpl getRepository(File file, boolean askIfUnknown) {
        return this.getRepository(file, null, askIfUnknown);
    }

    public abstract RepositoryImpl getRepository(File var1, String var2, boolean var3);

    protected RepositoryImpl getRepositoryForContext(File context, boolean askIfUnknown) {
        return this.getRepositoryForContext(context, null, askIfUnknown);
    }

    protected abstract RepositoryImpl getRepositoryForContext(File var1, String var2, boolean var3);

    public void setFirmAssociations(File[] files, RepositoryImpl repository) {
        if (files == null) {
            throw new IllegalArgumentException("files is null");
        }
        if (files.length == 0) {
            return;
        }
        FileToRepoMappingStorage.getInstance().setFirmAssociation(BugtrackingOwnerSupport.getLargerContext(files[0]), repository);
    }

    public void setFirmAssociation(File file, RepositoryImpl repository) {
        FileToRepoMappingStorage.getInstance().setFirmAssociation(BugtrackingOwnerSupport.getLargerContext(file), repository);
    }

    public void setLooseAssociation(ContextType contextType, RepositoryImpl repository) {
        OpenProjects projects = OpenProjects.getDefault();
        File context = null;
        switch (contextType) {
            case MAIN_PROJECT_ONLY: {
                Project mainProject = projects.getMainProject();
                if (mainProject == null) break;
                context = BugtrackingOwnerSupport.getLargerContext(mainProject);
                break;
            }
            case MAIN_OR_SINGLE_PROJECT: {
                Project mainOrSingleProject = BugtrackingOwnerSupport.getMainOrSingleProject();
                if (mainOrSingleProject == null) break;
                context = BugtrackingOwnerSupport.getLargerContext(mainOrSingleProject);
                break;
            }
            case ALL_PROJECTS: {
                context = BugtrackingOwnerSupport.getContextFromProjects();
                break;
            }
            case SELECTED_FILE_AND_ALL_PROJECTS: {
                context = BugtrackingOwnerSupport.getLargerContext();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (context != null) {
            FileToRepoMappingStorage.getInstance().setLooseAssociation(context, repository);
        }
    }

    public void setLooseAssociation(File file, RepositoryImpl repository) {
        FileToRepoMappingStorage.getInstance().setLooseAssociation(BugtrackingOwnerSupport.getLargerContext(file), repository);
    }

    public final Collection<String> getAllAssociatedUrls() {
        return FileToRepoMappingStorage.getInstance().getAllFirmlyAssociatedUrls();
    }

    private static File getLargerContext() {
        File largerContext;
        FileObject openFile = BugtrackingOwnerSupport.getOpenFileObj();
        if (openFile != null && (largerContext = BugtrackingOwnerSupport.getLargerContext(openFile)) != null) {
            return largerContext;
        }
        return BugtrackingOwnerSupport.getContextFromProjects();
    }

    private static File getContextFromProjects() {
        OpenProjects projects = OpenProjects.getDefault();
        Project mainProject = projects.getMainProject();
        if (mainProject != null) {
            return BugtrackingOwnerSupport.getLargerContext(mainProject);
        }
        Project[] openProjects = projects.getOpenProjects();
        if (openProjects != null && openProjects.length == 1) {
            return BugtrackingOwnerSupport.getLargerContext(openProjects[0]);
        }
        return null;
    }

    private static File getLargerContext(File file) {
        return BugtrackingOwnerSupport.getLargerContext(file, null);
    }

    private static File getLargerContext(FileObject fileObj) {
        return BugtrackingOwnerSupport.getLargerContext(null, fileObj);
    }

    private static File getLargerContext(File file, FileObject fileObj) {
        if (file == null && fileObj == null) {
            throw new IllegalArgumentException("both File and FileObject are null");
        }
        assert (file == null || fileObj == null || FileUtil.toFileObject((File)file).equals(fileObj));
        if (fileObj == null) {
            fileObj = BugtrackingOwnerSupport.getFileObjForFileOrParent(file);
        } else if (file == null) {
            file = FileUtil.toFile((FileObject)fileObj);
        }
        if (fileObj == null) {
            return null;
        }
        if (!fileObj.isValid()) {
            return null;
        }
        Project parentProject = FileOwnerQuery.getOwner((FileObject)fileObj);
        if (parentProject != null) {
            FileObject parentProjectFolder = parentProject.getProjectDirectory();
            if (parentProjectFolder.equals(fileObj) && file != null) {
                return file;
            }
            File folder = FileUtil.toFile((FileObject)parentProjectFolder);
            if (folder != null) {
                return folder;
            }
        }
        if (fileObj.isFolder()) {
            return file;
        }
        fileObj = fileObj.getParent();
        assert (fileObj != null);
        return FileUtil.toFile((FileObject)fileObj);
    }

    private static FileObject getFileObjForFileOrParent(File file) {
        FileObject fileObj = FileUtil.toFileObject((File)file);
        if (fileObj != null) {
            return fileObj;
        }
        for (File closestParentFile = file.getParentFile(); closestParentFile != null; closestParentFile = closestParentFile.getParentFile()) {
            fileObj = FileUtil.toFileObject((File)closestParentFile);
            if (fileObj == null) continue;
            return fileObj;
        }
        return null;
    }

    private static File getLargerContext(Project project) {
        FileObject projectFolder = project.getProjectDirectory();
        assert (projectFolder != null);
        return FileUtil.toFile((FileObject)projectFolder);
    }

    private static FileObject getOpenFileObj() {
        TopComponent activatedTopComponent = TopComponent.getRegistry().getActivated();
        if (activatedTopComponent == null) {
            return null;
        }
        DataObject dataObj = (DataObject)activatedTopComponent.getLookup().lookup(DataObject.class);
        if (dataObj == null || !dataObj.isValid()) {
            return null;
        }
        return dataObj.getPrimaryFile();
    }

    public static enum ContextType {
        MAIN_PROJECT_ONLY,
        MAIN_OR_SINGLE_PROJECT,
        ALL_PROJECTS,
        SELECTED_FILE_AND_ALL_PROJECTS;

    }

    private static class DefaultImpl
    extends BugtrackingOwnerSupport {
        private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.bridge.BugtrackingOwnerSupport");

        private DefaultImpl() {
        }

        @Override
        protected RepositoryImpl getRepository(DataObject dataObj) {
            RepositoryImpl repo;
            FileObject fileObj = dataObj.getPrimaryFile();
            if (fileObj == null) {
                return null;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)fileObj);
            if (project != null) {
                return this.getRepository(project, false);
            }
            try {
                repo = DefaultImpl.getKenaiBugtrackingRepository(fileObj);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                repo = null;
            }
            return repo;
        }

        @Override
        public RepositoryImpl getRepository(Project project, boolean askIfUnknown) {
            FileObject fileObject = project.getProjectDirectory();
            try {
                RepositoryImpl repo = DefaultImpl.getKenaiBugtrackingRepository(fileObject);
                if (repo != null) {
                    return repo;
                }
            }
            catch (IOException ex) {
                return null;
            }
            File context = BugtrackingOwnerSupport.getLargerContext(project);
            if (context != null) {
                return this.getRepositoryForContext(context, null, askIfUnknown);
            }
            return this.askUserToSpecifyRepository(null);
        }

        @Override
        public RepositoryImpl getRepository(File file, String issueId, boolean askIfUnknown) {
            if (file == null) {
                if (askIfUnknown) {
                    return this.askUserToSpecifyRepository(null);
                }
                return null;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) {
                LOG.log(Level.WARNING, " did not find a FileObject for file {0}", new Object[]{file});
            } else {
                try {
                    RepositoryImpl repo = DefaultImpl.getKenaiBugtrackingRepository(fileObject);
                    if (repo != null) {
                        return repo;
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, " communication with Kenai failed while loading information about bugtracking repository", ex);
                    return null;
                }
            }
            File context = BugtrackingOwnerSupport.getLargerContext(file, fileObject);
            if (context == null) {
                context = file;
            }
            return this.getRepositoryForContext(context, issueId, askIfUnknown);
        }

        @Override
        protected RepositoryImpl getRepositoryForContext(File context, String issueId, boolean askIfUnknown) {
            RepositoryImpl repo = FileToRepoMappingStorage.getInstance().getFirmlyAssociatedRepository(context);
            if (repo != null) {
                LOG.log(Level.FINER, " found stored repository [{0}] for directory {1}", new Object[]{repo, context});
                return repo;
            }
            RepositoryImpl suggestedRepository = FileToRepoMappingStorage.getInstance().getLooselyAssociatedRepository(context);
            if (!askIfUnknown) {
                return suggestedRepository;
            }
            repo = this.askUserToSpecifyRepository(suggestedRepository);
            if (repo != null) {
                return repo;
            }
            return null;
        }

        private static RepositoryImpl getKenaiBugtrackingRepository(FileObject fileObject) throws IOException {
            return DefaultImpl.getRepository(fileObject);
        }

        private static RepositoryImpl getRepository(FileObject fileObject) throws IOException {
            Object attValue = fileObject.getAttribute("ProvidedExtensions.RemoteLocation");
            if (attValue instanceof String) {
                File file;
                RepositoryImpl repository = null;
                String url = (String)attValue;
                if (BugtrackingUtil.isNbRepository(url) && (file = FileUtil.toFile((FileObject)fileObject)) != null) {
                    OwnerInfo ownerInfo = KenaiUtil.getOwnerInfo(file);
                    if (ownerInfo != null) {
                        repository = APIAccessor.IMPL.getImpl(KenaiUtil.getRepository(url, ownerInfo.getOwner()));
                    }
                    if (repository == null) {
                        repository = APIAccessor.IMPL.getImpl(KenaiUtil.findNBRepository());
                    }
                }
                if (repository != null) {
                    return repository;
                }
                try {
                    repository = APIAccessor.IMPL.getImpl(KenaiUtil.getRepository(url));
                    if (repository != null) {
                        return repository;
                    }
                }
                catch (IOException ex) {
                    if ("Not Found".equals(ex.getMessage())) {
                        BugtrackingManager.LOG.log(Level.INFO, "Kenai project corresponding to URL {0} does not exist.", attValue);
                    } else {
                        BugtrackingManager.LOG.throwing(BugtrackingOwnerSupport.class.getName(), "getRepository(String)", ex);
                    }
                    throw ex;
                }
            }
            return null;
        }

        private static RepositoryImpl getKenaiBugtrackingRepository(String remoteLocation) throws IOException {
            return APIAccessor.IMPL.getImpl(KenaiUtil.getRepository(remoteLocation));
        }

        private RepositoryImpl askUserToSpecifyRepository(RepositoryImpl suggestedRepo) {
            Collection<RepositoryImpl> repos = BugtrackingUtil.getKnownRepositories(true);
            DelegatingConnector[] connectors = BugtrackingManager.getInstance().getConnectors();
            RepositorySelectorBuilder selectorBuilder = new RepositorySelectorBuilder();
            selectorBuilder.setDisplayFormForExistingRepositories(true);
            selectorBuilder.setExistingRepositories(repos.toArray(new RepositoryImpl[repos.size()]));
            selectorBuilder.setBugtrackingConnectors(connectors);
            selectorBuilder.setPreselectedRepository(suggestedRepo);
            selectorBuilder.setLabelAboveComboBox();
            String dialogTitle = this.getMessage("LBL_BugtrackerSelectorTitle");
            DialogDescriptor dialogDescriptor = selectorBuilder.createDialogDescriptor(dialogTitle);
            Object selectedOption = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (selectedOption == NotifyDescriptor.OK_OPTION) {
                RepositoryImpl repository = selectorBuilder.getSelectedRepository();
                try {
                    repository.applyChanges();
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    repository = null;
                }
                return repository;
            }
            return null;
        }

        private String getMessage(String msgKey) {
            return NbBundle.getMessage(BugtrackingOwnerSupport.class, (String)msgKey);
        }
    }
}

