/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.jira.JiraUpdater;
import org.netbeans.modules.bugtracking.ui.nodes.BugtrackingRootNode;
import org.netbeans.modules.bugtracking.ui.selectors.SelectorPanel;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;

public class RepositorySelector {
    private SelectorPanel selectorPanel = new SelectorPanel();

    public RepositoryImpl create(boolean selectNode) {
        DelegatingConnector[] connectors = BugtrackingManager.getInstance().getConnectors();
        connectors = this.addJiraProxyIfNeeded(connectors);
        this.selectorPanel.setConnectors(connectors);
        if (!this.selectorPanel.open()) {
            return null;
        }
        final RepositoryImpl repo = this.selectorPanel.getRepository();
        try {
            repo.applyChanges();
            RepositoryRegistry.getInstance().addRepository(repo);
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
            return null;
        }
        if (selectNode) {
            BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    BugtrackingRootNode.selectNode(repo.getDisplayName());
                }
            });
        }
        return repo;
    }

    public boolean edit(RepositoryImpl repository, String errorMessage) {
        if (!this.selectorPanel.edit(repository, errorMessage)) {
            return false;
        }
        RepositoryImpl repo = this.selectorPanel.getRepository();
        try {
            repo.applyChanges();
            RepositoryRegistry.getInstance().addRepository(repo);
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    private DelegatingConnector[] addJiraProxyIfNeeded(DelegatingConnector[] connectors) {
        if (!BugtrackingUtil.isJiraInstalled()) {
            DelegatingConnector[] ret = new DelegatingConnector[connectors.length + 1];
            System.arraycopy(connectors, 0, ret, 0, connectors.length);
            ret[ret.length - 1] = JiraUpdater.getInstance().getConnector();
            connectors = ret;
        }
        return connectors;
    }
}

