/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.UIUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class QueryAction
extends SystemAction {
    public QueryAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(QueryAction.class, (String)"CTL_QueryAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(QueryAction.class);
    }

    public void actionPerformed(ActionEvent ev) {
        QueryAction.openQuery(null, WindowManager.getDefault().getRegistry().getActivatedNodes());
    }

    private static void openQuery(QueryImpl query, Node[] context) {
        QueryAction.openQuery(query, null, context);
    }

    public static void openQuery(QueryImpl query, RepositoryImpl repositoryToSelect) {
        QueryAction.openQuery(query, repositoryToSelect, null);
    }

    private static void openQuery(QueryImpl query, RepositoryImpl repositoryToSelect, Node[] context) {
        QueryAction.openQuery(query, repositoryToSelect, false);
    }

    public static void openQuery(QueryImpl query, RepositoryImpl repository, boolean suggestedSelectionOnly) {
        QueryAction.openQuery(query, repository, WindowManager.getDefault().getRegistry().getActivatedNodes(), suggestedSelectionOnly);
    }

    private static void openQuery(final QueryImpl query, final RepositoryImpl repository, final Node[] context, final boolean suggestedSelectionOnly) {
        BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                final File file = BugtrackingUtil.getFile(context);
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        BugtrackingManager.LOG.log(Level.FINE, "QueryAction.openQuery start. query [{0}]", new Object[]{query != null ? query.getDisplayName() : null});
                        UIUtils.setWaitCursor(true);
                        try {
                            QueryTopComponent tc = null;
                            if (query != null) {
                                tc = QueryTopComponent.find(query);
                            }
                            if (tc == null) {
                                tc = new QueryTopComponent();
                                tc.init(query, repository, file, suggestedSelectionOnly);
                            }
                            if (!tc.isOpened()) {
                                tc.open();
                            }
                            tc.requestActive();
                            BugtrackingManager.LOG.log(Level.FINE, "QueryAction.openQuery finnish. query [{0}]", new Object[]{query != null ? query.getDisplayName() : null});
                        }
                        finally {
                            UIUtils.setWaitCursor(false);
                        }
                    }
                });
            }
        });
    }

    public static void closeQuery(final QueryImpl query) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent tc = null;
                if (query != null) {
                    tc = WindowManager.getDefault().findTopComponent(query.getDisplayName());
                }
                if (tc != null) {
                    tc.close();
                }
            }
        });
    }
}

