/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.ui.query.FindInQueryBar;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class FindInQuerySupport {
    private IssueTable.IssueTableProvider tableProvider;
    private QueryImpl query;
    private FindInQueryBar bar = new FindInQueryBar(this);

    private FindInQuerySupport(TopComponent tc) {
        ActionMap actionMap = tc.getActionMap();
        CallbackSystemAction a = (CallbackSystemAction)SystemAction.get(org.openide.actions.FindAction.class);
        actionMap.put(a.getActionMapKey(), new FindAction());
    }

    static FindInQuerySupport create(TopComponent tc) {
        return new FindInQuerySupport(tc);
    }

    void setQuery(QueryImpl query) {
        this.query = query;
    }

    FindInQueryBar getFindBar() {
        return this.bar;
    }

    void reset() {
        this.getIssueTable().resetFilterBySummary();
    }

    protected void updatePattern() {
        this.getIssueTable().setFilterBySummary(this.bar.getText(), this.bar.getRegularExpression(), this.bar.getWholeWords(), this.bar.getMatchCase());
    }

    protected void cancel() {
        this.reset();
        this.bar.setVisible(false);
    }

    protected void switchHighlight(boolean on) {
        this.getIssueTable().switchFilterBySummaryHighlight(on);
    }

    private IssueTable getIssueTable() {
        return this.query.getIssueTable();
    }

    private class FindAction
    extends AbstractAction {
        private FindAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FindInQuerySupport.this.getIssueTable() == null) {
                return;
            }
            if (FindInQuerySupport.this.bar.isVisible()) {
                FindInQuerySupport.this.updatePattern();
            } else {
                FindInQuerySupport.this.bar.setVisible(true);
                FindInQuerySupport.this.updatePattern();
            }
            FindInQuerySupport.this.bar.requestFocusInWindow();
        }
    }
}

