/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.nodes.BugtrackingRootNode;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class RepositoryNode
extends AbstractNode
implements PropertyChangeListener {
    private RepositoryImpl repository;

    public RepositoryNode(RepositoryImpl repository) {
        super(Children.LEAF);
        this.repository = repository;
        this.setName(repository.getDisplayName());
        repository.addPropertyChangeListener(this);
    }

    public Image getIcon(int type) {
        return this.repository.getIcon();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new AbstractAction(((QueryAction)SystemAction.get(QueryAction.class)).getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryAction.openQuery(null, RepositoryNode.this.repository);
            }
        }, new AbstractAction(((IssueAction)SystemAction.get(IssueAction.class)).getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssueAction.createIssue(RepositoryNode.this.repository);
            }
        }, new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_EditRepository")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugtrackingUtil.editRepository(RepositoryNode.this.repository.getRepository());
            }
        }, new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_RemoveRepository")){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RepositoryNode.class, (String)"MSG_RemoveRepository", (Object[])new Object[]{RepositoryNode.this.repository.getDisplayName()}), NbBundle.getMessage(RepositoryNode.class, (String)"CTL_RemoveRepository"), 2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            RepositoryNode.this.repository.remove();
                        }
                    });
                }
            }
        }};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("bugtracking.repository.attributes.changed")) {
            Map oldMap = (Map)evt.getOldValue();
            Map newMap = (Map)evt.getNewValue();
            if (oldMap.containsKey("repository.attribute.displayName")) {
                this.fireDisplayNameChange((String)oldMap.get("repository.attribute.displayName"), (String)newMap.get("repository.attribute.displayName"));
            }
        }
    }
}

