/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.nodes;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.RepositoryImplComparator;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class BugtrackingRootNode
extends AbstractNode {
    private static final String BUGTRACKING_NODE_NAME = "bugtracking";
    private static final String ICON_BASE = "org/netbeans/modules/bugtracking/ui/resources/bugtracking.png";
    private static final Object LOCK_INIT = new Object();
    private static BugtrackingRootNode defaultInstance;

    private BugtrackingRootNode() {
        super(Children.create((ChildFactory)new RootNodeChildren(), (boolean)true));
        this.setName(BUGTRACKING_NODE_NAME);
        this.setDisplayName(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_BugtrackingNode"));
        this.setIconBaseWithExtension(ICON_BASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BugtrackingRootNode getDefault() {
        Object object = LOCK_INIT;
        synchronized (object) {
            if (defaultInstance == null) {
                defaultInstance = new BugtrackingRootNode();
            }
            return defaultInstance;
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_CreateRepository")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugtrackingUtil.createRepository();
            }
        }};
    }

    public static void selectNode(final String ... path) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                TopComponent tab = WindowManager.getDefault().findTopComponent("services");
                if (tab == null) {
                    BugtrackingManager.LOG.fine("No ServicesTab found");
                    return;
                }
                tab.open();
                tab.requestActive();
                if (!(tab instanceof ExplorerManager.Provider)) {
                    BugtrackingManager.LOG.fine("ServicesTab not an ExplorerManager.Provider");
                    return;
                }
                final ExplorerManager mgr = ((ExplorerManager.Provider)tab).getExplorerManager();
                final Node root = mgr.getRootContext();
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        Node _selected;
                        Node repository = NodeOp.findChild((Node)root, (String)BugtrackingRootNode.BUGTRACKING_NODE_NAME);
                        if (repository == null) {
                            BugtrackingManager.LOG.fine("ServicesTab does not contain node bugtracking");
                            return;
                        }
                        try {
                            _selected = NodeOp.findPath((Node)repository, (String[])path);
                        }
                        catch (NodeNotFoundException x) {
                            BugtrackingManager.LOG.log(Level.FINE, "Could not find subnode", x);
                            _selected = x.getClosestNode();
                        }
                        final Node selected = _selected;
                        Mutex.EVENT.readAccess(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    mgr.setSelectedNodes(new Node[]{selected});
                                }
                                catch (PropertyVetoException x) {
                                    BugtrackingManager.LOG.log(Level.FINE, "Could not select path", x);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private static class RootNodeChildren
    extends ChildFactory<RepositoryImpl>
    implements PropertyChangeListener {
        public RootNodeChildren() {
            RepositoryRegistry.getInstance().addPropertyChangeListener(this);
        }

        protected Node createNodeForKey(RepositoryImpl key) {
            return key.getNode();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("bugtracking.repositories.changed")) {
                this.refresh(false);
            }
        }

        protected boolean createKeys(List<RepositoryImpl> toPopulate) {
            toPopulate.addAll(RepositoryRegistry.getInstance().getRepositories());
            Collections.sort(toPopulate, new RepositoryImplComparator());
            return true;
        }
    }
}

