/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue.cache;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.openide.util.NbBundle;

public class IssueCacheUtils {
    public static boolean wasSeen(IssueImpl issue) {
        return IssueCacheUtils.getCache(issue).wasSeen(issue.getID());
    }

    public static void switchSeen(IssueImpl issue) {
        try {
            IssueCache cache = IssueCacheUtils.getCache(issue);
            String id = issue.getID();
            cache.setSeen(id, !cache.wasSeen(id));
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static void setSeen(IssueImpl issue, boolean seen) {
        try {
            IssueCacheUtils.getCache(issue).setSeen(issue.getID(), seen);
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static int getStatus(IssueImpl issue) {
        return IssueCacheUtils.getCache(issue).getStatus(issue.getID());
    }

    public static String getRecentChanges(IssueImpl issue) {
        String changes = IssueCacheUtils.getCache(issue).getRecentChanges(issue.getID());
        changes = changes == null ? "" : changes.trim();
        if (changes.equals("") && IssueCacheUtils.getCache(issue).getStatus(issue.getID()) == 8) {
            changes = NbBundle.getMessage(IssueCacheUtils.class, (String)"LBL_IssueModified");
        }
        return changes;
    }

    public static void addCacheListener(IssueImpl issue, PropertyChangeListener l) {
        IssueCacheUtils.getCache(issue).addPropertyChangeListener(issue.getIssue(), l);
    }

    public static void removeCacheListener(IssueImpl issue, PropertyChangeListener l) {
        IssueCacheUtils.getCache(issue).removePropertyChangeListener(issue.getIssue(), l);
    }

    private static IssueCache getCache(IssueImpl issue) {
        RepositoryImpl repo = issue.getRepositoryImpl();
        IssueCache cache = (IssueCache)repo.getLookup().lookup(IssueCache.class);
        assert (cache != null);
        return cache;
    }
}

