/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.ui.search.FindSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.LogUtils;
import org.netbeans.modules.bugtracking.util.RepositoryComboRenderer;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.netbeans.modules.bugtracking.util.UndoRedoSupport;
import org.openide.awt.Mnemonics;
import org.openide.awt.UndoRedo;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class IssueTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static Set<IssueTopComponent> openIssues = new HashSet<IssueTopComponent>();
    private IssueImpl issue;
    private RequestProcessor rp = new RequestProcessor("Bugtracking issue", 1, true);
    private RequestProcessor.Task prepareTask;
    private RepositoryComboSupport rs;
    private File context;
    private DelegatingUndoRedoManager delegatingUndoRedoManager;
    private BugtrackingController controller;
    private JLabel findIssuesLabel;
    private JPanel issuePanel;
    private JPanel jPanel1;
    private LinkButton newButton;
    private JLabel preparingLabel;
    private JLabel repoLabel;
    private JPanel repoPanel;
    private JComboBox repositoryComboBox;

    public IssueTopComponent() {
        this.initComponents();
        RepositoryRegistry.getInstance().addPropertyChangeListener(this);
        this.preparingLabel.setVisible(false);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IssueTopComponent.this.onNewClick();
            }
        });
        JComponent findBar = FindSupport.create(this).getFindBar();
        findBar.setVisible(false);
        this.issuePanel.add((Component)findBar, "Last");
    }

    public UndoRedo getUndoRedo() {
        if (this.delegatingUndoRedoManager == null) {
            this.delegatingUndoRedoManager = new DelegatingUndoRedoManager();
        }
        return this.delegatingUndoRedoManager;
    }

    public IssueImpl getIssue() {
        return this.issue;
    }

    public void initNewIssue(RepositoryImpl toSelect, File context) {
        this.initNewIssue(toSelect, false, context);
    }

    public void initNewIssue(RepositoryImpl defaultRepository, boolean suggestedSelectionOnly, File context) {
        LogUtils.logBugtrackingUsage(defaultRepository != null ? defaultRepository.getRepository() : null, "ISSUE_EDIT");
        this.context = context;
        Font f = new JLabel().getFont();
        int s = f.getSize();
        this.findIssuesLabel.setFont(this.repoLabel.getFont().deriveFont((float)s * 1.7f));
        if (defaultRepository != null && !suggestedSelectionOnly) {
            DefaultComboBoxModel<Repository> repoModel = new DefaultComboBoxModel<Repository>();
            repoModel.addElement(defaultRepository.getRepository());
            this.repositoryComboBox.setModel(repoModel);
            this.repositoryComboBox.setRenderer(new RepositoryComboRenderer());
            this.repositoryComboBox.setSelectedItem(defaultRepository.getRepository());
            this.repositoryComboBox.setEnabled(false);
            this.newButton.setEnabled(false);
            this.onRepoSelected();
        } else {
            this.rs = defaultRepository == null ? RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, false) : RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, defaultRepository.getRepository());
        }
        this.repositoryComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    IssueTopComponent.this.onRepoSelected();
                }
            }
        });
        this.setNameAndTooltip();
    }

    public void initNoIssue(final String issueId) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IssueTopComponent.this.preparingLabel.setVisible(true);
                IssueTopComponent.this.repoPanel.setVisible(false);
                if (issueId != null) {
                    String desc = NbBundle.getMessage(IssueTopComponent.class, (String)"LBL_OPENING_ISSUE", (Object[])new Object[]{issueId});
                    IssueTopComponent.this.preparingLabel.setText(desc);
                    IssueTopComponent.this.setName(NbBundle.getMessage(IssueTopComponent.class, (String)"LBL_LOADING_ISSUE", (Object[])new Object[]{issueId}));
                    IssueTopComponent.this.setToolTipText(desc);
                } else {
                    IssueTopComponent.this.setNameAndTooltip();
                }
            }
        });
    }

    public void setIssue(IssueImpl issue) {
        assert (this.issue == null);
        LogUtils.logBugtrackingUsage(issue.getRepositoryImpl().getRepository(), "ISSUE_EDIT");
        this.issue = issue;
        this.preparingLabel.setVisible(false);
        this.issuePanel.add((Component)issue.getController().getComponent(), "Center");
        if (this.isOpened()) {
            this.getController().opened();
        }
        ((DelegatingUndoRedoManager)this.getUndoRedo()).init();
        this.repoPanel.setVisible(false);
        this.setNameAndTooltip();
        issue.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.repoPanel = new JPanel();
        this.repositoryComboBox = new JComboBox();
        this.findIssuesLabel = new JLabel();
        this.repoLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.newButton = new LinkButton();
        this.issuePanel = new JPanel();
        this.preparingLabel = new JLabel();
        this.repoPanel.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        Mnemonics.setLocalizedText((JLabel)this.findIssuesLabel, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.findIssuesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.repoLabel, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.repoLabel.text"));
        this.repoLabel.setFocusCycleRoot(true);
        this.jPanel1.setOpaque(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 64, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 8, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.newButton.text"));
        GroupLayout repoPanelLayout = new GroupLayout(this.repoPanel);
        this.repoPanel.setLayout(repoPanelLayout);
        repoPanelLayout.setHorizontalGroup(repoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(repoPanelLayout.createSequentialGroup().addContainerGap().addGroup(repoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(repoPanelLayout.createSequentialGroup().addComponent(this.repoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.repositoryComboBox, -2, 225, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.newButton, -2, -1, -2)).addComponent(this.findIssuesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        repoPanelLayout.setVerticalGroup(repoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(repoPanelLayout.createSequentialGroup().addGap(50, 50, 50).addComponent(this.jPanel1, -2, -1, -2)).addGroup(repoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.findIssuesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(repoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repoLabel).addComponent(this.repositoryComboBox, -2, -1, -2).addComponent(this.newButton, -2, -1, -2))));
        this.issuePanel.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.issuePanel.setLayout(new BorderLayout());
        this.preparingLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.preparingLabel, (String)NbBundle.getMessage(IssueTopComponent.class, (String)"IssueTopComponent.preparingLabel.text"));
        this.issuePanel.add((Component)this.preparingLabel, "Center");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repoPanel, -1, -1, Short.MAX_VALUE).addComponent(this.issuePanel, -1, 466, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.repoPanel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.issuePanel, -1, 36, Short.MAX_VALUE)));
    }

    private void onNewClick() {
        RepositoryImpl repoImpl = BugtrackingUtil.createRepository();
        if (repoImpl != null) {
            Repository repo = repoImpl.getRepository();
            this.repositoryComboBox.addItem(repo);
            this.repositoryComboBox.setSelectedItem(repo);
        }
    }

    private void onRepoSelected() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        Cancellable c = new Cancellable(){

            public boolean cancel() {
                if (IssueTopComponent.this.prepareTask != null) {
                    IssueTopComponent.this.prepareTask.cancel();
                }
                return true;
            }
        };
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(IssueTopComponent.class, (String)"CTL_PreparingIssue"), (Cancellable)c);
        this.prepareTask = this.rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    OwnerInfo ownerInfo;
                    handle.start();
                    IssueTopComponent.this.preparingLabel.setVisible(true);
                    RepositoryImpl repo = IssueTopComponent.this.getRepository();
                    if (repo == null) {
                        return;
                    }
                    if (IssueTopComponent.this.issue != null) {
                        if (IssueTopComponent.this.controller != null) {
                            IssueTopComponent.this.issuePanel.remove(IssueTopComponent.this.controller.getComponent());
                        }
                        IssueTopComponent.this.issue.removePropertyChangeListener(IssueTopComponent.this);
                    }
                    IssueTopComponent.this.issue = repo.createNewIssue();
                    if (IssueTopComponent.this.issue == null) {
                        return;
                    }
                    ((DelegatingUndoRedoManager)IssueTopComponent.this.getUndoRedo()).init();
                    if (IssueTopComponent.this.context != null && BugtrackingUtil.isNbRepository(repo.getUrl()) && (ownerInfo = KenaiUtil.getOwnerInfo(IssueTopComponent.this.context)) != null) {
                        IssueTopComponent.this.issue.setContext(ownerInfo);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IssueTopComponent.this.controller = IssueTopComponent.this.getController();
                            IssueTopComponent.this.issuePanel.add((Component)IssueTopComponent.this.controller.getComponent(), "Center");
                            IssueTopComponent.this.controller.opened();
                            IssueTopComponent.this.issue.addPropertyChangeListener(IssueTopComponent.this);
                            IssueTopComponent.this.revalidate();
                            IssueTopComponent.this.repaint();
                            IssueTopComponent.this.focusFirstEnabledComponent();
                        }
                    });
                }
                finally {
                    IssueTopComponent.this.preparingLabel.setVisible(false);
                    handle.finish();
                    IssueTopComponent.this.prepareTask = null;
                }
            }
        });
    }

    private RepositoryImpl getRepository() {
        Object item = this.repositoryComboBox.getSelectedItem();
        if (item == null || !(item instanceof Repository)) {
            return null;
        }
        return APIAccessor.IMPL.getImpl((Repository)item);
    }

    private void focusFirstEnabledComponent() {
        this.repositoryComboBox.requestFocusInWindow();
        if (!this.repositoryComboBox.isEnabled()) {
            this.newButton.requestFocusInWindow();
            if (!this.newButton.isEnabled()) {
                this.newButton.transferFocus();
            }
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
        openIssues.add(this);
        if (this.issue != null) {
            this.getController().opened();
        }
        BugtrackingManager.LOG.log(Level.FINE, "IssueTopComponent Opened {0}", this.issue != null ? this.issue.getID() : "null");
    }

    public void componentClosed() {
        openIssues.remove(this);
        if (this.issue != null) {
            this.issue.removePropertyChangeListener(this);
            this.getController().closed();
        }
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        BugtrackingManager.LOG.log(Level.FINE, "IssueTopComponent Closed {0}", this.issue != null ? this.issue.getID() : "null");
    }

    public static synchronized IssueTopComponent find(IssueImpl issue) {
        return IssueTopComponent.find(issue, true);
    }

    public static synchronized IssueTopComponent find(IssueImpl issue, boolean forceCreate) {
        for (IssueTopComponent tc : openIssues) {
            if (!issue.equals(tc.getIssue())) continue;
            return tc;
        }
        if (!forceCreate) {
            return null;
        }
        IssueTopComponent tc = new IssueTopComponent();
        tc.setIssue(issue);
        return tc;
    }

    public static synchronized IssueTopComponent find(String issueId) {
        assert (issueId != null);
        for (IssueTopComponent tc : openIssues) {
            IssueImpl i = tc.getIssue();
            if (i == null || !issueId.equals(i.getID())) continue;
            return tc;
        }
        IssueTopComponent tc = new IssueTopComponent();
        return tc;
    }

    private void setNameAndTooltip() throws MissingResourceException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (IssueTopComponent.this.issue != null) {
                    IssueTopComponent.this.setName(IssueTopComponent.this.issue.getShortenedDisplayName());
                    IssueTopComponent.this.setToolTipText(IssueTopComponent.this.issue.getTooltip());
                } else {
                    IssueTopComponent.this.setName(NbBundle.getMessage(IssueTopComponent.class, (String)"CTL_IssueTopComponent"));
                    IssueTopComponent.this.setToolTipText(NbBundle.getMessage(IssueTopComponent.class, (String)"CTL_IssueTopComponent"));
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("issue.data_changed")) {
            this.repoPanel.setVisible(false);
            this.setNameAndTooltip();
        } else if (evt.getPropertyName().equals("bugtracking.repositories.changed")) {
            if (!this.repositoryComboBox.isEnabled()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (IssueTopComponent.this.rs != null) {
                        IssueTopComponent.this.rs.refreshRepositoryModel();
                    }
                }
            });
        }
    }

    public boolean requestFocusInWindow() {
        if (this.issue == null) {
            return this.repositoryComboBox.requestFocusInWindow();
        }
        return this.getController().getComponent().requestFocusInWindow();
    }

    private BugtrackingController getController() {
        return this.issue.getController();
    }

    private class DelegatingUndoRedoManager
    implements UndoRedo {
        private UndoRedo delegate;
        final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();

        private DelegatingUndoRedoManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init() {
            this.delegate = UndoRedoSupport.getUndoRedo(IssueTopComponent.this.issue);
            DelegatingUndoRedoManager delegatingUndoRedoManager = this;
            synchronized (delegatingUndoRedoManager) {
                for (ChangeListener l : this.listeners) {
                    this.delegate.addChangeListener(l);
                }
            }
            for (ChangeListener l : this.listeners) {
                l.stateChanged(new ChangeEvent(this.delegate));
            }
        }

        public boolean canUndo() {
            return this.delegate != null ? this.delegate.canUndo() : UndoRedo.NONE.canUndo();
        }

        public boolean canRedo() {
            return this.delegate != null ? this.delegate.canRedo() : UndoRedo.NONE.canRedo();
        }

        public void undo() throws CannotUndoException {
            if (this.delegate != null) {
                this.delegate.undo();
            } else {
                UndoRedo.NONE.undo();
            }
        }

        public void redo() throws CannotRedoException {
            if (this.delegate != null) {
                this.delegate.redo();
            } else {
                UndoRedo.NONE.redo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            if (this.delegate != null) {
                this.delegate.addChangeListener(l);
            } else {
                DelegatingUndoRedoManager delegatingUndoRedoManager = this;
                synchronized (delegatingUndoRedoManager) {
                    this.listeners.add(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            if (this.delegate != null) {
                this.delegate.removeChangeListener(l);
            } else {
                DelegatingUndoRedoManager delegatingUndoRedoManager = this;
                synchronized (delegatingUndoRedoManager) {
                    this.listeners.remove(l);
                }
            }
        }

        public String getUndoPresentationName() {
            return this.delegate != null ? this.delegate.getUndoPresentationName() : UndoRedo.NONE.getUndoPresentationName();
        }

        public String getRedoPresentationName() {
            return this.delegate != null ? this.delegate.getRedoPresentationName() : UndoRedo.NONE.getRedoPresentationName();
        }
    }
}

