/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.net.URL;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.tasklist.TaskListProvider;

public abstract class TaskListIssueProvider {
    protected void add(boolean openTaskList, LazyIssue ... issuesToAdd) {
        TaskListProvider.getInstance().add(this, openTaskList, issuesToAdd);
    }

    protected void add(LazyIssue ... issuesToAdd) {
        this.add(false, issuesToAdd);
    }

    protected void remove(LazyIssue ... issuesToAdd) {
        TaskListProvider.getInstance().remove(this, issuesToAdd);
    }

    protected void removeAll() {
        TaskListProvider.getInstance().removeAll(this);
    }

    public abstract void removed(LazyIssue var1);

    public static abstract class LazyIssue {
        private final URL url;
        private String name;
        private boolean valid;

        public LazyIssue(URL url, String name) {
            if (url == null) {
                throw new NullPointerException();
            }
            if (name == null) {
                throw new NullPointerException();
            }
            this.url = url;
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }

        protected final void setName(String name) {
            if (name != null) {
                this.name = name;
                this.setValid(false);
            }
        }

        public final URL getUrl() {
            return this.url;
        }

        public final boolean equals(Object obj) {
            if (obj != null && obj instanceof LazyIssue) {
                return this.url.toString().equals(((LazyIssue)obj).url.toString());
            }
            return false;
        }

        public final int hashCode() {
            return this.url.toString().hashCode();
        }

        public final boolean isValid() {
            return this.valid;
        }

        public final void setValid(boolean valid) {
            this.valid = valid;
            if (!valid) {
                TaskListProvider.getInstance().refresh();
            }
        }

        public abstract String getRepositoryUrl();

        public abstract List<? extends Action> getActions();

        public String toString() {
            return super.toString() + ": " + this.getName();
        }

        public abstract void open();
    }
}

