/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Query;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.spi.RepositoryProvider;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.UndoRedoSupport;

public final class BugtrackingFactory<R, Q, I> {
    public Repository createRepository(R r, RepositoryProvider<R, Q, I> rp, QueryProvider<Q, I> qp, IssueProvider<I> ip) {
        RepositoryInfo info = rp.getInfo(r);
        if (info != null) {
            String repositoryId = info.getId();
            String connectorId = rp.getInfo(r).getConnectorId();
            Repository repo = this.getRepository(connectorId, repositoryId);
            if (repo != null) {
                return repo;
            }
        }
        RepositoryImpl<R, Q, I> impl = new RepositoryImpl<R, Q, I>(r, rp, qp, ip);
        return impl.getRepository();
    }

    public Repository getRepository(String connectorId, String repositoryId) {
        RepositoryImpl impl = RepositoryRegistry.getInstance().getRepository(connectorId, repositoryId);
        if (impl == null) {
            return null;
        }
        return impl.getRepository();
    }

    public boolean isOpen(Repository repository, Q q) {
        Query query = this.getQuery(repository, q);
        return BugtrackingUtil.isOpened(APIAccessor.IMPL.getImpl(query));
    }

    public void openQuery(Repository repository, Q q) {
        Query query = this.getQuery(repository, q);
        if (query != null) {
            query.open(Query.QueryMode.SHOW_ALL);
        }
    }

    public void openIssue(Repository repository, I i) {
        Issue issue = this.getIssue(repository, i);
        if (issue != null) {
            issue.open();
        }
    }

    public UndoRedoSupport getUndoRedoSupport(Repository repository, I i) {
        return UndoRedoSupport.getSupport(this.getIssueImpl(repository, i));
    }

    private Query getQuery(Repository repository, Q q) {
        RepositoryImpl repositoryImpl = APIAccessor.IMPL.getImpl(repository);
        QueryImpl impl = repositoryImpl.getQuery(q);
        if (impl == null) {
            return null;
        }
        return impl.getQuery();
    }

    private Issue getIssue(Repository repository, I i) {
        IssueImpl impl = this.getIssueImpl(repository, i);
        return impl != null ? impl.getIssue() : null;
    }

    private IssueImpl getIssueImpl(Repository repository, I i) {
        RepositoryImpl repositoryImpl = APIAccessor.IMPL.getImpl(repository);
        return repositoryImpl.getIssue(i);
    }
}

