/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai.spi;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JLabel;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Query;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiAccessor;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiBugtrackingConnector;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiRepositories;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.kenai.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.nodes.Node;

public class KenaiUtil {
    public static KenaiAccessor getKenaiAccessor() {
        return BugtrackingManager.getInstance().getKenaiAccessor();
    }

    public static boolean isLoggedIn(URL url) {
        return KenaiUtil.isLoggedIn(url.toString());
    }

    public static boolean isLoggedIn(String url) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.isLoggedIn(url) : false;
    }

    public static boolean isKenai(Repository repo) {
        return APIAccessor.IMPL.getImpl(repo).getLookup().lookup(KenaiProject.class) != null;
    }

    public static PasswordAuthentication getPasswordAuthentication(String url, boolean forceLogin) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getPasswordAuthentication(url, forceLogin) : null;
    }

    public static boolean showLogin() {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.showLogin() : false;
    }

    public static Repository getRepository(String repositoryUrl) throws IOException {
        KenaiProject project = KenaiUtil.getKenaiProjectForRepository(repositoryUrl);
        return project != null ? KenaiUtil.getRepository(project) : null;
    }

    public static Repository getRepository(String url, String projectName) throws IOException {
        KenaiProject p = KenaiUtil.getKenaiProject(url, projectName);
        return p != null ? KenaiUtil.getRepository(p) : null;
    }

    public static Repository getRepository(KenaiProject project) {
        RepositoryImpl impl = KenaiRepositories.getInstance().getRepository(project);
        return impl != null ? impl.getRepository() : null;
    }

    public static Repository getRepository(KenaiProject project, boolean forceCreate) {
        RepositoryImpl impl = KenaiRepositories.getInstance().getRepository(project, forceCreate);
        return impl != null ? impl.getRepository() : null;
    }

    public static Collection<Repository> getRepositories(boolean pingOpenProjects) {
        Collection<RepositoryImpl> impls = KenaiRepositories.getInstance().getRepositories(pingOpenProjects);
        ArrayList<Repository> ret = new ArrayList<Repository>(impls.size());
        for (RepositoryImpl impl : impls) {
            ret.add(impl.getRepository());
        }
        return ret;
    }

    public static Collection<RepositoryUser> getProjectMembers(KenaiProject kp) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        try {
            return ka != null ? ka.getProjectMembers(kp) : Collections.EMPTY_LIST;
        }
        catch (IOException ex) {
            BugtrackingManager.LOG.log(Level.WARNING, null, ex);
            return Collections.EMPTY_LIST;
        }
    }

    public static String getChatLink(String id) {
        return "ISSUE:" + id;
    }

    public static void refreshOpenedQueries() {
        Set<QueryTopComponent> tcs = QueryTopComponent.getOpenQueries();
        for (QueryTopComponent tc : tcs) {
            tc.updateSavedQueries();
        }
    }

    public static boolean isNetbeansKenaiRegistered() {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.isNetbeansKenaiRegistered() : false;
    }

    public static JLabel createUserWidget(String userName, String host, String chatMessage) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        assert (ka != null);
        return ka.createUserWidget(userName, host, chatMessage);
    }

    public static OwnerInfo getOwnerInfo(Node node) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getOwnerInfo(node) : null;
    }

    public static OwnerInfo getOwnerInfo(File file) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getOwnerInfo(file) : null;
    }

    public static void logKenaiUsage(Object ... parameters) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        if (ka != null) {
            ka.logKenaiUsage(parameters);
        }
    }

    public static KenaiProject getKenaiProjectForRepository(String repositoryUrl) throws IOException {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getKenaiProjectForRepository(repositoryUrl) : null;
    }

    public static KenaiProject getKenaiProject(String url, String projectName) throws IOException {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getKenaiProject(url, projectName) : null;
    }

    public static KenaiProject[] getDashboardProjects() {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor();
        return ka != null ? ka.getDashboardProjects() : new KenaiProject[]{};
    }

    public static Repository findNBRepository() {
        DelegatingConnector[] connectors;
        for (DelegatingConnector c : connectors = BugtrackingManager.getInstance().getConnectors()) {
            KenaiBugtrackingConnector kenaiConnector;
            BugtrackingConnector bugtrackingConnector = c.getDelegate();
            if (!(bugtrackingConnector instanceof KenaiBugtrackingConnector) || (kenaiConnector = (KenaiBugtrackingConnector)bugtrackingConnector).getType() != KenaiBugtrackingConnector.BugtrackingType.BUGZILLA) continue;
            return kenaiConnector.findNBRepository();
        }
        return null;
    }

    public static void addRepository(Repository repository) {
        RepositoryRegistry.getInstance().addRepository(APIAccessor.IMPL.getImpl(repository));
    }

    public static KenaiProject getKenaiProject(Repository repository) {
        return (KenaiProject)APIAccessor.IMPL.getImpl(repository).getLookup().lookup(KenaiProject.class);
    }

    public static Query getAllIssuesQuery(Repository repository) {
        return APIAccessor.IMPL.getImpl(repository).getAllIssuesQuery();
    }

    public static Query getMyIssuesQuery(Repository repository) {
        return APIAccessor.IMPL.getImpl(repository).getMyIssuesQuery();
    }

    public static boolean needsLogin(Query query) {
        return APIAccessor.IMPL.getImpl(query).needsLogin();
    }

    public static KenaiBugtrackingConnector.BugtrackingType getType(Repository repo) {
        DelegatingConnector[] connectors;
        for (DelegatingConnector delegatingConnector : connectors = BugtrackingManager.getInstance().getConnectors()) {
            if (!delegatingConnector.getID().equals(APIAccessor.IMPL.getImpl(repo).getConnectorId())) continue;
            BugtrackingConnector bugtrackignConnector = delegatingConnector.getDelegate();
            assert (bugtrackignConnector instanceof KenaiBugtrackingConnector);
            return ((KenaiBugtrackingConnector)bugtrackignConnector).getType();
        }
        assert (false) : "no KenaiSupport available for repository [" + repo.getDisplayName() + "]";
        return null;
    }

    public static void closeQuery(Query query) {
        QueryAction.closeQuery(APIAccessor.IMPL.getImpl(query));
    }

    public static void createIssue(Repository repo) {
        IssueAction.createIssue(APIAccessor.IMPL.getImpl(repo));
    }

    public static void openNewQuery(Repository repository, boolean suggestedSelectionOnly) {
        QueryAction.openQuery(null, APIAccessor.IMPL.getImpl(repository), suggestedSelectionOnly);
    }

    public static void openQuery(Query query, Query.QueryMode mode, boolean suggestedSelectionOnly) {
        QueryImpl queryImpl = APIAccessor.IMPL.getImpl(query);
        queryImpl.open(suggestedSelectionOnly, mode);
    }

    public static Collection<Issue> getRecentIssues(Repository repo) {
        Collection<IssueImpl> c = BugtrackingUtil.getRecentIssues(APIAccessor.IMPL.getImpl(repo));
        ArrayList<Issue> ret = new ArrayList<Issue>(c.size());
        for (IssueImpl impl : c) {
            ret.add(impl.getIssue());
        }
        return ret;
    }

    public static Collection<Repository> getKnownRepositories(boolean b) {
        Collection<RepositoryImpl> c = BugtrackingUtil.getKnownRepositories(b);
        ArrayList<Repository> ret = new ArrayList<Repository>(c.size());
        for (RepositoryImpl impl : c) {
            ret.add(impl.getRepository());
        }
        return ret;
    }

    public static void addCacheListener(Issue issue, PropertyChangeListener l) {
        IssueCacheUtils.addCacheListener(APIAccessor.IMPL.getImpl(issue), l);
    }

    public static void removeCacheListener(Issue issue, PropertyChangeListener l) {
        IssueCacheUtils.removeCacheListener(APIAccessor.IMPL.getImpl(issue), l);
    }

    public static boolean isOpen(Issue issue) {
        return BugtrackingUtil.isOpened(APIAccessor.IMPL.getImpl(issue));
    }

    public static boolean isShowing(Issue issue) {
        return BugtrackingUtil.isOpened(APIAccessor.IMPL.getImpl(issue));
    }
}

