/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

final class SummaryTextFilter
extends Filter {
    private boolean highlighting;
    private Pattern pattern = Pattern.compile("$^");

    public void setText(String text, boolean regular, boolean wholeWords, boolean matchCase) {
        if (!regular) {
            text = Pattern.quote(text);
            if (wholeWords) {
                text = "\\b" + text + "\\b";
            }
        }
        int flags = 0;
        if (!matchCase) {
            flags |= 2;
        }
        try {
            this.pattern = Pattern.compile(text, flags);
        }
        catch (PatternSyntaxException psex) {
            String message = NbBundle.getMessage(SummaryTextFilter.class, (String)"FindInQueryBar.invalidExpression");
            StatusDisplayer.getDefault().setStatusText(message, 800);
        }
    }

    public void setHighlighting(boolean on) {
        this.highlighting = on;
    }

    @Override
    public String getDisplayName() {
        throw new IllegalStateException();
    }

    @Override
    public boolean accept(IssueNode node) {
        return this.pattern.matcher(node.getIssue().getSummary()).find();
    }

    boolean isHighLightingOn() {
        return this.highlighting;
    }

    Pattern getPattern() {
        return this.pattern;
    }
}

