/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public abstract class IssueNode<I>
extends AbstractNode {
    public static final String LABEL_NAME_SEEN = "issue.seen";
    public static final String LABEL_RECENT_CHANGES = "issue.recent_changes";
    public static final String LABEL_NAME_SUMMARY = "issue.summary";
    private IssueImpl issue;
    private I issueData;
    private String htmlDisplayName;
    private Action preferedAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            IssueNode.this.issue.open(true);
        }
    };

    public IssueNode(Repository repository, I issueData) {
        this(Children.LEAF, APIAccessor.IMPL.getImpl(repository).getIssue(issueData), issueData);
    }

    private IssueNode(Children children, IssueImpl issue, I issueData) {
        super(children, Lookups.fixed((Object[])new Object[]{issue}));
        this.issue = issue;
        this.issueData = issueData;
        this.initProperties();
        this.refreshHtmlDisplayName();
        IssueCacheUtils.addCacheListener(issue, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (IssueNode.this.issue.getIssue() != evt.getSource()) {
                    return;
                }
                if (evt.getPropertyName().equals("issue.seen_changed")) {
                    IssueNode.this.fireSeenValueChanged((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
                }
            }
        });
    }

    public IssueImpl getIssue() {
        return this.issue;
    }

    public I getIssueData() {
        return this.issueData;
    }

    protected abstract Node.Property<?>[] getProperties();

    public Action getPreferredAction() {
        return this.preferedAction;
    }

    public boolean wasSeen() {
        return IssueCacheUtils.wasSeen(this.issue);
    }

    private void initProperties() {
        Node.Property<?>[] properties;
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        for (Node.Property<?> property : properties = this.getProperties()) {
            ps.put(property);
        }
        ps.put((Node.Property)new RecentChangesProperty());
        ps.put((Node.Property)new SeenProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        this.htmlDisplayName = this.issue.getDisplayName();
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    void fireSeenValueChanged(final boolean oldValue, final boolean newValue) {
        if (oldValue != newValue) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Node.Property<?>[] properties;
                    IssueNode.this.firePropertyChange(IssueNode.LABEL_NAME_SEEN, oldValue, newValue);
                    for (Node.Property<?> p : properties = IssueNode.this.getProperties()) {
                        String pName;
                        if (!(p instanceof IssueProperty) || (pName = ((IssueProperty)p).getName()).equals(IssueNode.LABEL_NAME_SEEN)) continue;
                        IssueNode.this.firePropertyChange(pName, null, null);
                    }
                }
            });
        }
    }

    protected void fireDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Node.Property<?>[] properties;
                for (Node.Property<?> p : properties = IssueNode.this.getProperties()) {
                    if (!(p instanceof IssueProperty)) continue;
                    String pName = ((IssueProperty)p).getName();
                    IssueNode.this.firePropertyChange(pName, null, null);
                }
            }
        });
    }

    public abstract class IssueProperty<T>
    extends PropertySupport.ReadOnly
    implements Comparable<IssueProperty<T>> {
        protected IssueProperty(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception e) {
                BugtrackingManager.LOG.log(Level.INFO, null, e);
                return e.getLocalizedMessage();
            }
        }

        public I getIssueData() {
            return IssueNode.this.issueData;
        }

        public Issue getIssue() {
            return IssueNode.this.issue.getIssue();
        }

        @Override
        public int compareTo(IssueProperty<T> o) {
            return this.toString().compareTo(o.toString());
        }
    }

    public class RecentChangesProperty
    extends IssueProperty<String> {
        public RecentChangesProperty() {
            super(IssueNode.LABEL_RECENT_CHANGES, String.class, NbBundle.getMessage(IssueNode.class, (String)"CTL_Issue_Recent"), NbBundle.getMessage(IssueNode.class, (String)"CTL_Issue_Recent_Desc"));
        }

        public String getValue() {
            return IssueCacheUtils.getRecentChanges(APIAccessor.IMPL.getImpl(this.getIssue()));
        }

        @Override
        public int compareTo(IssueProperty<String> p) {
            if (p == null) {
                return 1;
            }
            if (p.getClass().isAssignableFrom(RecentChangesProperty.class)) {
                IssueImpl issueImpl = APIAccessor.IMPL.getImpl(this.getIssue());
                String recentChanges1 = IssueCacheUtils.getRecentChanges(issueImpl);
                issueImpl = APIAccessor.IMPL.getImpl(((RecentChangesProperty)p).getIssue());
                String recentChanges2 = IssueCacheUtils.getRecentChanges(issueImpl);
                return recentChanges1.compareToIgnoreCase(recentChanges2);
            }
            return 1;
        }
    }

    public class SeenProperty
    extends IssueProperty<Boolean> {
        public SeenProperty() {
            super(IssueNode.LABEL_NAME_SEEN, Boolean.class, "", NbBundle.getMessage(IssueNode.class, (String)"CTL_Issue_Seen_Desc"));
        }

        public Boolean getValue() {
            return IssueCacheUtils.wasSeen(IssueNode.this.issue);
        }

        @Override
        public int compareTo(IssueProperty p) {
            if (p == null) {
                return 1;
            }
            Boolean b1 = IssueNode.this.wasSeen();
            Boolean b2 = IssueCacheUtils.wasSeen(APIAccessor.IMPL.getImpl(p.getIssue()));
            return b1.compareTo(b2);
        }
    }

    public class SummaryProperty
    extends IssueProperty<String> {
        public SummaryProperty() {
            super(IssueNode.LABEL_NAME_SUMMARY, String.class, NbBundle.getMessage(IssueNode.class, (String)"CTL_Issue_Summary_Title"), NbBundle.getMessage(IssueNode.class, (String)"CTL_Issue_Summary_Desc"));
        }

        public String getValue() {
            return this.getIssue().getSummary();
        }

        @Override
        public int compareTo(IssueProperty p) {
            if (p == null) {
                return 1;
            }
            String s1 = this.getIssue().getSummary();
            String s2 = p.getIssue().getSummary();
            return s1.compareTo(s2);
        }
    }
}

