/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;

public final class RepositoryManager {
    public static final String EVENT_REPOSITORIES_CHANGED = "bugtracking.repositories.changed";
    private static RepositoryManager instance;
    private static RepositoryRegistry impl;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    private RepositoryManager() {
        impl = RepositoryRegistry.getInstance();
        impl.addPropertyChangeListener(new RepositoryListener());
    }

    public static synchronized RepositoryManager getInstance() {
        if (instance == null) {
            instance = new RepositoryManager();
        }
        return instance;
    }

    public void addPropertChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public Collection<Repository> getRepositories() {
        Collection<Repository> ret = this.toRepositories(impl.getRepositories());
        return ret;
    }

    public Collection<Repository> getRepositories(String connectorId) {
        Collection<Repository> ret = this.toRepositories(RepositoryRegistry.getInstance().getRepositories(connectorId));
        return ret;
    }

    public Repository createRepository() {
        RepositoryImpl impl = BugtrackingUtil.createRepository(false);
        return impl != null ? impl.getRepository() : null;
    }

    public void editRepository(Repository repository) {
        BugtrackingUtil.editRepository(repository);
    }

    private Collection<Repository> toRepositories(Collection<RepositoryImpl> impls) {
        ArrayList<Repository> ret = new ArrayList<Repository>(impls.size());
        for (RepositoryImpl impl : impls) {
            ret.add(impl.getRepository());
        }
        return ret;
    }

    private class RepositoryListener
    implements PropertyChangeListener {
        private RepositoryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (RepositoryManager.EVENT_REPOSITORIES_CHANGED.equals(evt.getPropertyName())) {
                Collection newImpls = (Collection)evt.getNewValue();
                Collection oldImpls = (Collection)evt.getOldValue();
                RepositoryManager.this.changeSupport.firePropertyChange(RepositoryManager.EVENT_REPOSITORIES_CHANGED, RepositoryManager.this.toRepositories(oldImpls), RepositoryManager.this.toRepositories(newImpls));
            }
        }
    }
}

