/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.api.APIAccessorImpl;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Query;

public final class Repository {
    public static final String EVENT_QUERY_LIST_CHANGED = "bugtracking.repository.queries.changed";
    public static final String EVENT_ATTRIBUTES_CHANGED = "bugtracking.repository.attributes.changed";
    public static final String ATTRIBUTE_URL = "repository.attribute.url";
    public static final String ATTRIBUTE_DISPLAY_NAME = "repository.attribute.displayName";
    private final RepositoryImpl<?, ?, ?> impl;

    <R, Q, I> Repository(RepositoryImpl<R, Q, I> impl) {
        this.impl = impl;
    }

    public Image getIcon() {
        return this.impl.getIcon();
    }

    public String getDisplayName() {
        return this.impl.getDisplayName();
    }

    public String getTooltip() {
        return this.impl.getTooltip();
    }

    public String getId() {
        return this.impl.getId();
    }

    public String getUrl() {
        return this.impl.getUrl();
    }

    public Collection<Query> getQueries() {
        Collection<QueryImpl> c = this.impl.getQueries();
        ArrayList<Query> ret = new ArrayList<Query>();
        for (QueryImpl q : c) {
            ret.add(q.getQuery());
        }
        return ret;
    }

    public void remove() {
        this.impl.remove();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.impl.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.impl.removePropertyChangeListener(listener);
    }

    public Issue[] getIssues(String ... ids) {
        Collection<IssueImpl> impls = this.impl.getIssueImpls(ids);
        ArrayList<Issue> ret = new ArrayList<Issue>(impls.size());
        for (IssueImpl issueImpl : impls) {
            ret.add(issueImpl.getIssue());
        }
        return ret.toArray(new Issue[ret.size()]);
    }

    <R, Q, I> RepositoryImpl<R, Q, I> getImpl() {
        return this.impl;
    }

    static {
        APIAccessorImpl.createAccesor();
    }
}

