/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;

public final class Query {
    public static final String EVENT_QUERY_ISSUES_CHANGED = "bugtracking.query.issues_changed";
    public static final String EVENT_QUERY_SAVED = "bugtracking.query.saved";
    public static final String EVENT_QUERY_REMOVED = "bugtracking.query.removed";
    private QueryImpl impl;

    Query(QueryImpl impl) {
        this.impl = impl;
    }

    public String getTooltip() {
        return this.impl.getTooltip();
    }

    public Collection<Issue> getIssues() {
        List<Issue> ret = this.toIssues(this.impl.getIssues());
        return ret;
    }

    public String getDisplayName() {
        return this.impl.getDisplayName();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.impl.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.impl.removePropertyChangeListener(listener);
    }

    public void refresh() {
        this.impl.refresh();
    }

    public void open(QueryMode mode) {
        this.impl.open(false, mode);
    }

    public void remove() {
        this.impl.remove();
    }

    public static void openNew(Repository repository) {
        QueryAction.openQuery(null, repository.getImpl());
    }

    QueryImpl getImpl() {
        return this.impl;
    }

    public Repository getRepository() {
        return this.impl.getRepositoryImpl().getRepository();
    }

    private List<Issue> toIssues(Collection<IssueImpl> c) {
        ArrayList<Issue> ret = new ArrayList<Issue>(c.size());
        for (IssueImpl i : c) {
            ret.add(i.getIssue());
        }
        return ret;
    }

    public boolean isSaved() {
        return this.impl.isSaved();
    }

    public static enum QueryMode {
        SHOW_ALL,
        SHOW_NEW_OR_CHANGED,
        EDIT;

    }
}

