/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.SPIAccessor;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.util.NbPreferences;

public class RepositoryRegistry {
    public static final String EVENT_REPOSITORIES_CHANGED = "bugtracking.repositories.changed";
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static final String BUGTRACKING_REPO = "bugracking.repository_";
    private static final String DELIMITER = "<=>";
    private static final Object REPOSITORIES_LOCK = new Object();
    private static RepositoryRegistry instance;
    private RepositoriesMap repositories;
    private static final String JIRA_REPO_ID = "jira.repository_";
    private static final String BUGZILLA_REPO_ID = "bugzilla.repository_";
    private static final String NB_BUGZILLA_USERNAME = "nbbugzilla.username";
    private static final String NB_BUGZILLA_PASSWORD = "nbbugzilla.password";
    private static final String REPOSITORY_SETTING_SHORT_LOGIN = "bugzilla.shortLoginEnabled";

    private RepositoryRegistry() {
    }

    public static synchronized RepositoryRegistry getInstance() {
        if (instance == null) {
            instance = new RepositoryRegistry();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RepositoryImpl> getRepositories() {
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            List<RepositoryImpl> l = this.getStoredRepositories().getRepositories();
            return new LinkedList<RepositoryImpl>(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RepositoryImpl> getRepositories(String connectorID) {
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            Map m = (Map)this.getStoredRepositories().get(connectorID);
            if (m != null) {
                return new LinkedList<RepositoryImpl>(m.values());
            }
            return Collections.emptyList();
        }
    }

    public RepositoryImpl getRepository(String connectorId, String repoId) {
        Collection<RepositoryImpl> repos = this.getRepositories(connectorId);
        for (RepositoryImpl repo : repos) {
            if (!repo.getId().equals(repoId)) continue;
            return repo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(RepositoryImpl repository) {
        Collection<RepositoryImpl> newRepos;
        Collection<RepositoryImpl> oldRepos;
        assert (repository != null);
        if (KenaiUtil.isKenai(repository.getRepository()) && !BugtrackingUtil.isNbRepository(repository.getUrl())) {
            return;
        }
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            oldRepos = Collections.unmodifiableCollection(new LinkedList<RepositoryImpl>(this.getStoredRepositories().getRepositories()));
            this.getStoredRepositories().put(repository);
            this.putRepository(repository);
            newRepos = Collections.unmodifiableCollection(this.getStoredRepositories().getRepositories());
        }
        this.fireRepositoriesChanged(oldRepos, newRepos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(RepositoryImpl repository) {
        Collection<RepositoryImpl> newRepos;
        Collection<RepositoryImpl> oldRepos;
        Object object = REPOSITORIES_LOCK;
        synchronized (object) {
            oldRepos = Collections.unmodifiableCollection(this.getStoredRepositories().getRepositories());
            RepositoryInfo info = repository.getInfo();
            String connectorID = info.getConnectorId();
            this.getPreferences().remove(this.getRepositoryKey(info));
            this.getStoredRepositories().remove(connectorID, repository);
            newRepos = Collections.unmodifiableCollection(this.getStoredRepositories().getRepositories());
        }
        this.fireRepositoriesChanged(oldRepos, newRepos);
    }

    public Collection<RepositoryImpl> getKnownRepositories(boolean pingOpenProjects) {
        Collection<RepositoryImpl> otherRepos = this.getRepositories();
        Collection<Repository> kenaiRepos = KenaiUtil.getRepositories(pingOpenProjects);
        ArrayList<RepositoryImpl> ret = new ArrayList<RepositoryImpl>(kenaiRepos.size() + otherRepos.size());
        ret.addAll(otherRepos);
        for (Repository r : kenaiRepos) {
            ret.add(APIAccessor.IMPL.getImpl(r));
        }
        return ret;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    void flushRepositories() {
        this.repositories = null;
    }

    private String getRepositoryKey(RepositoryInfo info) {
        return BUGTRACKING_REPO + info.getConnectorId() + DELIMITER + info.getId();
    }

    private RepositoriesMap getStoredRepositories() {
        if (this.repositories == null) {
            this.repositories = new RepositoriesMap();
            this.migrateBugzilla();
            this.migrateJira();
            String[] ids = this.getRepositoryIds();
            if (ids == null || ids.length == 0) {
                return this.repositories;
            }
            DelegatingConnector[] connectors = BugtrackingManager.getInstance().getConnectors();
            for (String id : ids) {
                String[] idArray = id.split(DELIMITER);
                String connectorId = idArray[0].substring(BUGTRACKING_REPO.length());
                for (DelegatingConnector c : connectors) {
                    Repository repo;
                    RepositoryInfo info;
                    if (!c.getID().equals(connectorId) || (info = SPIAccessor.IMPL.read(this.getPreferences(), id)) == null || (repo = c.createRepository(info)) == null) continue;
                    this.repositories.put(APIAccessor.IMPL.getImpl(repo));
                }
            }
        }
        return this.repositories;
    }

    private String[] getRepositoryIds() {
        return this.getKeysWithPrefix(BUGTRACKING_REPO);
    }

    void putRepository(RepositoryImpl repository) {
        RepositoryInfo info = repository.getInfo();
        String key = this.getRepositoryKey(info);
        SPIAccessor.IMPL.store(this.getPreferences(), info, key);
        char[] password = info.getPassword();
        char[] httpPassword = info.getHttpPassword();
        BugtrackingUtil.savePassword(password, null, info.getUsername(), info.getUrl());
        BugtrackingUtil.savePassword(httpPassword, "http", info.getHttpUsername(), info.getUrl());
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(RepositoryRegistry.class);
    }

    private String[] getKeysWithPrefix(String prefix) {
        String[] keys = null;
        try {
            keys = this.getPreferences().keys();
        }
        catch (BackingStoreException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
        if (keys == null || keys.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            ret.add(key);
        }
        return ret.toArray(new String[ret.size()]);
    }

    private void fireRepositoriesChanged(Collection<RepositoryImpl> oldRepositories, Collection<RepositoryImpl> newRepositories) {
        this.changeSupport.firePropertyChange(EVENT_REPOSITORIES_CHANGED, oldRepositories, newRepositories);
    }

    private void migrateBugzilla() {
        String[] repoIds;
        Preferences preferences = RepositoryRegistry.getBugzillaPreferences();
        for (String id : repoIds = this.getRepoIds(preferences, BUGZILLA_REPO_ID)) {
            this.migrateBugzillaRepository(preferences, id);
            preferences.remove(BUGZILLA_REPO_ID + id);
        }
        preferences.remove(NB_BUGZILLA_USERNAME);
    }

    private void migrateJira() {
        String[] repoIds;
        Preferences preferences = RepositoryRegistry.getJiraPreferences();
        for (String id : repoIds = this.getRepoIds(preferences, JIRA_REPO_ID)) {
            this.migrateJiraRepository(preferences, id);
            preferences.remove(JIRA_REPO_ID + id);
        }
    }

    private String[] getRepoIds(Preferences preferences, String repoId) {
        String[] keys = null;
        try {
            keys = preferences.keys();
        }
        catch (BackingStoreException ex) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
        }
        if (keys == null || keys.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String key : keys) {
            if (!key.startsWith(repoId)) continue;
            ret.add(key.substring(repoId.length()));
        }
        return ret.toArray(new String[ret.size()]);
    }

    private void migrateBugzillaRepository(Preferences preferences, String repoID) {
        char[] password;
        String user;
        String[] values = RepositoryRegistry.getRepositoryValues(preferences, BUGZILLA_REPO_ID, repoID);
        if (values == null) {
            return;
        }
        assert (values.length == 3 || values.length == 6 || values.length == 7);
        String url = values[0];
        if (BugtrackingUtil.isNbRepository(url)) {
            user = RepositoryRegistry.getBugzillaNBUsername();
            char[] psswdArray = RepositoryRegistry.getNBPassword();
            password = psswdArray != null ? psswdArray : new char[]{};
        } else {
            user = values[1];
            password = BugtrackingUtil.readPassword(values[2], null, user, url);
        }
        String httpUser = values.length > 3 ? values[3] : null;
        char[] httpPassword = values.length > 3 ? BugtrackingUtil.readPassword(values[4], "http", httpUser, url) : new char[]{};
        String shortNameEnabled = "false";
        if (values.length > 5) {
            shortNameEnabled = values[5];
        }
        String name = values.length > 6 ? values[6] : repoID;
        RepositoryInfo info = new RepositoryInfo(repoID, "org.netbeans.modules.bugzilla", url, name, name, user, httpUser, password, httpPassword);
        info.putValue(REPOSITORY_SETTING_SHORT_LOGIN, shortNameEnabled);
        SPIAccessor.IMPL.store(this.getPreferences(), info, this.getRepositoryKey(info));
    }

    private void migrateJiraRepository(Preferences preferences, String repoID) {
        String[] values = RepositoryRegistry.getRepositoryValues(preferences, JIRA_REPO_ID, repoID);
        String url = values[0];
        String user = values[1];
        String password = new String(BugtrackingUtil.readPassword(values[2], null, user, url));
        String httpUser = values.length > 3 ? values[3] : null;
        String httpPassword = new String(values.length > 3 ? BugtrackingUtil.readPassword(values[4], "http", httpUser, url) : null);
        String repoName = values.length > 5 ? values[5] : repoID;
        RepositoryInfo info = new RepositoryInfo(repoID, "org.netbeans.modules.jira", url, repoName, repoName, user, httpUser, password.toCharArray(), httpPassword.toCharArray());
        SPIAccessor.IMPL.store(this.getPreferences(), info, this.getRepositoryKey(info));
    }

    private static String[] getRepositoryValues(Preferences preferences, String repoPrefix, String repoID) {
        String repoString = preferences.get(repoPrefix + repoID, "");
        if (repoString.equals("")) {
            return null;
        }
        return repoString.split(DELIMITER);
    }

    private static Preferences getBugzillaPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/bugzilla");
    }

    private static Preferences getJiraPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/jira");
    }

    public static String getBugzillaNBUsername() {
        String user = RepositoryRegistry.getBugzillaPreferences().get(NB_BUGZILLA_USERNAME, "");
        return user;
    }

    private static char[] getNBPassword() {
        return Keyring.read((String)NB_BUGZILLA_PASSWORD);
    }

    private class RepositoriesMap
    extends HashMap<String, Map<String, RepositoryImpl>> {
        private RepositoriesMap() {
        }

        public void remove(String connectorID, RepositoryImpl repository) {
            Map m = (Map)this.get(connectorID);
            if (m != null) {
                m.remove(repository.getId());
            }
        }

        public void put(RepositoryImpl repository) {
            String connectorID = repository.getInfo().getConnectorId();
            HashMap<String, RepositoryImpl> m = (HashMap<String, RepositoryImpl>)this.get(connectorID);
            if (m == null) {
                m = new HashMap<String, RepositoryImpl>();
                this.put(connectorID, m);
            }
            m.put(repository.getId(), repository);
        }

        List<RepositoryImpl> getRepositories() {
            LinkedList<RepositoryImpl> ret = new LinkedList<RepositoryImpl>();
            for (Map.Entry e : this.entrySet()) {
                ret.addAll(((Map)e.getValue()).values());
            }
            return ret;
        }
    }
}

