/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Query;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiRepositoryProvider;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugtracking.spi.RepositoryController;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.spi.RepositoryProvider;
import org.netbeans.modules.bugtracking.ui.nodes.RepositoryNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class RepositoryImpl<R, Q, I> {
    private final PropertyChangeSupport support;
    private RepositoryNode node;
    private final RepositoryProvider<R, Q, I> repositoryProvider;
    private final IssueProvider<I> issueProvider;
    private final QueryProvider<Q, I> queryProvider;
    private final R r;
    private Map<I, IssueImpl> issueMap = new HashMap<I, IssueImpl>();
    private Map<Q, QueryImpl> queryMap = new HashMap<Q, QueryImpl>();
    private Repository repository;

    public RepositoryImpl(R r, RepositoryProvider<R, Q, I> repositoryProvider, QueryProvider<Q, I> queryProvider, IssueProvider<I> issueProvider) {
        this.repositoryProvider = repositoryProvider;
        this.issueProvider = issueProvider;
        this.queryProvider = queryProvider;
        this.r = r;
        this.support = new PropertyChangeSupport(this);
    }

    public Repository getRepository() {
        if (this.repository == null) {
            this.repository = APIAccessor.IMPL.createRepository(this);
        }
        return this.repository;
    }

    public Image getIcon() {
        return this.repositoryProvider.getIcon(this.r);
    }

    public final Node getNode() {
        if (this.node == null) {
            this.node = new RepositoryNode(this);
        }
        return this.node;
    }

    public String getDisplayName() {
        return this.repositoryProvider.getInfo(this.r).getDisplayName();
    }

    public String getTooltip() {
        return this.repositoryProvider.getInfo(this.r).getTooltip();
    }

    public String getId() {
        return this.getInfo().getId();
    }

    public RepositoryInfo getInfo() {
        return this.repositoryProvider.getInfo(this.r);
    }

    public String getUrl() {
        return this.getInfo().getUrl();
    }

    public Lookup getLookup() {
        return this.repositoryProvider.getLookup(this.r);
    }

    public Collection<IssueImpl> getIssueImpls(String ... ids) {
        I[] is = this.repositoryProvider.getIssues(this.r, ids);
        if (is == null || is.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IssueImpl> ret = new ArrayList<IssueImpl>(is.length);
        for (I i : is) {
            IssueImpl impl = this.getIssue(i);
            if (impl == null) continue;
            ret.add(impl);
        }
        return ret;
    }

    R getData() {
        return this.r;
    }

    public QueryImpl createNewQuery() {
        return this.getQuery(this.repositoryProvider.createQuery(this.r));
    }

    public IssueImpl createNewIssue() {
        I issueData = this.repositoryProvider.createIssue(this.r);
        return this.getIssue(issueData);
    }

    public RepositoryProvider<R, Q, I> getProvider() {
        return this.repositoryProvider;
    }

    public Collection<IssueImpl> simpleSearch(String criteria) {
        Collection<I> issues = this.repositoryProvider.simpleSearch(this.r, criteria);
        ArrayList<IssueImpl> ret = new ArrayList<IssueImpl>(issues.size());
        for (I i : issues) {
            ret.add(this.getIssue(i));
        }
        return ret;
    }

    public Collection<QueryImpl> getQueries() {
        Collection<Q> queries = this.repositoryProvider.getQueries(this.r);
        ArrayList<QueryImpl> ret = new ArrayList<QueryImpl>(queries.size());
        for (Q q : queries) {
            ret.add(this.getQuery(q));
        }
        return ret;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    void fireQueryListChanged() {
        this.support.firePropertyChange("bugtracking.repository.queries.changed", null, null);
    }

    void fireAttributesChanged(Map<String, Object> oldAttributes, Map<String, Object> newAttributes) {
        LinkedList<String> equalAttributes = new LinkedList<String>();
        for (Map.Entry<String, Object> e : newAttributes.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            Object oldValue = oldAttributes.get(key);
            if ((value != null || oldValue != null) && (value == null || !value.equals(oldValue))) continue;
            equalAttributes.add(key);
        }
        for (String equalAttribute : equalAttributes) {
            if (oldAttributes != null) {
                oldAttributes.remove(equalAttribute);
            }
            newAttributes.remove(equalAttribute);
        }
        if (!newAttributes.isEmpty()) {
            this.support.firePropertyChange(new PropertyChangeEvent(this, "bugtracking.repository.attributes.changed", oldAttributes, newAttributes));
        }
    }

    public void applyChanges() throws IOException {
        HashMap<String, Object> oldAttributes = this.createAttributesMap();
        this.repositoryProvider.getController(this.getData()).applyChanges();
        HashMap<String, Object> newAttributes = this.createAttributesMap();
        this.fireAttributesChanged(oldAttributes, newAttributes);
    }

    private HashMap<String, Object> createAttributesMap() {
        HashMap<String, Object> attributes = new HashMap<String, Object>(2);
        if (this.getInfo() != null) {
            attributes.put("repository.attribute.displayName", this.getDisplayName());
            attributes.put("repository.attribute.url", this.getUrl());
        }
        return attributes;
    }

    public String getConnectorId() {
        return this.getInfo().getConnectorId();
    }

    public synchronized IssueImpl getIssue(I i) {
        if (i == null) {
            return null;
        }
        IssueImpl<I> issue = this.issueMap.get(i);
        if (issue == null) {
            issue = new IssueImpl<I>(this, this.issueProvider, i);
            this.issueMap.put(i, issue);
        }
        return issue;
    }

    public QueryImpl getQuery(Q q) {
        if (q == null) {
            return null;
        }
        QueryImpl<Q, I> query = this.queryMap.get(q);
        if (query == null) {
            query = new QueryImpl<Q, I>(this, this.queryProvider, this.issueProvider, q);
            this.queryMap.put(q, query);
        }
        return query;
    }

    public Query getAllIssuesQuery() {
        assert (KenaiRepositoryProvider.class.isAssignableFrom(this.repositoryProvider.getClass()));
        Object q = ((KenaiRepositoryProvider)this.repositoryProvider).getAllIssuesQuery(this.r);
        QueryImpl queryImpl = this.getQuery(q);
        return queryImpl != null ? queryImpl.getQuery() : null;
    }

    public Query getMyIssuesQuery() {
        assert (KenaiRepositoryProvider.class.isAssignableFrom(this.repositoryProvider.getClass()));
        Object q = ((KenaiRepositoryProvider)this.repositoryProvider).getMyIssuesQuery(this.r);
        QueryImpl queryImpl = this.getQuery(q);
        return queryImpl != null ? queryImpl.getQuery() : null;
    }

    public void remove() {
        this.repositoryProvider.remove(this.r);
        RepositoryRegistry.getInstance().removeRepository(this);
    }

    public RepositoryController getController() {
        return this.repositoryProvider.getController(this.r);
    }
}

