/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core.api;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.netbeans.modules.versioning.core.APIAccessor;
import org.netbeans.modules.versioning.core.FlatFolder;
import org.netbeans.modules.versioning.core.api.APIAccessorImpl;
import org.netbeans.modules.versioning.core.filesystems.VCSFileProxyOperations;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class VCSFileProxy {
    private final String path;
    private final VCSFileProxyOperations proxy;
    private boolean isFlat = false;
    private Boolean isDirectory = null;

    private VCSFileProxy(String path, VCSFileProxyOperations proxy) {
        this.path = path;
        this.proxy = proxy;
    }

    public static VCSFileProxy createFileProxy(File file) {
        VCSFileProxy p = new VCSFileProxy(file.getAbsolutePath(), null);
        if (file instanceof FlatFolder) {
            p.setFlat(true);
        }
        return p;
    }

    public static VCSFileProxy createFileProxy(VCSFileProxy parent, String child) {
        return new VCSFileProxy(parent.getPath() + "/" + child, parent.proxy);
    }

    static VCSFileProxy createFileProxy(String path) {
        return new VCSFileProxy(path, null);
    }

    static VCSFileProxy createFileProxy(VCSFileProxy parent, String child, boolean isDirectory) {
        VCSFileProxy file = new VCSFileProxy(parent.getPath() + "/" + child, parent.proxy);
        file.isDirectory = isDirectory;
        return file;
    }

    public static VCSFileProxy createFileProxy(FileObject fileObject) {
        try {
            VCSFileProxyOperations fileProxyOperations = VCSFileProxy.getFileProxyOperations(fileObject.getFileSystem());
            if (fileProxyOperations == null) {
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file != null) {
                    return VCSFileProxy.createFileProxy(file, fileObject.isFolder());
                }
                return null;
            }
            return new VCSFileProxy(fileObject.getPath(), fileProxyOperations);
        }
        catch (FileStateInvalidException ex) {
            Logger.getLogger(VCSFileProxy.class.getName()).log(Level.SEVERE, null, ex);
            return new VCSFileProxy(fileObject.getPath(), null);
        }
    }

    static VCSFileProxy createFileProxy(File file, boolean isDirectory) {
        VCSFileProxy p = VCSFileProxy.createFileProxy(file);
        p.isDirectory = isDirectory;
        return p;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        if (this.proxy == null) {
            return new File(this.path).getName();
        }
        return this.proxy.getName(this);
    }

    public boolean isDirectory() {
        if (this.proxy == null) {
            if (this.isDirectory != null) {
                return this.isDirectory;
            }
            return new File(this.path).isDirectory();
        }
        return this.proxy.isDirectory(this);
    }

    public boolean isFile() {
        if (this.proxy == null) {
            if (this.isDirectory != null) {
                return this.isDirectory == false;
            }
            return new File(this.path).isFile();
        }
        return this.proxy.isFile(this);
    }

    public boolean canWrite() {
        if (this.proxy == null) {
            return new File(this.path).canWrite();
        }
        return this.proxy.canWrite(this);
    }

    public VCSFileProxy getParentFile() {
        if (this.proxy == null) {
            File parent = new File(this.path).getParentFile();
            if (parent == null) {
                return null;
            }
            return VCSFileProxy.createFileProxy(parent);
        }
        return this.proxy.getParentFile(this);
    }

    public boolean exists() {
        if (this.proxy == null) {
            return new File(this.path).exists();
        }
        return this.proxy.exists(this);
    }

    public VCSFileProxy[] listFiles() {
        if (this.proxy == null) {
            File[] files = new File(this.path).listFiles();
            if (files != null) {
                VCSFileProxy[] ret = new VCSFileProxy[files.length];
                for (int i = 0; i < files.length; ++i) {
                    ret[i] = VCSFileProxy.createFileProxy(files[i]);
                }
                return ret;
            }
            return null;
        }
        return this.proxy.list(this);
    }

    public File toFile() {
        if (this.proxy == null) {
            return this.isFlat ? new FlatFolder(this.path) : new File(this.path);
        }
        return null;
    }

    public FileObject toFileObject() {
        if (this.proxy == null) {
            return FileUtil.toFileObject((File)new File(FileUtil.normalizePath((String)this.path)));
        }
        return this.proxy.toFileObject(this);
    }

    public VCSFileProxy normalizeFile() {
        if (this.proxy == null) {
            return new VCSFileProxy(FileUtil.normalizePath((String)this.path), null);
        }
        return this.proxy.normalize(this);
    }

    public String toString() {
        return this.path;
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (this.path != null ? this.path.hashCode() : 0);
        hash = 61 * hash + (this.proxy != null ? this.proxy.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCSFileProxy other = (VCSFileProxy)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.proxy == other.proxy || this.proxy != null && this.proxy.equals(other.proxy);
    }

    void setFlat(boolean flat) {
        this.isFlat = flat;
    }

    boolean isFlat() {
        return this.isFlat;
    }

    private static VCSFileProxyOperations getFileProxyOperations(FileSystem fs) {
        return (VCSFileProxyOperations)VCSFileProxy.getAttribute(fs, "FileProxyOperations");
    }

    private static Object getAttribute(FileSystem fileSystem, String attrName) {
        return fileSystem.getRoot().getAttribute(attrName);
    }

    ProcessBuilder createProcessBuilder() {
        if (this.proxy == null) {
            return ProcessBuilder.getLocal();
        }
        return this.proxy.createProcessBuilder(this);
    }

    VCSFileProxyOperations getFileProxyOperations() {
        return this.proxy;
    }

    static {
        APIAccessor.IMPL = new APIAccessorImpl();
    }
}

