/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.versioning.core.DelegatingVCS;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class VcsVisibilityQueryImplementation
implements VisibilityQueryImplementation2 {
    private final InvisibleFiles cache = new InvisibleFiles(25);
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static VcsVisibilityQueryImplementation instance;
    private static RequestProcessor rp;
    private RequestProcessor.Task refreshTask = rp.create((Runnable)new RefreshTask());
    private RequestProcessor.Task vsChangedTask = rp.create((Runnable)new VisibilityChangedTask());
    private final HashMap<VCSFileProxy, Boolean> refreshedFiles = new HashMap(20);
    private static final int MAX_CACHE_SIZE = 500;
    private static final Pattern hgmetadataPattern;
    private static final Pattern cvsmetadataPattern;
    private static final Pattern gitmetadatapattern;

    public VcsVisibilityQueryImplementation() {
        instance = this;
    }

    public static VcsVisibilityQueryImplementation getInstance() {
        return instance;
    }

    public static void visibilityChanged() {
        if (instance != null) {
            instance.fireVisibilityChanged();
        }
    }

    public boolean isVisible(File file) {
        return this.isVisible(VCSFileProxy.createFileProxy(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(VCSFileProxy file) {
        boolean refresh;
        boolean visible;
        VCSSystemProvider.VersioningSystem[] systems;
        for (VCSSystemProvider.VersioningSystem versioningSystem : systems = VersioningManager.getInstance().getVersioningSystems()) {
            if (!(versioningSystem instanceof DelegatingVCS) || !((DelegatingVCS)versioningSystem).isMetadataFile(file)) continue;
            return false;
        }
        if (this.isHiddenMetadata(file)) {
            return false;
        }
        InvisibleFiles len$ = this.cache;
        synchronized (len$) {
            this.cache.clearOldValues();
            visible = !this.cache.keySet().contains(file);
        }
        HashMap<VCSFileProxy, Boolean> hashMap = this.refreshedFiles;
        synchronized (hashMap) {
            refresh = this.refreshedFiles.isEmpty();
            this.refreshedFiles.put(file, visible);
        }
        if (refresh) {
            this.refreshTask.schedule(100);
        }
        return visible;
    }

    public boolean isVisible(FileObject fileObject) {
        VCSFileProxy file = VCSFileProxy.createFileProxy(fileObject);
        if (file == null) {
            return true;
        }
        return this.isVisible(file);
    }

    public synchronized void addChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.add(l);
        this.listeners = newList;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.remove(l);
        this.listeners = newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireVisibilityChanged() {
        ChangeListener[] ls;
        VcsVisibilityQueryImplementation vcsVisibilityQueryImplementation = this;
        synchronized (vcsVisibilityQueryImplementation) {
            ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : ls) {
            l.stateChanged(event);
        }
    }

    private boolean isHiddenMetadata(VCSFileProxy file) {
        return hgmetadataPattern.matcher(file.getPath()).matches() || cvsmetadataPattern.matcher(file.getPath()).matches() || gitmetadatapattern.matcher(file.getPath()).matches();
    }

    static {
        rp = new RequestProcessor(VcsVisibilityQueryImplementation.class.getName(), 1, false, false);
        hgmetadataPattern = Pattern.compile(".*\\" + File.separatorChar + "(\\.)hg(\\" + File.separatorChar + ".*|$)");
        cvsmetadataPattern = Pattern.compile(".*\\" + File.separatorChar + "CVS(\\" + File.separatorChar + ".*|$)");
        gitmetadatapattern = Pattern.compile(".*\\" + File.separatorChar + "(\\.)git(\\" + File.separatorChar + ".*|$)");
    }

    private static class InvisibleFiles
    extends LinkedHashMap<VCSFileProxy, Long> {
        public InvisibleFiles(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<VCSFileProxy, Long> eldest) {
            return this.size() >= 500;
        }

        public void clearOldValues() {
            if (this.size() > 125) {
                Iterator it = this.entrySet().iterator();
                long threshold = System.currentTimeMillis() - 1800000L;
                while (it.hasNext() && (Long)it.next().getValue() < threshold) {
                    it.remove();
                }
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VCSFileProxy file = null;
            boolean originalValue = false;
            HashMap hashMap = VcsVisibilityQueryImplementation.this.refreshedFiles;
            synchronized (hashMap) {
                Iterator it = VcsVisibilityQueryImplementation.this.refreshedFiles.entrySet().iterator();
                if (it.hasNext()) {
                    Map.Entry e = it.next();
                    file = (VCSFileProxy)e.getKey();
                    originalValue = (Boolean)e.getValue();
                    it.remove();
                }
            }
            if (file == null) {
                return;
            }
            boolean visible = true;
            VCSSystemProvider.VersioningSystem system = VersioningManager.getInstance().getOwner(file, !file.isDirectory());
            if (system != null) {
                VCSVisibilityQuery vqi = system.getVisibilityQuery();
                visible = vqi == null ? true : vqi.isVisible(file);
            }
            InvisibleFiles invisibleFiles = VcsVisibilityQueryImplementation.this.cache;
            synchronized (invisibleFiles) {
                VcsVisibilityQueryImplementation.this.cache.remove(file);
                if (!visible) {
                    VcsVisibilityQueryImplementation.this.cache.put(file, System.currentTimeMillis());
                }
            }
            if (originalValue != visible) {
                VcsVisibilityQueryImplementation.this.vsChangedTask.schedule(1000);
            }
            VcsVisibilityQueryImplementation.this.refreshTask.schedule(0);
        }
    }

    private class VisibilityChangedTask
    implements Runnable {
        private VisibilityChangedTask() {
        }

        @Override
        public void run() {
            VcsVisibilityQueryImplementation.this.fireVisibilityChanged();
        }
    }
}

