/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.spi.queries.CollocationQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class VcsCollocationQueryImplementation
implements CollocationQueryImplementation2 {
    public boolean areCollocated(URI file1, URI file2) {
        VCSFileProxy proxy1 = VcsCollocationQueryImplementation.toFileProxy(file1);
        VCSFileProxy proxy2 = VcsCollocationQueryImplementation.toFileProxy(file2);
        if (proxy1 == null || proxy2 == null) {
            return false;
        }
        VCSSystemProvider.VersioningSystem vsa = VersioningManager.getInstance().getOwner(proxy1);
        VCSSystemProvider.VersioningSystem vsb = VersioningManager.getInstance().getOwner(proxy2);
        if (vsa == null || vsa != vsb) {
            return false;
        }
        CollocationQueryImplementation2 cqi = vsa.getCollocationQueryImplementation();
        return cqi != null && cqi.areCollocated(file1, file2);
    }

    public URI findRoot(URI file) {
        VCSFileProxy proxy = VcsCollocationQueryImplementation.toFileProxy(file);
        if (proxy != null) {
            VCSSystemProvider.VersioningSystem system = VersioningManager.getInstance().getOwner(proxy);
            CollocationQueryImplementation2 cqi = system != null ? system.getCollocationQueryImplementation() : null;
            return cqi != null ? cqi.findRoot(file) : null;
        }
        return null;
    }

    private static VCSFileProxy toFileProxy(URI uri) {
        FileObject fo = VcsCollocationQueryImplementation.getFileObject(uri);
        return fo != null ? VCSFileProxy.createFileProxy(fo) : null;
    }

    private static FileObject getFileObject(URI uri) {
        FileObject fo = null;
        try {
            fo = URLMapper.findFileObject((URL)uri.toURL());
        }
        catch (MalformedURLException ex) {
            VersioningManager.LOG.log(Level.WARNING, uri != null ? uri.toString() : null, ex);
        }
        if (fo == null) {
            String path = uri.getPath();
            try {
                URI parent = path.endsWith("/") ? uri.resolve("..") : new URI(uri + "/").resolve("..");
                path = parent.getPath();
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException ex) {
                VersioningManager.LOG.log(Level.WARNING, path, ex);
                return null;
            }
            fo = VcsCollocationQueryImplementation.getFileObject(uri);
        }
        return fo;
    }
}

