/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.enhydra.jdbc.standard.StandardConnectionHandle;
import org.enhydra.jdbc.standard.StandardXACallableStatement;
import org.enhydra.jdbc.standard.StandardXAConnection;
import org.enhydra.jdbc.standard.StandardXAPreparedStatement;
import org.enhydra.jdbc.standard.StandardXAStatement;

public class StandardXAConnectionHandle
extends StandardConnectionHandle {
    boolean resetTxonResume = false;
    boolean globalTransaction;
    public TransactionManager transactionManager;
    public Transaction tx;
    public StandardXAConnection xacon;
    public boolean thisAutoCommit = true;

    public StandardXAConnectionHandle(StandardXAConnection pooledCon, Hashtable preparedStatementCache, int preparedStmtCacheSize, TransactionManager tm) {
        super(pooledCon, preparedStatementCache, preparedStmtCacheSize);
        this.xacon = pooledCon;
        this.transactionManager = tm;
        this.log = pooledCon.dataSource.log;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.transactionManager = tm;
    }

    public synchronized void close() throws SQLException {
        Transaction ttx = this.tx;
        super.close();
        this.log.debug("StandardXAConnectionHandle:close");
        this.log.debug("StandardXAConnectionHandle:close globalTransaction='" + this.globalTransaction + "' con.getAutoCommit='" + this.con.getAutoCommit() + "' ttx='" + ttx + "'");
        if (!this.con.getAutoCommit() && ttx == null) {
            this.log.debug("StandardXAConnectionHandle:close rollback the connection");
            this.con.rollback();
            this.con.setAutoCommit(this.thisAutoCommit);
        } else {
            this.log.debug("StandardXAConnectionHandle:close do nothing else");
        }
        this.isReallyUsed = false;
        this.log.debug("StandardXAConnectionHandle:close AFTER globalTransaction='" + this.globalTransaction + "' con.getAutoCommit='" + this.con.getAutoCommit() + "' ttx='" + ttx + "'");
    }

    void setGlobalTransaction(boolean setting) throws SQLException {
        this.log.debug("StandardXAConnectionHandle:setGlobalTransaction gTransaction='" + setting + "'");
        this.globalTransaction = setting;
        this.con = this.pooledCon.getPhysicalConnection();
        if (this.con == null) {
            this.log.warn("StandardXAConnectionHandle:setGlobalTransaction con is null before setupPreparedStatementCache");
        } else {
            this.log.debug("StandardXAConnectionHandle:setGlobalTransaction con is *NOT* null before setupPreparedStatementCache");
        }
        if (!this.isClosed()) {
            super.setAutoCommit(!setting);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.globalTransaction) {
            throw new SQLException("StandardXAConnectionHandle:setAutoCommit This connection is part of a global transaction");
        }
        super.setAutoCommit(autoCommit);
    }

    public void commit() throws SQLException {
        if (this.globalTransaction) {
            throw new SQLException("StandardXAConnectionHandle:commit:This connection is part of a global transaction");
        }
        super.commit();
    }

    public void rollback() throws SQLException {
        if (this.globalTransaction) {
            throw new SQLException("StandardXAConnectionHandle:rollback:This connection is part of a global transaction");
        }
        super.rollback();
    }

    synchronized PreparedStatement checkPreparedCache(String sql, int type, int concurrency, int holdability, Object lookupKey) throws SQLException {
        PreparedStatement ret = null;
        if (this.preparedStatementCache != null) {
            Object obj = this.preparedStatementCache.get(lookupKey);
            if (obj != null) {
                this.log.debug("StandardXAConnectionHandle:checkPreparedCache object is found");
                ret = (PreparedStatement)obj;
                try {
                    ret.clearParameters();
                }
                catch (SQLException e) {
                    ret = this.createPreparedStatement(sql, type, concurrency, holdability);
                }
                this.preparedStatementCache.remove(lookupKey);
                this.inUse.put(lookupKey, ret);
            } else {
                this.log.debug("StandardXAConnectionHandle:checkPreparedCache object is *NOT* found");
                ret = this.createPreparedStatement(sql, type, concurrency, holdability);
                this.inUse.put(lookupKey, ret);
            }
        } else {
            this.log.debug("StandardXAConnectionHandle:checkPreparedCache object the cache is out");
            ret = this.createPreparedStatement(sql, type, concurrency, holdability);
        }
        this.log.debug("StandardXAConnectionHandle:checkPreparedCache pstmt='" + ret.toString() + "'");
        return ret;
    }

    synchronized PreparedStatement checkPreparedCache(String sql, int autogeneratedkeys, Object lookupKey) throws SQLException {
        PreparedStatement ret = null;
        if (this.preparedStatementCache != null) {
            Object obj = this.preparedStatementCache.get(lookupKey);
            if (obj != null) {
                this.log.debug("StandardXAConnectionHandle:checkPreparedCache object is found");
                ret = (PreparedStatement)obj;
                try {
                    ret.clearParameters();
                }
                catch (SQLException e) {
                    ret = this.createPreparedStatement(sql, autogeneratedkeys);
                }
                this.preparedStatementCache.remove(lookupKey);
                this.inUse.put(lookupKey, ret);
            } else {
                this.log.debug("StandardXAConnectionHandle:checkPreparedCache object is *NOT* found");
                ret = this.createPreparedStatement(sql, autogeneratedkeys);
                this.inUse.put(lookupKey, ret);
            }
        } else {
            this.log.debug("StandardXAConnectionHandle:checkPreparedCache object the cache is out");
            ret = this.createPreparedStatement(sql, autogeneratedkeys);
        }
        this.log.debug("StandardXAConnectionHandle:checkPreparedCache pstmt='" + ret.toString() + "'");
        return ret;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 0, 0, 0);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 0);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.tx == null) {
            this.log.debug("StandardXAConnectionHandle:prepareStatement tx==null");
            try {
                try {
                    Transaction ntx = this.getTransaction();
                    if (ntx != null) {
                        this.log.debug("StandardXAConnectionHandle:prepareStatement (found a transaction)");
                        this.tx = ntx;
                        this.xacon.thisAutoCommit = this.getAutoCommit();
                        if (this.xacon.thisAutoCommit) {
                            this.setAutoCommit(false);
                        }
                        try {
                            this.tx.enlistResource(this.xacon.getXAResource());
                        }
                        catch (RollbackException n) {
                            this.log.debug("StandardXAConnectionHandle:prepareStatemnet enlistResource exception : " + n.toString());
                            throw new SQLException("StandardXAConnectionHandle:prepareStatemnet enlistResource exception: " + n.toString());
                        }
                    }
                    this.log.debug("StandardXAConnectionHandle:prepareStatement (no transaction found)");
                }
                catch (SystemException n) {
                    n.printStackTrace();
                    throw new SQLException("StandardXAConnectionHandle:prepareStatement getTransaction exception: " + n.toString());
                }
            }
            catch (NullPointerException n) {
                n.printStackTrace();
                throw new SQLException("StandardXAConnectionHandle:prepareStatement should not be used outside an EJBServer");
            }
        } else {
            this.log.debug("StandardXAConnectionHandle:prepareStatement tx!=null");
        }
        this.isReallyUsed = true;
        return new StandardXAPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.tx == null) {
            this.log.debug("StandardXAConnectionHandle:prepareStatement tx==null");
            try {
                try {
                    Transaction ntx = this.getTransaction();
                    if (ntx != null) {
                        this.log.debug("StandardXAConnectionHandle:prepareStatement (found a transaction)");
                        this.tx = ntx;
                        this.xacon.thisAutoCommit = this.getAutoCommit();
                        if (this.getAutoCommit()) {
                            this.setAutoCommit(false);
                        }
                        try {
                            this.tx.enlistResource(this.xacon.getXAResource());
                        }
                        catch (RollbackException n) {
                            this.log.debug("StandardXAConnectionHandle:prepareStatemnet enlistResource exception : " + n.toString());
                        }
                    }
                    this.log.debug("StandardXAConnectionHandle:prepareStatement (no transaction found)");
                }
                catch (SystemException n) {
                    n.printStackTrace();
                    throw new SQLException("StandardXAConnectionHandle:prepareStatement getTransaction exception: " + n.toString());
                }
            }
            catch (NullPointerException n) {
                n.printStackTrace();
                throw new SQLException("StandardXAConnectionHandle:prepareStatement should not be used outside an EJBServer");
            }
        } else {
            this.log.debug("StandardXAConnectionHandle:prepareStatement tx!=null");
        }
        this.isReallyUsed = true;
        return new StandardXAPreparedStatement(this, sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.isReallyUsed = true;
        return new StandardXACallableStatement(this, sql, resultSetType, resultSetConcurrency, 0);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.isReallyUsed = true;
        return new StandardXACallableStatement(this, sql, 0, 0, 0);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.isReallyUsed = true;
        return new StandardXACallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(0, 0, 0);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 0);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.tx == null) {
            this.log.debug("StandardXAConnectionHandle:createStatement tx==null");
            try {
                try {
                    Transaction ntx = this.getTransaction();
                    if (ntx != null) {
                        this.log.debug("StandardXAConnectionHandle:createStatement (found a transaction)");
                        this.tx = ntx;
                        this.xacon.thisAutoCommit = this.getAutoCommit();
                        if (this.getAutoCommit()) {
                            this.setAutoCommit(false);
                        }
                        try {
                            this.tx.enlistResource(this.xacon.getXAResource());
                        }
                        catch (RollbackException n) {
                            this.log.debug("StandardXAConnectionHandle:createStatement enlistResource exception: " + n.toString());
                        }
                    } else {
                        this.log.debug("StandardXAConnectionHandle:createStatement (no transaction found)");
                    }
                }
                catch (SystemException n) {
                    throw new SQLException("StandardXAConnectionHandle:createStatement getTransaction exception: " + n.toString());
                }
            }
            catch (NullPointerException n) {
                throw new SQLException("StandardXAConnectionHandle:createStatement should not be used outside an EJBServer: " + n.toString());
            }
        }
        this.isReallyUsed = true;
        return new StandardXAStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    private Transaction getTransaction() throws SystemException {
        Transaction ntx = null;
        if (this.transactionManager != null) {
            ntx = this.transactionManager.getTransaction();
        } else {
            this.log.debug("StandardXAConnectionHandle:getTransaction (null transaction manager)");
        }
        return ntx;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardXAConnectionHandle:\n");
        sb.append("     global transaction =<" + this.globalTransaction + ">\n");
        sb.append("     is really used =<" + this.isReallyUsed + ">\n");
        sb.append("     this autoCommit =<" + this.thisAutoCommit + ">\n");
        sb.append("     in use size =<" + this.inUse.size() + ">\n");
        sb.append("     master prepared stmt cache size =<" + this.masterPrepStmtCache.size() + ">\n");
        sb.append("     transaction =<" + this.tx + ">\n");
        sb.append("     connection =<" + this.con.toString() + ">\n");
        return sb.toString();
    }
}

