/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.dd.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.DDException;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.j2ee.sun.dd.api.app.SunApplication;
import org.netbeans.modules.j2ee.sun.dd.api.client.SunApplicationClient;
import org.netbeans.modules.j2ee.sun.dd.api.cmp.SunCmpMappings;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.SunEjbJar;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.netbeans.modules.j2ee.sun.dd.impl.RootInterfaceImpl;
import org.netbeans.modules.j2ee.sun.dd.impl.app.SunApplicationProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.app.model_6_0_1.GlassFishApplication;
import org.netbeans.modules.j2ee.sun.dd.impl.client.SunApplicationClientProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.client.model_6_0_1.GlassFishApplicationClient;
import org.netbeans.modules.j2ee.sun.dd.impl.cmp.SunCmpMappingsProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.common.DDProviderDataObject;
import org.netbeans.modules.j2ee.sun.dd.impl.common.SunBaseBean;
import org.netbeans.modules.j2ee.sun.dd.impl.ejb.SunEjbJarProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_1_1.GlassFishEjbJar;
import org.netbeans.modules.j2ee.sun.dd.impl.serverresources.ResourcesProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.web.SunWebAppProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.web.model_3_0_1.GlassFishWebApp;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final DDProvider ddProvider = new DDProvider();
    private final Map<Object, RootInterface> ddMap = new WeakHashMap<Object, RootInterface>();
    private Map<FileObject, DDProviderDataObject> dObjMap = new WeakHashMap<FileObject, DDProviderDataObject>();
    private static final Map<Class, Map<String, VersionInfo>> apiToVersionMap = new HashMap<Class, Map<String, VersionInfo>>(11);
    private static final Map<String, VersionInfo> sunWebAppVersionMap = new HashMap<String, VersionInfo>(11);
    private static final Map<String, VersionInfo> sunEjbJarVersionMap = new HashMap<String, VersionInfo>(11);
    private static final Map<String, VersionInfo> sunApplicationVersionMap = new HashMap<String, VersionInfo>(11);
    private static final Map<String, VersionInfo> sunAppClientVersionMap = new HashMap<String, VersionInfo>(11);
    private static final Map<String, VersionInfo> sunResourcesVersionMap = new HashMap<String, VersionInfo>(11);
    private static final Map<String, DocTypeInfo> publicIdToInfoMap;

    private DDProvider() {
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    public SunEjbJar getEjbDDRoot(InputSource is) throws IOException, SAXException {
        DDParse parse = new DDParse(is);
        SunEjbJar ejbRoot = DDProvider.createEjbJar(parse);
        SunEjbJarProxy proxy = new SunEjbJarProxy(ejbRoot, ejbRoot.getVersion().toString());
        DDProvider.setErrorStatus(proxy, parse);
        return proxy;
    }

    public SunWebApp getWebDDRoot(InputSource is) throws IOException, SAXException, DDException {
        return this.processWebAppParseTree(new DDParse(is));
    }

    public SunWebApp getWebDDRoot(InputStream is) throws IOException, SAXException, DDException {
        return this.processWebAppParseTree(new DDParse(is));
    }

    public SunWebApp getWebDDRoot(Document doc) throws DDException {
        return this.processWebAppParseTree(new DDParse(doc, null));
    }

    private SunWebApp processWebAppParseTree(DDParse parse) throws DDException {
        SunWebApp webRoot = DDProvider.createWebApp(parse);
        SunWebAppProxy proxy = new SunWebAppProxy(webRoot, webRoot.getVersion().toString());
        DDProvider.setErrorStatus(proxy, parse);
        return proxy;
    }

    public SunApplication getAppDDRoot(InputSource is) throws IOException, SAXException {
        DDParse parse = new DDParse(is);
        SunApplication appRoot = DDProvider.createApplication(parse);
        SunApplicationProxy proxy = new SunApplicationProxy(appRoot, appRoot.getVersion().toString());
        DDProvider.setErrorStatus(proxy, parse);
        return proxy;
    }

    public SunApplicationClient getAppClientDDRoot(InputSource is) throws IOException, SAXException {
        DDParse parse = new DDParse(is);
        SunApplicationClient appClientRoot = DDProvider.createApplicationClient(parse);
        SunApplicationClientProxy proxy = new SunApplicationClientProxy(appClientRoot, appClientRoot.getVersion().toString());
        DDProvider.setErrorStatus(proxy, parse);
        return proxy;
    }

    private static void setErrorStatus(RootInterfaceImpl rootProxy, DDParse parse) {
        SAXParseException error = parse.getWarning();
        rootProxy.setError(error);
        if (error != null) {
            rootProxy.setStatus(1);
        } else {
            rootProxy.setStatus(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootInterface getDDRoot(FileObject fo) throws IOException {
        if (fo == null) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject instanceof DDProviderDataObject) {
                return this.getDDRoot0((DDProviderDataObject)dataObject, fo);
            }
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
        RootInterface rootProxy = null;
        Map<Object, RootInterface> map = this.ddMap;
        synchronized (map) {
            rootProxy = this.ddMap.get(fo);
            if (rootProxy != null) {
                return rootProxy;
            }
        }
        fo.addFileChangeListener((FileChangeListener)new SunDDFileChangeListener());
        InputStream is = null;
        try {
            is = fo.getInputStream();
            DDParse parse = new DDParse(is);
            RootInterface tmpRootProxy = parse.createProxy();
            Map<Object, RootInterface> map2 = this.ddMap;
            synchronized (map2) {
                rootProxy = this.ddMap.get(fo);
                if (rootProxy == null) {
                    rootProxy = tmpRootProxy;
                    this.ddMap.put(fo, rootProxy);
                }
            }
        }
        catch (Schema2BeansException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (Schema2BeansRuntimeException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (SAXException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        return rootProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootInterface getDDRoot0(DDProviderDataObject ddProviderDataObject, FileObject refFO) throws IOException {
        RootInterface rootProxy = null;
        Map<Object, RootInterface> map = this.ddMap;
        synchronized (map) {
            rootProxy = this.ddMap.get(ddProviderDataObject);
            if (rootProxy == null) {
                try {
                    rootProxy = this.getDDRoot(ddProviderDataObject.createReader());
                    if (rootProxy != null) {
                        this.ddMap.put(ddProviderDataObject, rootProxy);
                    }
                }
                catch (Schema2BeansException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                catch (Schema2BeansRuntimeException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                catch (SAXException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            if (rootProxy != null) {
                this.dObjMap.put(refFO, ddProviderDataObject);
            }
        }
        return rootProxy;
    }

    public RootInterface getDDRoot(Reader reader) throws IOException, SAXException, Schema2BeansException {
        return this.getDDRoot(new InputSource(reader));
    }

    public RootInterface getDDRoot(InputSource inputSource) throws IOException, SAXException, Schema2BeansException {
        return this.getDDRoot(inputSource, null);
    }

    private RootInterface getDDRoot(Reader reader, String defaultPublicId) throws IOException, SAXException, Schema2BeansException {
        return this.getDDRoot(new InputSource(reader), defaultPublicId);
    }

    private RootInterface getDDRoot(InputSource inputSource, String defaultPublicId) throws IOException, SAXException, Schema2BeansException {
        DDParse parse = new DDParse(inputSource, defaultPublicId);
        return parse.createProxy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RootInterface newGraph(Class rootType, String version) {
        RootInterface result = null;
        SunBaseBean graphRoot = null;
        Object graphRootClass = null;
        Map<String, VersionInfo> versionMap = apiToVersionMap.get(rootType);
        if (versionMap == null) throw new IllegalStateException("No version map for " + rootType.getName());
        VersionInfo vInfo = versionMap.get(version);
        if (vInfo == null) throw new IllegalStateException("No version information for " + version + " of type " + rootType.getName());
        try {
            graphRoot = (SunBaseBean)vInfo.getImplClass().newInstance();
            graphRoot.graphManager().setDoctype(vInfo.getPublicId(), vInfo.getSystemId());
            Class proxyClass = vInfo.getProxyClass();
            Constructor proxyConstructor = proxyClass.getConstructor(rootType, String.class);
            return (RootInterface)proxyConstructor.newInstance(graphRoot, version);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static SunEjbJar createEjbJar(DDParse parse) {
        Object jar = null;
        String version = parse.getVersion();
        if ("3.11".equals(version)) {
            return new GlassFishEjbJar(parse.getDocument(), 2);
        }
        if ("3.10".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_1_0.SunEjbJar(parse.getDocument(), 2);
        }
        if ("3.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar(parse.getDocument(), 2);
        }
        if ("2.11".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_1.SunEjbJar(parse.getDocument(), 2);
        }
        if ("2.10".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_0.SunEjbJar(parse.getDocument(), 2);
        }
        if ("2.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_0_0.SunEjbJar(parse.getDocument(), 2);
        }
        return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar(parse.getDocument(), 2);
    }

    private static SunWebApp createWebApp(DDParse parse) throws DDException {
        Object webRoot = null;
        String version = parse.getVersion();
        if ("3.01".equals(version)) {
            return new GlassFishWebApp(parse.getDocument(), 2);
        }
        if ("3.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_3_0_0.SunWebApp(parse.getDocument(), 2);
        }
        if ("2.50".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_5_0.SunWebApp(parse.getDocument(), 2);
        }
        if ("2.41".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_1.SunWebApp(parse.getDocument(), 2);
        }
        if ("2.40".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_0.SunWebApp(parse.getDocument(), 2);
        }
        if ("2.30".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_3_0.SunWebApp(parse.getDocument(), 2);
        }
        throw new DDException(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/dd/api/Bundle").getString("MSG_UnknownWebXml"), version));
    }

    private static SunApplication createApplication(DDParse parse) {
        SunApplication app = null;
        String version = parse.getVersion();
        if ("6.01".equals(version)) {
            return new GlassFishApplication(parse.getDocument(), 2);
        }
        if ("6.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_6_0_0.SunApplication(parse.getDocument(), 2);
        }
        if ("5.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_5_0_0.SunApplication(parse.getDocument(), 2);
        }
        if ("1.40".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_4_0.SunApplication(parse.getDocument(), 2);
        }
        if ("1.30".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_3_0.SunApplication(parse.getDocument(), 2);
        }
        return app;
    }

    private static SunApplicationClient createApplicationClient(DDParse parse) {
        SunApplicationClient appClient = null;
        String version = parse.getVersion();
        if ("6.01".equals(version)) {
            return new GlassFishApplicationClient(parse.getDocument(), 2);
        }
        if ("6.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_6_0_0.SunApplicationClient(parse.getDocument(), 2);
        }
        if ("5.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_5_0_0.SunApplicationClient(parse.getDocument(), 2);
        }
        if ("1.41".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_1.SunApplicationClient(parse.getDocument(), 2);
        }
        if ("1.40".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_0.SunApplicationClient(parse.getDocument(), 2);
        }
        if ("1.30".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_3_0.SunApplicationClient(parse.getDocument(), 2);
        }
        return appClient;
    }

    public Resources getResourcesGraph(String version) {
        Resources resourcesRoot = (Resources)this.newGraph(Resources.class, version);
        ResourcesProxy proxy = new ResourcesProxy(resourcesRoot);
        return proxy;
    }

    public Resources getResourcesGraph(InputStream in) throws IOException, SAXException {
        return this.getResourcesRoot(new InputSource(in));
    }

    public Resources getResourcesRoot(InputSource is) throws IOException, SAXException {
        ResourcesProxy proxy = null;
        DDParse parse = new DDParse(is);
        Resources appRoot = DDProvider.createResources(parse);
        proxy = appRoot == null ? new ResourcesProxy(appRoot) : new ResourcesProxy(appRoot, appRoot.getVersion().toString());
        DDProvider.setErrorStatus(proxy, parse);
        return proxy;
    }

    private static Resources createResources(DDParse parse) {
        Resources app = null;
        String version = parse.getVersion();
        if ("1.50".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model_1_5.Resources(parse.getDocument(), 2);
        }
        if ("1.30".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources(parse.getDocument(), 2);
        }
        return app;
    }

    private String getPublicIdFromImpl(RootInterfaceImpl rootProxyImpl) {
        DocumentType dt;
        Document d;
        String result = null;
        GraphManager gm = rootProxyImpl.graphManager();
        if (gm != null && (d = gm.getXmlDocument()) != null && (dt = d.getDoctype()) != null) {
            result = dt.getPublicId();
        }
        return result;
    }

    public void merge(RootInterface rootProxy, Reader reader) {
        RootInterfaceImpl rootProxyImpl = (RootInterfaceImpl)((Object)rootProxy);
        try {
            String oldPublicId = this.getPublicIdFromImpl(rootProxyImpl);
            RootInterface newRootProxy = this.getDDRoot(reader, oldPublicId);
            RootInterfaceImpl newRootProxyImpl = (RootInterfaceImpl)((Object)newRootProxy);
            if (newRootProxy == null) {
                rootProxyImpl.setStatus(2);
                rootProxyImpl.setError(null);
            } else if (newRootProxy.getStatus() == 2) {
                rootProxyImpl.setStatus(2);
                rootProxyImpl.setError(newRootProxyImpl.getError());
            } else {
                rootProxy.merge(newRootProxy, 3);
                rootProxyImpl.setStatus(newRootProxy.getStatus());
                rootProxyImpl.setError(newRootProxyImpl.getError());
            }
        }
        catch (DOMException ex) {
            rootProxyImpl.setStatus(2);
            rootProxyImpl.setError(new SAXParseException(null, null, ex));
        }
        catch (SAXParseException ex) {
            rootProxyImpl.setStatus(2);
            rootProxyImpl.setError(ex);
        }
        catch (SAXException ex) {
            rootProxyImpl.setStatus(2);
            if (ex.getException() instanceof SAXParseException) {
                rootProxyImpl.setError((SAXParseException)ex.getException());
            } else {
                rootProxyImpl.setError(new SAXParseException(null, null, ex));
            }
        }
        catch (IOException ex) {
            rootProxyImpl.setStatus(2);
        }
        catch (Schema2BeansException ex) {
            rootProxyImpl.setStatus(2);
            rootProxyImpl.setError(new SAXParseException(null, null, (Exception)((Object)ex)));
        }
    }

    public static ASDDVersion getASDDVersion(RootInterface rootDD) {
        return DDProvider.getASDDVersion(rootDD, null);
    }

    public static ASDDVersion getASDDVersion(RootInterface rootDD, ASDDVersion defaultVersion) {
        ASDDVersion version = null;
        if (rootDD instanceof RootInterfaceImpl) {
            RootInterfaceImpl rootDDImpl = (RootInterfaceImpl)((Object)rootDD);
            version = rootDDImpl.getASDDVersion();
        }
        return version != null ? version : defaultVersion;
    }

    static {
        sunWebAppVersionMap.put("2.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_3_0.SunWebApp.class, SunWebAppProxy.class, "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Servlet 2.3//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-web-app_2_3-0.dtd"));
        sunWebAppVersionMap.put("2.40", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_0.SunWebApp.class, SunWebAppProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.0 Servlet 2.4//EN", "http://www.sun.com/software/appserver/dtds/sun-web-app_2_4-0.dtd"));
        sunWebAppVersionMap.put("2.41", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_1.SunWebApp.class, SunWebAppProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.1 Servlet 2.4//EN", "http://www.sun.com/software/appserver/dtds/sun-web-app_2_4-1.dtd"));
        sunWebAppVersionMap.put("2.50", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_5_0.SunWebApp.class, SunWebAppProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Servlet 2.5//EN", "http://www.sun.com/software/appserver/dtds/sun-web-app_2_5-0.dtd"));
        sunWebAppVersionMap.put("3.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_3_0_0.SunWebApp.class, SunWebAppProxy.class, "-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Servlet 3.0//EN", "http://www.sun.com/software/appserver/dtds/sun-web-app_3_0-0.dtd"));
        sunWebAppVersionMap.put("3.01", new VersionInfo(GlassFishWebApp.class, SunWebAppProxy.class, "-//GlassFish.org//DTD GlassFish Application Server 3.1 Servlet 3.0//EN", "http://glassfish.org/dtds/glassfish-web-app_3_0-1.dtd"));
        sunEjbJarVersionMap.put("2.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_0_0.SunEjbJar.class, SunEjbJarProxy.class, "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 EJB 2.0//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-ejb-jar_2_0-0.dtd"));
        sunEjbJarVersionMap.put("2.10", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_0.SunEjbJar.class, SunEjbJarProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.0 EJB 2.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-0.dtd"));
        sunEjbJarVersionMap.put("2.11", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_1.SunEjbJar.class, SunEjbJarProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.1 EJB 2.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-1.dtd"));
        sunEjbJarVersionMap.put("3.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar.class, SunEjbJarProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 9.0 EJB 3.0//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_0-0.dtd"));
        sunEjbJarVersionMap.put("3.10", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_1_0.SunEjbJar.class, SunEjbJarProxy.class, "-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 EJB 3.1//EN", "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_1-0.dtd"));
        sunEjbJarVersionMap.put("3.11", new VersionInfo(GlassFishEjbJar.class, SunEjbJarProxy.class, "-//GlassFish.org//DTD GlassFish Application Server 3.1 EJB 3.1//EN", "http://glassfish.org/dtds/glassfish-ejb-jar_3_1-1.dtd"));
        sunApplicationVersionMap.put("1.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_3_0.SunApplication.class, SunApplicationProxy.class, "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 J2EE Application 1.3//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-application_1_3-0.dtd"));
        sunApplicationVersionMap.put("1.40", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_4_0.SunApplication.class, SunApplicationProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.0 J2EE Application 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application_1_4-0.dtd"));
        sunApplicationVersionMap.put("5.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_5_0_0.SunApplication.class, SunApplicationProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Java EE Application 5.0//EN", "http://www.sun.com/software/appserver/dtds/sun-application_5_0-0.dtd"));
        sunApplicationVersionMap.put("6.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_6_0_0.SunApplication.class, SunApplicationProxy.class, "-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Java EE Application 6.0//EN", "http://www.sun.com/software/appserver/dtds/sun-application_6_0-0.dtd"));
        sunApplicationVersionMap.put("6.01", new VersionInfo(GlassFishApplication.class, SunApplicationProxy.class, "-//GlassFish.org//DTD GlassFish Application Server 3.1 Java EE Application 6.0//EN", "http://glassfish.org/dtds/glassfish-application_6_0-1.dtd"));
        sunAppClientVersionMap.put("1.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_3_0.SunApplicationClient.class, SunApplicationClientProxy.class, "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Application Client 1.3//EN", "http://www.sun.com/software/sunone/appserver/dtds/sun-application-client_1_3-0.dtd"));
        sunAppClientVersionMap.put("1.40", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_0.SunApplicationClient.class, SunApplicationClientProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.0 Application Client 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application-client_1_4-0.dtd"));
        sunAppClientVersionMap.put("1.41", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_1.SunApplicationClient.class, SunApplicationClientProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 8.1 Application Client 1.4//EN", "http://www.sun.com/software/appserver/dtds/sun-application-client_1_4-1.dtd"));
        sunAppClientVersionMap.put("5.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_5_0_0.SunApplicationClient.class, SunApplicationClientProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Application Client 5.0//EN", "http://www.sun.com/software/appserver/dtds/sun-application-client_5_0-0.dtd"));
        sunAppClientVersionMap.put("6.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_6_0_0.SunApplicationClient.class, SunApplicationClientProxy.class, "-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Application Client 6.0//EN", "http://www.sun.com/software/appserver/dtds/sun-application-client_6_0-0.dtd"));
        sunAppClientVersionMap.put("6.01", new VersionInfo(GlassFishApplicationClient.class, SunApplicationClientProxy.class, "-//GlassFish.org//DTD GlassFish Application Server 3.1 Java EE Application Client 6.0//EN", "http://glassfish.org/dtds/glassfish-application-client_6_0-1.dtd"));
        sunResourcesVersionMap.put("1.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources.class, ResourcesProxy.class, "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions //EN", "http://www.sun.com/software/appserver/dtds/sun-resources_1_3.dtd"));
        sunResourcesVersionMap.put("1.50", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources.class, ResourcesProxy.class, "-//GlassFish.org//DTD GlassFish Application Server 3.1 Resource Definitions//EN", "http://glassfish.org/dtds/glassfish-resources_1_5.dtd"));
        apiToVersionMap.put(SunWebApp.class, sunWebAppVersionMap);
        apiToVersionMap.put(SunEjbJar.class, sunEjbJarVersionMap);
        apiToVersionMap.put(SunApplication.class, sunApplicationVersionMap);
        apiToVersionMap.put(SunApplicationClient.class, sunAppClientVersionMap);
        apiToVersionMap.put(Resources.class, sunResourcesVersionMap);
        publicIdToInfoMap = new HashMap<String, DocTypeInfo>(37);
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 EJB 2.1//EN", new DocTypeInfo("2.11", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_1.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_1-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 EJB 2.1//EN", new DocTypeInfo("2.10", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_0.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_1-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 EJB 3.0//EN", new DocTypeInfo("3.00", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_3_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.1.1 EJB 3.0//EN", new DocTypeInfo("3.01", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_1.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_3_0-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 EJB 2.1//EN", new DocTypeInfo("2.10", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_0.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_1-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 EJB 2.0//EN", new DocTypeInfo("2.00", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_0_0.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 EJB 3.1//EN", new DocTypeInfo("3.10", SunEjbJarProxy.class, SunEjbJar.class, org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_1_0.SunEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_3_1-0.dtd"));
        publicIdToInfoMap.put("-//GlassFish.org//DTD GlassFish Application Server 3.1 EJB 3.1//EN", new DocTypeInfo("3.11", SunEjbJarProxy.class, SunEjbJar.class, GlassFishEjbJar.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/glassfish-ejb-jar_3_1-1.dtd"));
        publicIdToInfoMap.put("-//GlassFish.org//DTD GlassFish Application Server 3.1 Servlet 3.0//EN", new DocTypeInfo("3.01", SunWebAppProxy.class, SunWebApp.class, GlassFishWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/glassfish-web-app_3_0-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Servlet 3.0//EN", new DocTypeInfo("3.00", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_3_0_0.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_3_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 Servlet 2.5//EN", new DocTypeInfo("2.50", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_5_0.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_5-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 Servlet 2.4//EN", new DocTypeInfo("2.41", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_1.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_4-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 Servlet 2.4//EN", new DocTypeInfo("2.40", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_0.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 Servlet 2.4//EN", new DocTypeInfo("2.40", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_0.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Servlet 2.3//EN", new DocTypeInfo("2.30", SunWebAppProxy.class, SunWebApp.class, org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_3_0.SunWebApp.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_3-0.dtd"));
        publicIdToInfoMap.put("-//GlassFish.org//DTD GlassFish Application Server 3.1 Java EE Application 6.0//EN", new DocTypeInfo("6.01", SunApplicationProxy.class, SunApplication.class, GlassFishApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/glassfish-application_6_0-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Java EE Application 6.0//EN", new DocTypeInfo("6.00", SunApplicationProxy.class, SunApplication.class, org.netbeans.modules.j2ee.sun.dd.impl.app.model_6_0_0.SunApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_6_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 Java EE Application 5.0//EN", new DocTypeInfo("5.00", SunApplicationProxy.class, SunApplication.class, org.netbeans.modules.j2ee.sun.dd.impl.app.model_5_0_0.SunApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_5_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 J2EE Application 1.4//EN", new DocTypeInfo("1.40", SunApplicationProxy.class, SunApplication.class, org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_4_0.SunApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_1_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 J2EE Application 1.4//EN", new DocTypeInfo("1.40", SunApplicationProxy.class, SunApplication.class, org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_4_0.SunApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_1_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 J2EE Application 1.3//EN", new DocTypeInfo("1.30", SunApplicationProxy.class, SunApplication.class, org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_3_0.SunApplication.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_1_3-0.dtd"));
        publicIdToInfoMap.put("-//GlassFish.org//DTD GlassFish Application Server 3.1 Java EE Application Client 6.0//EN", new DocTypeInfo("6.01", SunApplicationClientProxy.class, SunApplicationClient.class, GlassFishApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/glassfish-application-client_6_0-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD GlassFish Application Server 3.0 Application Client 6.0//EN", new DocTypeInfo("6.00", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_6_0_0.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_6_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 Application Client 5.0//EN", new DocTypeInfo("5.00", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_5_0_0.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_5_0-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 Application Client 1.4//EN", new DocTypeInfo("1.41", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_1.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_4-1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 Application Client 1.4//EN", new DocTypeInfo("1.40", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_0.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 Application Client 1.4//EN", new DocTypeInfo("1.40", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_0.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_4-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Application Client 1.3//EN", new DocTypeInfo("1.30", SunApplicationClientProxy.class, SunApplicationClient.class, org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_3_0.SunApplicationClient.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_3-0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.1 OR Mapping//EN", new DocTypeInfo("1.2", SunCmpMappingsProxy.class, SunCmpMappings.class, org.netbeans.modules.j2ee.sun.dd.impl.cmp.model_1_2.SunCmpMappings.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-cmp-mapping_1_2.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 8.0 OR Mapping//EN", new DocTypeInfo("1.1", SunCmpMappingsProxy.class, SunCmpMappings.class, org.netbeans.modules.j2ee.sun.dd.impl.cmp.model_1_1.SunCmpMappings.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-cmp-mapping_1_1.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 OR Mapping //EN", new DocTypeInfo("1.0", SunCmpMappingsProxy.class, SunCmpMappings.class, org.netbeans.modules.j2ee.sun.dd.impl.cmp.model_1_0.SunCmpMappings.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-cmp-mapping_1_0.dtd"));
        publicIdToInfoMap.put("-//Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions //EN", new DocTypeInfo("1.30", ResourcesProxy.class, Resources.class, org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-resources_1_3.dtd"));
        publicIdToInfoMap.put("-//GlassFish.org//DTD GlassFish Application Server 3.1 Resource Definitions//EN", new DocTypeInfo("1.50", ResourcesProxy.class, Resources.class, org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources.class, "/org/netbeans/modules/j2ee/sun/dd/impl/resources/glassfish-resources_1_5.dtd"));
    }

    private static class DDParse {
        private Document document;
        private SAXParseException saxException;
        private String version;
        private DocTypeInfo documentInfo;

        public DDParse(InputStream is) throws SAXException, IOException {
            this(new InputSource(is));
        }

        public DDParse(Reader reader) throws SAXException, IOException {
            this(new InputSource(reader));
        }

        public DDParse(InputSource is) throws SAXException, IOException {
            this(is, null);
        }

        public DDParse(InputSource is, String defaultPublicId) throws SAXException, IOException {
            try {
                SunDDErrorHandler errorHandler = new SunDDErrorHandler();
                DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = parserFactory.newDocumentBuilder();
                parser.setErrorHandler(errorHandler);
                parser.setEntityResolver(SunDDResolver.getInstance());
                Document d = parser.parse(is);
                this.initialize(d, errorHandler.getError(), defaultPublicId);
            }
            catch (NullPointerException ex) {
                throw new SAXException(ex.getMessage());
            }
            catch (ParserConfigurationException ex) {
                throw new SAXException(ex.getMessage());
            }
        }

        public DDParse(Document d, SAXParseException saxEx) {
            this.initialize(d, saxEx, null);
        }

        private void initialize(Document d, SAXParseException saxEx, String defaultPublicId) {
            this.document = d;
            this.saxException = saxEx;
            this.documentInfo = null;
            this.version = "unknown";
            DocumentType dt = this.document.getDoctype();
            if (dt != null) {
                this.documentInfo = (DocTypeInfo)publicIdToInfoMap.get(dt.getPublicId());
            } else if (defaultPublicId != null) {
                this.documentInfo = (DocTypeInfo)publicIdToInfoMap.get(defaultPublicId);
            }
            if (this.documentInfo != null) {
                this.version = this.documentInfo.getVersion();
            }
        }

        public Document getDocument() {
            return this.document;
        }

        public RootInterface createProxy() throws Schema2BeansException, Schema2BeansRuntimeException {
            RootInterface result = null;
            if (this.documentInfo != null) {
                try {
                    RootInterface implDD = this.documentInfo.createImplementation(this.document);
                    RootInterfaceImpl proxyDD = this.documentInfo.createProxy(implDD);
                    proxyDD.setError(this.saxException);
                    proxyDD.setStatus(this.saxException != null ? 1 : 0);
                    result = proxyDD.getRootInterface();
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex;
                    while (((Throwable)cause).getCause() != null) {
                        cause = ((Throwable)cause).getCause();
                    }
                    if (cause instanceof Schema2BeansException) {
                        throw (Schema2BeansException)cause;
                    }
                    if (cause instanceof Schema2BeansRuntimeException) {
                        throw (Schema2BeansRuntimeException)cause;
                    }
                    throw new RuntimeException(ex.getMessage(), ex);
                }
                catch (NoSuchMethodException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            return result;
        }

        public String getVersion() {
            return this.version;
        }

        public SAXParseException getWarning() {
            return this.saxException;
        }
    }

    private static class DocTypeInfo {
        private final String version;
        private final Class proxyClass;
        private final Class interfaceClass;
        private final Class implClass;
        private final String resourceDtd;

        public DocTypeInfo(String version, Class proxyClass, Class interfaceClass, Class implClass, String resourceDtd) {
            this.version = version;
            this.proxyClass = proxyClass;
            this.interfaceClass = interfaceClass;
            this.implClass = implClass;
            this.resourceDtd = resourceDtd;
        }

        public String getVersion() {
            return this.version;
        }

        public String getResourceDtd() {
            return this.resourceDtd;
        }

        public RootInterface createImplementation(Document doc) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
            Constructor implCtor = this.implClass.getConstructor(Node.class, Integer.TYPE);
            return (RootInterface)implCtor.newInstance(doc, 2);
        }

        public RootInterfaceImpl createProxy(RootInterface original) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
            Constructor proxyCtor = this.proxyClass.getConstructor(this.interfaceClass, String.class);
            return (RootInterfaceImpl)proxyCtor.newInstance(this.interfaceClass.cast(original), this.version);
        }
    }

    private static class SunDDErrorHandler
    implements ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private SunDDErrorHandler() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private class SunDDFileChangeListener
    extends FileChangeAdapter {
        private SunDDFileChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent evt) {
            FileObject fo = evt.getFile();
            try {
                Map map = DDProvider.this.ddMap;
                synchronized (map) {
                    RootInterface rootProxy = (RootInterface)DDProvider.this.ddMap.get(fo);
                    if (rootProxy != null) {
                        InputStream inputStream = null;
                        try {
                            inputStream = fo.getInputStream();
                            String encoding = EncodingUtil.detectEncoding((InputStream)new BufferedInputStream(inputStream));
                            if (encoding == null) {
                                encoding = "UTF8";
                            }
                            DDProvider.this.merge(rootProxy, new InputStreamReader(inputStream, encoding));
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException ex) {}
                            }
                        }
                    }
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private static class SunDDResolver
    implements EntityResolver {
        static volatile SunDDResolver resolver;

        private SunDDResolver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static SunDDResolver getInstance() {
            if (resolver != null) return resolver;
            Class<SunDDResolver> clazz = SunDDResolver.class;
            synchronized (SunDDResolver.class) {
                if (resolver != null) return resolver;
                resolver = new SunDDResolver();
                // ** MonitorExit[var0] (shouldn't be in output)
                return resolver;
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            InputSource source = null;
            DocTypeInfo info = (DocTypeInfo)publicIdToInfoMap.get(publicId);
            if (info != null) {
                String resource = info.getResourceDtd();
                URL url = this.getClass().getResource(resource);
                source = new InputSource(url.toString());
            }
            return source;
        }
    }

    private static class VersionInfo {
        private Class implClass;
        private Class proxyClass;
        private String publicId;
        private String systemId;

        public VersionInfo(Class implClass, Class proxyClass, String publicId, String systemId) {
            this.implClass = implClass;
            this.proxyClass = proxyClass;
            this.publicId = publicId;
            this.systemId = systemId;
        }

        public Class getImplClass() {
            return this.implClass;
        }

        public Class getProxyClass() {
            return this.proxyClass;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }
}

