/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import com.sun.source.util.TreePath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.common.DatasourceUIHelper;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.action.UseDatabaseGenerator;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.SelectDatabasePanel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.SendEmailCodeGenerator;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class UseDatabaseCodeGenerator
implements CodeGenerator {
    private FileObject fileObject;
    private TypeElement beanClass;

    static UseDatabaseCodeGenerator createUseDatabaseAction(JTextComponent component, CompilationController cc, Element el) throws IOException {
        if (el.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement typeElement = (TypeElement)el;
        if (!UseDatabaseCodeGenerator.isEnable(cc.getFileObject(), typeElement)) {
            return null;
        }
        return new UseDatabaseCodeGenerator(cc.getFileObject(), typeElement);
    }

    public UseDatabaseCodeGenerator(FileObject srcFile, TypeElement beanClass) {
        this.fileObject = srcFile;
        this.beanClass = beanClass;
    }

    public void invoke() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
        EnterpriseReferenceContainer enterpriseReferenceContainer = (EnterpriseReferenceContainer)project.getLookup().lookup(EnterpriseReferenceContainer.class);
        ResourcesHolder holder = this.getResources(j2eeModuleProvider, this.fileObject);
        final SelectDatabasePanel selectDatabasePanel = new SelectDatabasePanel(j2eeModuleProvider, enterpriseReferenceContainer.getServiceLocatorName(), holder.getReferences(), holder.getModuleDataSources(), holder.getServerDataSources(), ClasspathInfo.create((FileObject)this.fileObject));
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)selectDatabasePanel, NbBundle.getMessage(UseDatabaseCodeGenerator.class, (String)"LBL_ChooseDatabase"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(SelectDatabasePanel.class), null);
        final NotificationLineSupport notificationSupport = dialogDescriptor.createNotificationLineSupport();
        dialogDescriptor.setValid(this.checkConnections(selectDatabasePanel));
        selectDatabasePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("SelectDatabasePanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    Boolean booleanValue = (Boolean)newvalue;
                    if (booleanValue.booleanValue()) {
                        dialogDescriptor.setValid(true);
                        notificationSupport.clearMessages();
                    } else {
                        dialogDescriptor.setValid(false);
                        notificationSupport.setErrorMessage(selectDatabasePanel.getErrorMessage());
                    }
                }
            }
        });
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (option == NotifyDescriptor.OK_OPTION) {
            String refName = selectDatabasePanel.getDatasourceReference();
            UseDatabaseGenerator generator = new UseDatabaseGenerator();
            try {
                generator.generate(this.fileObject, this.beanClass.getQualifiedName().toString(), j2eeModuleProvider, refName, selectDatabasePanel.getDatasource(), selectDatabasePanel.createServerResources(), selectDatabasePanel.getServiceLocator());
            }
            catch (ConfigurationException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private ResourcesHolder getResources(final J2eeModuleProvider j2eeModuleProvider, final FileObject fileObject) {
        final ResourcesHolder holder = new ResourcesHolder();
        ArrayList<2> asyncActions = new ArrayList<2>(1);
        asyncActions.add(new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context actionContext) {
                String msg = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_retrievingDS");
                actionContext.progress(msg);
                try {
                    UseDatabaseCodeGenerator.this.populateDataSourceReferences(holder, j2eeModuleProvider, fileObject);
                }
                catch (ConfigurationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        });
        ProgressSupport.invoke(asyncActions);
        return holder;
    }

    private void populateDataSourceReferences(final ResourcesHolder holder, final J2eeModuleProvider j2eeModuleProvider, FileObject fileObject) throws ConfigurationException, IOException {
        final HashMap<String, Datasource> references = new HashMap<String, Datasource>();
        holder.setReferences(references);
        holder.setModuleDataSources(j2eeModuleProvider.getConfigSupport().getDatasources());
        holder.setServerDataSources(j2eeModuleProvider.getServerDatasources());
        if (j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.EJB)) {
            MetadataModel metadataModel = EjbJar.getEjbJar((FileObject)fileObject).getMetadataModel();
            metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                public Void run(EjbJarMetadata metadata) throws Exception {
                    Ejb[] ejbs;
                    EnterpriseBeans beans = metadata.getRoot().getEnterpriseBeans();
                    if (beans == null) {
                        return null;
                    }
                    for (Ejb ejb : ejbs = beans.getEjbs()) {
                        ResourceRef[] refs;
                        for (ResourceRef ref : refs = ejb.getResourceRef()) {
                            String refName = ref.getResRefName();
                            Datasource ds = UseDatabaseCodeGenerator.this.findDatasourceForReferenceForEjb(holder, j2eeModuleProvider, refName, ejb.getEjbName());
                            if (ds == null) continue;
                            references.put(refName, ds);
                        }
                    }
                    return null;
                }
            });
        } else if (j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.WAR)) {
            MetadataModel metadataModel = WebModule.getWebModule((FileObject)fileObject).getMetadataModel();
            metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, Void>(){

                public Void run(WebAppMetadata metadata) throws Exception {
                    List refs = metadata.getResourceRefs();
                    for (ResourceRef ref : refs) {
                        String refName = ref.getResRefName();
                        Datasource ds = UseDatabaseCodeGenerator.this.findDatasourceForReference(holder, j2eeModuleProvider, refName);
                        if (ds == null) continue;
                        references.put(refName, ds);
                    }
                    return null;
                }
            });
        }
    }

    private Datasource findDatasourceForReference(ResourcesHolder holder, J2eeModuleProvider j2eeModuleProvider, String referenceName) throws ConfigurationException {
        String jndiName = j2eeModuleProvider.getConfigSupport().findDatasourceJndiName(referenceName);
        if (jndiName == null) {
            return null;
        }
        return this.findDataSource(holder, jndiName);
    }

    public Datasource findDatasourceForReferenceForEjb(ResourcesHolder holder, J2eeModuleProvider j2eeModuleProvider, String referenceName, String ejbName) throws ConfigurationException {
        String jndiName = j2eeModuleProvider.getConfigSupport().findDatasourceJndiNameForEjb(ejbName, referenceName);
        if (jndiName == null) {
            return null;
        }
        return this.findDataSource(holder, jndiName);
    }

    private Datasource findDataSource(ResourcesHolder holder, String jndiName) {
        assert (holder != null);
        assert (jndiName != null);
        for (Datasource ds : holder.getModuleDataSources()) {
            if (!jndiName.equals(ds.getJndiName())) continue;
            return ds;
        }
        for (Datasource ds : holder.getServerDataSources()) {
            if (!jndiName.equals(ds.getJndiName())) continue;
            return ds;
        }
        return null;
    }

    private static boolean isEnable(FileObject fileObject, TypeElement typeElement) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return false;
        }
        if (project.getLookup().lookup(EnterpriseReferenceContainer.class) == null) {
            return false;
        }
        return ElementKind.INTERFACE != typeElement.getKind();
    }

    private boolean checkConnections(SelectDatabasePanel selectDatabasePanel) {
        return selectDatabasePanel.getDatasource() != null;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UseDatabaseCodeGenerator.class, (String)"LBL_UseDbAction");
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<UseDatabaseCodeGenerator> ret = new ArrayList<UseDatabaseCodeGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            TreePath path = (TreePath)context.lookup(TreePath.class);
            TreePath treePath = path = path != null ? SendEmailCodeGenerator.getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path) : null;
            if (component == null || controller == null || path == null) {
                return ret;
            }
            try {
                UseDatabaseCodeGenerator gen;
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element elem = controller.getTrees().getElement(path);
                if (elem != null && (gen = UseDatabaseCodeGenerator.createUseDatabaseAction(component, controller, elem)) != null) {
                    ret.add(gen);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return ret;
        }
    }

    private static final class ResourcesHolder {
        private Map<String, Datasource> references;
        private Set<Datasource> moduleDataSources;
        private Set<Datasource> serverDataSources;

        public void setReferences(Map<String, Datasource> references) {
            this.references = references;
        }

        public void setModuleDataSources(Set<Datasource> moduleDataSources) {
            this.moduleDataSources = moduleDataSources;
        }

        public void setServerDataSources(Set<Datasource> serverDataSources) {
            this.serverDataSources = serverDataSources;
        }

        public Map<String, Datasource> getReferences() {
            if (this.references == null) {
                this.references = new HashMap<String, Datasource>();
            }
            return this.references;
        }

        public Set<Datasource> getModuleDataSources() {
            if (this.moduleDataSources == null) {
                this.moduleDataSources = new HashSet<Datasource>();
            }
            return this.moduleDataSources;
        }

        public Set<Datasource> getServerDataSources() {
            if (this.serverDataSources == null) {
                this.serverDataSources = new HashSet<Datasource>();
            }
            return this.serverDataSources;
        }
    }
}

