/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MessageDestinationUiSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MessageEJBWizardVisualPanel
extends JPanel {
    public static final String CHANGED = MessageEJBWizardVisualPanel.class.getName() + ".CHANGED";
    private final J2eeModuleProvider provider;
    private final Set<MessageDestination> moduleDestinations;
    private final Set<MessageDestination> serverDestinations;
    private final boolean isDestinationCreationSupportedByServerPlugin;
    private JButton addButton;
    private ButtonGroup destinationsGroup;
    private JComboBox projectDestinationsCombo;
    private JRadioButton projectDestinationsRadio;
    private JComboBox serverDestinationsCombo;
    private JRadioButton serverDestinationsRadio;

    private MessageEJBWizardVisualPanel(J2eeModuleProvider provider, Set<MessageDestination> moduleDestinations, Set<MessageDestination> serverDestinations) {
        this.initComponents();
        this.provider = provider;
        this.moduleDestinations = moduleDestinations;
        this.serverDestinations = serverDestinations;
        this.isDestinationCreationSupportedByServerPlugin = provider.getConfigSupport().supportsCreateMessageDestination();
    }

    public static MessageEJBWizardVisualPanel newInstance(J2eeModuleProvider provider, Set<MessageDestination> moduleDestinations, Set<MessageDestination> serverDestinations) {
        MessageEJBWizardVisualPanel mdp = new MessageEJBWizardVisualPanel(provider, moduleDestinations, serverDestinations);
        mdp.initialize();
        return mdp;
    }

    public MessageDestination getDestination() {
        if (this.projectDestinationsRadio.isSelected()) {
            return (MessageDestination)this.projectDestinationsCombo.getSelectedItem();
        }
        if (this.serverDestinationsRadio.isSelected()) {
            return (MessageDestination)this.serverDestinationsCombo.getSelectedItem();
        }
        return null;
    }

    public boolean isServerConfigured() {
        String id = this.provider.getServerInstanceID();
        try {
            return id != null && Deployment.getDefault().getServerInstance(id).getJ2eePlatform() != null;
        }
        catch (InstanceRemovedException ex) {
            return false;
        }
    }

    private void initialize() {
        this.registerListeners();
        this.setupAddButton();
        this.handleComboBoxes();
        this.populate();
    }

    private void registerListeners() {
        this.projectDestinationsRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageEJBWizardVisualPanel.this.fire();
                MessageEJBWizardVisualPanel.this.handleComboBoxes();
            }
        });
        this.serverDestinationsRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageEJBWizardVisualPanel.this.fire();
                MessageEJBWizardVisualPanel.this.handleComboBoxes();
            }
        });
        this.projectDestinationsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageEJBWizardVisualPanel.this.fire();
            }
        });
        this.serverDestinationsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageEJBWizardVisualPanel.this.fire();
            }
        });
    }

    private void setupAddButton() {
        if (!this.isDestinationCreationSupportedByServerPlugin) {
            this.addButton.setEnabled(false);
        }
    }

    private void handleComboBoxes() {
        this.projectDestinationsCombo.setEnabled(this.projectDestinationsRadio.isSelected());
        this.serverDestinationsCombo.setEnabled(this.serverDestinationsRadio.isSelected());
    }

    private void populate() {
        MessageDestinationUiSupport.populateDestinations(this.moduleDestinations, this.projectDestinationsCombo, null);
        MessageDestinationUiSupport.populateDestinations(this.serverDestinations, this.serverDestinationsCombo, null);
    }

    private void fire() {
        this.firePropertyChange(CHANGED, null, null);
    }

    private void initComponents() {
        this.destinationsGroup = new ButtonGroup();
        this.projectDestinationsRadio = new JRadioButton();
        this.serverDestinationsRadio = new JRadioButton();
        this.projectDestinationsCombo = new JComboBox();
        this.addButton = new JButton();
        this.serverDestinationsCombo = new JComboBox();
        this.destinationsGroup.add(this.projectDestinationsRadio);
        this.projectDestinationsRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.projectDestinationsRadio, (String)NbBundle.getMessage(MessageEJBWizardVisualPanel.class, (String)"LBL_ProjectDestinations"));
        this.projectDestinationsRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projectDestinationsRadio.setMargin(new Insets(0, 0, 0, 0));
        this.destinationsGroup.add(this.serverDestinationsRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.serverDestinationsRadio, (String)NbBundle.getMessage(MessageEJBWizardVisualPanel.class, (String)"LBL_ServerDestinations"));
        this.serverDestinationsRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.serverDestinationsRadio.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(MessageEJBWizardVisualPanel.class, (String)"LBL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageEJBWizardVisualPanel.this.addButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectDestinationsRadio).addComponent(this.serverDestinationsRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serverDestinationsCombo, 0, 261, Short.MAX_VALUE).addComponent(this.projectDestinationsCombo, 0, 261, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectDestinationsRadio).addComponent(this.addButton).addComponent(this.projectDestinationsCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverDestinationsRadio).addComponent(this.serverDestinationsCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        MessageDestination destination = MessageDestinationUiSupport.createMessageDestination(this.provider, this.moduleDestinations, this.serverDestinations);
        if (destination != null) {
            this.moduleDestinations.add(destination);
            MessageDestinationUiSupport.populateDestinations(this.moduleDestinations, this.projectDestinationsCombo, destination);
        }
    }
}

