/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.tree;

import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class FolderTreeElement
implements TreeElement {
    private FileObject fo;

    FolderTreeElement(FileObject fo) {
        this.fo = fo;
    }

    public TreeElement getParent(boolean isLogical) {
        if (isLogical) {
            SourceGroup sg = FolderTreeElement.getSourceGroup(this.fo);
            if (sg != null) {
                return TreeElementFactory.getTreeElement((Object)sg);
            }
            return null;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)this.fo);
        if (p != null) {
            return TreeElementFactory.getTreeElement((Object)p);
        }
        return null;
    }

    public Icon getIcon() {
        return ElementIcons.getElementIcon((ElementKind)ElementKind.PACKAGE, null);
    }

    public String getText(boolean isLogical) {
        ClassPath cp = ClassPath.getClassPath((FileObject)this.fo, (String)"classpath/source");
        if (cp == null) {
            return this.fo.getPath();
        }
        if (FolderTreeElement.getJavaSourceGroup(this.fo) != null) {
            String resourceName = cp.getResourceName(this.fo);
            if (resourceName == null) {
                return this.fo.getPath();
            }
            String name = resourceName.replace('/', '.');
            if ("".equals(name)) {
                return NbBundle.getMessage(FolderTreeElement.class, (String)"LBL_DefaultPackage_PDU");
            }
            return name;
        }
        return this.fo.getPath();
    }

    static SourceGroup getSourceGroup(FileObject file) {
        SourceGroup[] xmlgroups;
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        if (prj == null) {
            return null;
        }
        Sources src = ProjectUtils.getSources((Project)prj);
        SourceGroup[] javagroups = src.getSourceGroups("java");
        SourceGroup[] allgroups = new SourceGroup[javagroups.length + (xmlgroups = src.getSourceGroups("xml")).length];
        if (allgroups.length < 1) {
            Logger.getLogger(FolderTreeElement.class.getName()).severe("Cannot find SourceGroup for " + file.getPath());
            return null;
        }
        System.arraycopy(javagroups, 0, allgroups, 0, javagroups.length);
        System.arraycopy(xmlgroups, 0, allgroups, allgroups.length - 1, xmlgroups.length);
        for (int i = 0; i < allgroups.length; ++i) {
            if (!allgroups[i].getRootFolder().equals(file) && !FileUtil.isParentOf((FileObject)allgroups[i].getRootFolder(), (FileObject)file)) continue;
            return allgroups[i];
        }
        return null;
    }

    private static SourceGroup getJavaSourceGroup(FileObject file) {
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        if (prj == null) {
            return null;
        }
        Sources src = ProjectUtils.getSources((Project)prj);
        SourceGroup[] javagroups = src.getSourceGroups("java");
        for (int i = 0; i < javagroups.length; ++i) {
            if (!javagroups[i].getRootFolder().equals(file) && !FileUtil.isParentOf((FileObject)javagroups[i].getRootFolder(), (FileObject)file)) continue;
            return javagroups[i];
        }
        return null;
    }

    public Object getUserObject() {
        return this.fo;
    }
}

