/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.Pair;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.ui.JavaRefactoringUIFactory;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.java.ui.WhereUsedPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedQueryUI
implements RefactoringUI,
Openable,
JavaRefactoringUIFactory {
    private WhereUsedQuery query = null;
    private String name;
    private WhereUsedPanel panel;
    private TreePathHandle element;
    private ElementHandle<Element> elementHandle;
    private ElementKind kind;
    private AbstractRefactoring delegate;
    private final List<Pair<Pair<String, Icon>, TreePathHandle>> classes;
    private ResourceBundle bundle;

    private WhereUsedQueryUI() {
        this.classes = null;
    }

    private WhereUsedQueryUI(TreePathHandle handle, Element el, List<Pair<Pair<String, Icon>, TreePathHandle>> classes) {
        this.query = new WhereUsedQuery(Lookups.singleton((Object)handle));
        this.query.getContext().add((Object)RefactoringUtils.getClasspathInfoFor(handle));
        this.element = handle;
        if (UIUtilities.allowedElementKinds.contains((Object)this.element.getKind())) {
            this.elementHandle = ElementHandle.create((Element)el);
        }
        this.kind = el.getKind();
        this.name = this.kind == ElementKind.CONSTRUCTOR ? el.getEnclosingElement().getSimpleName().toString() : el.getSimpleName().toString();
        this.classes = classes;
    }

    public WhereUsedQueryUI(TreePathHandle handle, String name, AbstractRefactoring delegate) {
        this.delegate = delegate;
        this.element = handle;
        this.name = name;
        this.classes = null;
    }

    public boolean isQuery() {
        return true;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = WhereUsedPanel.create(this.name, this.element, this.kind, this.classes, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.query.putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.panel.isSearchInComments());
        Scope customScope = this.panel.getCustomScope();
        if (customScope != null) {
            this.query.getContext().add((Object)customScope);
        } else {
            this.query.getContext().remove(Scope.class);
        }
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.checkParameters();
        }
        if (this.kind.isClass() || this.kind.isInterface()) {
            this.setForClass();
            return this.query.checkParameters();
        }
        return null;
    }

    private void setForMethod() {
        this.query.getContext().add((Object)this.element);
        this.query.setRefactoringSource(Lookups.singleton((Object)this.panel.getMethodHandle()));
        this.query.putValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS, (Object)this.panel.isMethodFromBaseClass());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)this.panel.isMethodOverriders());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isMethodFindUsages());
    }

    private void setForClass() {
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)this.panel.isClassSubTypes());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES, (Object)this.panel.isClassSubTypesDirectOnly());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isClassFindUsages());
    }

    public Problem checkParameters() {
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.fastCheckParameters();
        }
        if (this.kind.isClass() || this.kind.isInterface()) {
            this.setForClass();
            return this.query.fastCheckParameters();
        }
        return null;
    }

    public AbstractRefactoring getRefactoring() {
        return this.query != null ? this.query : this.delegate;
    }

    public String getDescription() {
        boolean isScanning = SourceUtils.isScanInProgress();
        String desc = null;
        if (this.panel != null && this.kind != null) {
            switch (this.kind) {
                case CONSTRUCTOR: {
                    if (this.panel.isMethodFindUsages() && this.panel.isMethodOverriders()) {
                        desc = this.getString("DSC_WhereUsedAndOverriders", this.name);
                        break;
                    }
                    if (this.panel.isMethodFindUsages()) {
                        desc = this.getString("DSC_WhereUsed", this.name);
                        break;
                    }
                    if (!this.panel.isMethodOverriders()) break;
                    desc = this.getString("DSC_WhereUsedMethodOverriders", this.name);
                    break;
                }
                case METHOD: {
                    if (this.panel.isMethodFindUsages() && this.panel.isMethodOverriders()) {
                        desc = this.getString("DSC_WhereUsedAndOverriders", this.panel.getMethodDeclaringClass() + '.' + this.name);
                        break;
                    }
                    if (this.panel.isMethodFindUsages()) {
                        desc = this.getString("DSC_WhereUsed", this.panel.getMethodDeclaringClass() + '.' + this.name);
                        break;
                    }
                    if (!this.panel.isMethodOverriders()) break;
                    desc = this.getString("DSC_WhereUsedMethodOverriders", this.panel.getMethodDeclaringClass() + '.' + this.name);
                    break;
                }
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case ANNOTATION_TYPE: {
                    if (this.panel.isClassFindUsages()) break;
                    if (!this.panel.isClassSubTypesDirectOnly()) {
                        desc = this.getString("DSC_WhereUsedFindAllSubTypes", this.name);
                        break;
                    }
                    desc = this.getString("DSC_WhereUsedFindDirectSubTypes", this.name);
                    break;
                }
                case PACKAGE: {
                    break;
                }
            }
        }
        if (desc == null) {
            desc = this.getString("DSC_WhereUsed", this.name);
        }
        if (isScanning) {
            return this.getString("DSC_Scan_Warning", desc);
        }
        return desc;
    }

    private String getString(String key) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(WhereUsedQueryUI.class);
        }
        return this.bundle.getString(key);
    }

    private String getString(String key, String value) {
        return new MessageFormat(this.getString(key)).format(new Object[]{value});
    }

    public String getName() {
        return new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_UsagesOf")).format(new Object[]{this.name});
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI");
    }

    public void open() {
        if (this.elementHandle != null) {
            ElementOpen.open((FileObject)this.element.getFileObject(), this.elementHandle);
        }
    }

    @Override
    public RefactoringUI create(CompilationInfo info, TreePathHandle[] handles, FileObject[] files, NonRecursiveFolder[] packages) {
        LinkedList<Pair<Pair<String, Icon>, TreePathHandle>> classes;
        if (handles.length < 1 || handles[0] == null) {
            return null;
        }
        TreePathHandle handle = handles[0];
        Element el = handle.resolveElement(info);
        if (el == null) {
            return null;
        }
        if (el.getKind() == ElementKind.CONSTRUCTOR || el.getKind() == ElementKind.METHOD) {
            ExecutableElement method = (ExecutableElement)el;
            classes = new LinkedList<Pair<Pair<String, Icon>, TreePathHandle>>();
            Element enclosingElement = method.getEnclosingElement();
            String methodDeclaringClass = enclosingElement.getSimpleName().toString();
            Icon icon = ElementIcons.getElementIcon((ElementKind)enclosingElement.getKind(), enclosingElement.getModifiers());
            classes.add(Pair.of(Pair.of(methodDeclaringClass, icon), handle));
            Collection<ExecutableElement> overridens = JavaRefactoringUtils.getOverriddenMethods(method, info);
            for (ExecutableElement executableElement : overridens) {
                Element enclosingTypeElement = executableElement.getEnclosingElement();
                String elName = enclosingTypeElement.getSimpleName().toString();
                TreePathHandle tph = TreePathHandle.create((Element)executableElement, (CompilationInfo)info);
                Icon typeIcon = ElementIcons.getElementIcon((ElementKind)enclosingTypeElement.getKind(), enclosingTypeElement.getModifiers());
                classes.add(Pair.of(Pair.of(elName, typeIcon), tph));
            }
        } else {
            if (el.getKind() == ElementKind.PACKAGE) {
                return null;
            }
            classes = null;
        }
        return new WhereUsedQueryUI(handle, el, classes);
    }

    public static JavaRefactoringUIFactory factory() {
        return new WhereUsedQueryUI();
    }
}

